/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiactng.agentcore.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryDebugger {
    private static final MemoryPoolMXBean TENURED_GEN_POOL = MemoryDebugger.findTenuredGenPool();
    private static boolean initialised = false;

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    public static void setup() {
        MemoryDebugger.setup(0.75);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setup(double fraction) {
        Class<MemoryDebugger> clazz = MemoryDebugger.class;
        synchronized (MemoryDebugger.class) {
            if (!initialised) {
                long maxMemory = TENURED_GEN_POOL.getUsage().getMax();
                TENURED_GEN_POOL.setUsageThreshold((long)(fraction * (double)maxMemory));
                MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();
                ((NotificationEmitter)((Object)mxBean)).addNotificationListener(new NotificationListenerImpl(), null, null);
                initialised = true;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    static class NotificationListenerImpl
    implements NotificationListener {
        NotificationListenerImpl() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification.getType().equals("java.management.memory.threshold.exceeded")) {
                Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
                for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                    this.printStackTrace(entry.getKey().getName(), entry.getValue());
                }
            }
        }

        private void printStackTrace(String name, StackTraceElement[] elements) {
            System.err.println("Thread " + name + " computes: ");
            for (int i = 0; i < elements.length; ++i) {
                System.err.println("\tat " + elements[i]);
            }
        }
    }
}

