/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.IMatchmakerPlugin;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Matchmaker {
    private Logger logger = Logger.getLogger(this.getClass());
    private String className;
    private URL mainJar;
    private Vector<URL> libraries = new Vector();
    private String name = null;
    private URLClassLoader pluginClassLoader = null;

    private Matchmaker() {
    }

    public String getName() {
        return this.name;
    }

    public IMatchmakerPlugin getPluginInstance() {
        try {
            if (this.pluginClassLoader == null) {
                URL[] jarFiles = new URL[this.libraries.size() + 1];
                this.libraries.toArray(jarFiles);
                jarFiles[this.libraries.size()] = this.mainJar;
                this.pluginClassLoader = new URLClassLoader(jarFiles, this.getClass().getClassLoader());
            }
            return (IMatchmakerPlugin)this.pluginClassLoader.loadClass(this.className).newInstance();
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)("Could not find class for the matchmaker plugin " + this.name + "."), (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            this.logger.error((Object)("Could not instantiate matchmaker plugin " + this.name + "."), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            this.logger.error((Object)("Matchmaker plugin constructor for " + this.name + " is not accessible."), (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    public static Matchmaker parse(String xmlFileName) {
        Matchmaker matchmaker = new Matchmaker();
        try {
            File xmlFile = new File(xmlFileName);
            xmlFileName = xmlFile.getAbsolutePath();
            String path = xmlFileName.substring(0, xmlFileName.lastIndexOf(File.separator));
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlFileName);
            NodeList nodes = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node configNode = nodes.item(i);
                if (configNode.getNodeType() == 1) {
                    String configNodeName = configNode.getNodeName();
                    if (configNodeName.equals("jar")) {
                        String jarFile = configNode.getTextContent();
                        matchmaker.mainJar = new File(String.valueOf(path) + File.separator + jarFile).toURI().toURL();
                    } else if (configNodeName.equals("class")) {
                        matchmaker.className = configNode.getTextContent();
                    } else if (configNodeName.equals("directory")) {
                        String dirName = configNode.getTextContent();
                        Node attribute = configNode.getAttributes().getNamedItem("recursive");
                        boolean recursive = false;
                        if (attribute != null && attribute.getNodeValue().equals("true")) {
                            recursive = true;
                        }
                        matchmaker.parseLibs(String.valueOf(path) + File.separator + dirName, recursive);
                    } else if (configNodeName.equals("lib")) {
                        String libName = configNode.getTextContent();
                        matchmaker.libraries.add(new File(String.valueOf(path) + File.separator + libName).toURI().toURL());
                    } else if (configNodeName.equals("name")) {
                        matchmaker.name = configNode.getTextContent();
                    }
                }
                ++i;
            }
            if (matchmaker.name == null) {
                matchmaker.name = xmlFile.getName().replaceFirst(".xml", "");
            }
        }
        catch (SAXException e) {
            matchmaker.logger.warn((Object)("Parsing error while processing " + xmlFileName + "."), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            matchmaker.logger.warn((Object)("File " + xmlFileName + " not found. Unable to parse matchmaker configuration file"), (Throwable)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            matchmaker.logger.warn((Object)"Unable to create XML parser.", (Throwable)e);
            return null;
        }
        return matchmaker;
    }

    private void parseLibs(String dirName, boolean recursive) {
        File dir = new File(dirName);
        String[] stringArray = dir.list();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String listItemName = stringArray[n];
            String temp = String.valueOf(dirName) + File.separator + listItemName;
            File listItem = new File(temp);
            if (listItem.isDirectory()) {
                if (recursive) {
                    this.parseLibs(temp, recursive);
                }
            } else if (temp.endsWith(".jar")) {
                try {
                    this.libraries.add(listItem.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    this.logger.warn((Object)(String.valueOf(temp) + " is no valid URL pointing to a jar library."), (Throwable)e);
                }
            }
            ++n;
        }
    }
}

