/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.Configuration;
import de.dfki.sme2.IMatchmakerPlugin;
import de.dfki.sme2.Matchmaker;
import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.MemoryMonitor;
import de.dfki.sme2.TestCollection;
import de.dfki.sme2.util.metric.MacroAvgRecallFallout;
import de.dfki.sme2.util.metric.MacroAvgRecallPrecision;
import de.dfki.sme2.util.metric.MicroAvgRecallFallout;
import de.dfki.sme2.util.metric.MicroAvgRecallPrecision;
import de.dfki.sme2.util.metric.RecallPrecisionPair;
import de.dfki.sme2.util.metric.SingleQueryMeasures;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MatchmakerEvaluation {
    protected static Logger logger = Logger.getLogger(MatchmakerEvaluation.class);
    protected Configuration config;
    protected MemoryMonitor memMonitor;

    public MatchmakerEvaluation(Configuration config) {
        this.config = config;
    }

    public MatchmakerEvaluationResult[] evaluate() {
        MatchmakerEvaluationResult[] results = new MatchmakerEvaluationResult[this.config.getSelectedMatchmakers().size()];
        int i = 0;
        for (Matchmaker matchmaker : this.config.getSelectedMatchmakers()) {
            results[i++] = this.evaluate(matchmaker);
        }
        return results;
    }

    protected MatchmakerEvaluationResult evaluate(Matchmaker matchmaker) {
        ArrayList<RecallPrecisionPair> rpValues;
        Set<URL> binaryRelevants;
        IMatchmakerPlugin plugin = matchmaker.getPluginInstance();
        if (this.config.isCheckMemory()) {
            this.memMonitor = new MemoryMonitor();
            new Thread(this.memMonitor).start();
        }
        Date startTime = null;
        if (this.config.isCheckExecTime()) {
            startTime = new Date();
        }
        this.registerServiceOffers(plugin, matchmaker.getName());
        MatchmakerEvaluationResult evalResult = new MatchmakerEvaluationResult(matchmaker.getName(), this.config.getTestCollection().getName());
        this.sendRequestsToMatchmaker(plugin, matchmaker.getName(), evalResult);
        if (this.config.isCheckExecTime()) {
            long totalExecTime = new Date().getTime() - startTime.getTime();
            evalResult.setTotalExecutionTime(totalExecTime);
        }
        if (this.config.isCheckMemory()) {
            this.memMonitor.stop();
            evalResult.setMemoryConsumption(this.memMonitor.getMemoryConsumptionPerInterval());
        }
        TestCollection tc = this.config.getTestCollection();
        if ((this.config.isCheckRP() || this.config.isCheckF1()) && this.config.isUseMacroAvg()) {
            MacroAvgRecallPrecision macroRP = new MacroAvgRecallPrecision(this.config.getLambda());
            for (URL query : tc.getQueries()) {
                binaryRelevants = this.config.getTestCollection().getRelevanceSet(query).getBinaryRelevants();
                macroRP.processRecallPrecision(evalResult.getRanking(query), new ArrayList<URL>(binaryRelevants));
            }
            evalResult.setMacroAvgRP(macroRP.getMacroAveragePrecisions());
        }
        if (this.config.isCheckF1() && this.config.isUseMacroAvg()) {
            rpValues = evalResult.getMacroAvgRP();
            evalResult.setMacroAvgF1(rpValues);
        }
        if (this.config.isCheckRF() && this.config.isUseMacroAvg()) {
            MacroAvgRecallFallout macroRF = new MacroAvgRecallFallout(this.config.getLambda());
            for (URL query : tc.getQueries()) {
                binaryRelevants = this.config.getTestCollection().getRelevanceSet(query).getBinaryRelevants();
                macroRF.processRecallFallout(evalResult.getRanking(query), new ArrayList<URL>(binaryRelevants), tc.getNumberOfServiceOffers());
            }
            evalResult.setMacroAvgRF(macroRF.getMacroAverageFallouts());
        }
        if ((this.config.isCheckRP() || this.config.isCheckF1()) && this.config.isUseMicroAvg()) {
            MicroAvgRecallPrecision microRP = new MicroAvgRecallPrecision(this.config.getLambda());
            for (URL query : tc.getQueries()) {
                binaryRelevants = this.config.getTestCollection().getRelevanceSet(query).getBinaryRelevants();
                microRP.processRecallPrecision(evalResult.getRanking(query), new ArrayList<URL>(binaryRelevants));
            }
            evalResult.setMicroAvgRP(microRP.getMicroAveragePrecisions());
        }
        if (this.config.isCheckF1() && this.config.isUseMicroAvg()) {
            rpValues = evalResult.getMicroAvgRP();
            evalResult.setMicroAvgF1(rpValues);
        }
        if (this.config.isCheckRF() && this.config.isUseMicroAvg()) {
            MicroAvgRecallFallout microRF = new MicroAvgRecallFallout(this.config.getLambda());
            for (URL query : tc.getQueries()) {
                binaryRelevants = this.config.getTestCollection().getRelevanceSet(query).getBinaryRelevants();
                microRF.processRecallFallout(evalResult.getRanking(query), new ArrayList<URL>(binaryRelevants), tc.getNumberOfServiceOffers());
            }
            evalResult.setMicroAvgRF(microRF.getMicroAverageFallouts());
        }
        if (this.config.isCheckAP()) {
            for (URL query : tc.getQueries()) {
                Set<URL> binaryRelevants2 = this.config.getTestCollection().getRelevanceSet(query).getBinaryRelevants();
                evalResult.addAP(query, SingleQueryMeasures.getAveragePrecision(evalResult.getRanking(query), binaryRelevants2));
            }
        }
        if (this.config.isCheckAPPrime()) {
            for (URL query : tc.getQueries()) {
                evalResult.addAPPrime(query, SingleQueryMeasures.getAveragePrecisionPrime(evalResult.getRanking(query), this.config.getTestCollection().getRelevanceSet(query)));
            }
        }
        if (this.config.isCheckQ()) {
            for (URL query : tc.getQueries()) {
                evalResult.addQ(query, SingleQueryMeasures.getQ(evalResult.getRanking(query), this.config.getTestCollection().getRelevanceSet(query)));
            }
        }
        if (this.config.isCheckQPrime()) {
            for (URL query : tc.getQueries()) {
                evalResult.addQPrime(query, SingleQueryMeasures.getQPrime(evalResult.getRanking(query), this.config.getTestCollection().getRelevanceSet(query)));
            }
        }
        if (this.config.isCheckNDCG()) {
            for (URL query : tc.getQueries()) {
                evalResult.addNDCG(query, SingleQueryMeasures.getNDCG(evalResult.getRanking(query), this.config.getTestCollection().getRelevanceSet(query)));
            }
        }
        if (this.config.isCheckNDCGPrime()) {
            for (URL query : tc.getQueries()) {
                evalResult.addNDCGPrime(query, SingleQueryMeasures.getNDCGPrime(evalResult.getRanking(query), this.config.getTestCollection().getRelevanceSet(query)));
            }
        }
        return evalResult;
    }

    protected void registerServiceOffers(IMatchmakerPlugin plugin, String matchmakerName) {
        TestCollection tc = this.config.getTestCollection();
        int i = 1;
        for (URL serviceOffer : tc.getServiceOffers()) {
            logger.info((Object)(String.valueOf(serviceOffer.toString()) + " registering as offer (" + i++ + " of " + this.config.getTestCollection().getNumberOfServiceOffers() + ") at " + matchmakerName + "..."));
            this.registerServiceOffer(serviceOffer, plugin, matchmakerName);
        }
    }

    protected void registerServiceOffer(URL serviceOffer, IMatchmakerPlugin plugin, String matchmakerName) {
        try {
            plugin.input(serviceOffer);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to register " + serviceOffer + " at " + matchmakerName + "."), (Throwable)e);
        }
    }

    protected void sendRequestsToMatchmaker(IMatchmakerPlugin plugin, String matchmakerName, MatchmakerEvaluationResult evalResult) {
        TestCollection tc = this.config.getTestCollection();
        for (URL query : tc.getQueries()) {
            try {
                logger.info((Object)("Queried " + matchmakerName + " for " + query.toString() + "."));
                this.queryMatchmaker(query, plugin, matchmakerName, evalResult);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to query " + matchmakerName + " for " + query + "."), (Throwable)e);
            }
        }
    }

    protected void queryMatchmaker(URL query, IMatchmakerPlugin plugin, String matchmakerName, MatchmakerEvaluationResult evalResult) {
        try {
            Date queryStart = null;
            if (this.config.isCheckQRT()) {
                queryStart = new Date();
            }
            Hashtable<URL, Vector<URL>> result = plugin.query(query);
            if (this.config.isCheckQRT()) {
                long qrt = new Date().getTime() - queryStart.getTime();
                evalResult.addQueryResponseTime(query, qrt);
            }
            evalResult.addRanking(query, result.get(query));
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to query " + matchmakerName + " for " + query + "."), (Throwable)e);
            evalResult.addRanking(query, new Vector<URL>());
        }
    }
}

