/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.util.metric.RecallFalloutPair;
import de.dfki.sme2.util.metric.RecallPrecisionPair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MatchmakerEvaluationResult {
    private static Logger logger = Logger.getLogger(MatchmakerEvaluationResult.class);
    private long totalExecutionTime = -1L;
    private HashMap<URL, Vector<URL>> rankings = new HashMap();
    private ArrayList<RecallPrecisionPair> macroAvgRP = null;
    private ArrayList<RecallPrecisionPair> microAvgRP = null;
    private ArrayList<Double> macroAvgF1 = null;
    private ArrayList<Double> microAvgF1 = null;
    private ArrayList<RecallFalloutPair> macroAvgRF = null;
    private ArrayList<RecallFalloutPair> microAvgRF = null;
    private HashMap<URL, Long> queryResponseTimes = null;
    private ArrayList<Long> memoryConsumption = null;
    private HashMap<URL, Double> APs = null;
    private HashMap<URL, Double> APPrimes = null;
    private HashMap<URL, Double> nDCGs = null;
    private HashMap<URL, Double> nDCGPrimes = null;
    private HashMap<URL, Double> Qs = null;
    private HashMap<URL, Double> QPrimes = null;
    private String matchmakerName;
    private String tcName;

    public MatchmakerEvaluationResult(String matchmakerName, String tcName) {
        this.matchmakerName = matchmakerName;
        this.tcName = tcName;
    }

    protected MatchmakerEvaluationResult() {
    }

    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    public void setTotalExecutionTime(long totalExecutionTime) {
        this.totalExecutionTime = totalExecutionTime;
    }

    public void addRanking(URL query, Vector<URL> ranking) {
        this.rankings.put(query, ranking);
    }

    public HashMap<URL, Vector<URL>> getRankings() {
        return this.rankings;
    }

    public Vector<URL> getRanking(URL query) {
        return this.rankings.get(query);
    }

    public void addQueryResponseTime(URL query, Long qrt) {
        if (this.queryResponseTimes == null) {
            this.queryResponseTimes = new HashMap();
        }
        this.queryResponseTimes.put(query, qrt);
    }

    public ArrayList<RecallPrecisionPair> getMacroAvgRP() {
        return this.macroAvgRP;
    }

    public void setMacroAvgRP(ArrayList<RecallPrecisionPair> macroAvgRP) {
        this.macroAvgRP = macroAvgRP;
    }

    public void setMacroAvgF1(ArrayList<RecallPrecisionPair> macroAvgRP) {
        this.macroAvgF1 = new ArrayList();
        for (RecallPrecisionPair rp : macroAvgRP) {
            double f1 = 2.0 * rp.precision * rp.recall / (rp.precision + rp.recall);
            this.macroAvgF1.add(new Double(f1));
        }
    }

    public void setMicroAvgF1(ArrayList<RecallPrecisionPair> microAvgRP) {
        this.microAvgF1 = new ArrayList();
        for (RecallPrecisionPair rp : microAvgRP) {
            double f1 = 2.0 * rp.precision * rp.recall / (rp.precision + rp.recall);
            this.microAvgF1.add(new Double(f1));
        }
    }

    public String getMatchmakerName() {
        return this.matchmakerName;
    }

    public void save(String fileName) {
        try {
            Element apElem;
            Double AP;
            Element averagedPrecisionsElem;
            Document xml = null;
            Element eval = null;
            File file = new File(fileName);
            if (!file.exists()) {
                xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                eval = xml.createElement("evaluation");
                xml.appendChild(eval);
            } else {
                try {
                    xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                    eval = xml.getDocumentElement();
                }
                catch (IOException e) {
                    logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
                    return;
                }
                catch (SAXException e) {
                    logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
                    return;
                }
            }
            Element result = xml.createElement("result");
            result.setAttribute("matchmaker", this.matchmakerName);
            Element environment = xml.createElement("environment");
            Element timeStamp = xml.createElement("timestamp");
            timeStamp.setTextContent(new Long(new Date().getTime()).toString());
            environment.appendChild(timeStamp);
            Element testCollection = xml.createElement("testcollection");
            testCollection.setTextContent(this.tcName);
            environment.appendChild(testCollection);
            Element java = xml.createElement("java");
            java.setTextContent(System.getProperty("java.version"));
            environment.appendChild(java);
            Element system = xml.createElement("system");
            system.setTextContent(System.getProperty("os.name"));
            system.setAttribute("version", System.getProperty("os.version"));
            system.setAttribute("architecture", System.getProperty("os.arch"));
            environment.appendChild(system);
            result.appendChild(environment);
            Element rankings = xml.createElement("rankings");
            for (URL query : this.rankings.keySet()) {
                Vector<URL> rankedResult = this.rankings.get(query);
                Element ranking = xml.createElement("ranking");
                ranking.setAttribute("query", query.toString());
                int rankId = 1;
                for (URL offer : rankedResult) {
                    Element rank = xml.createElement("rank");
                    rank.setTextContent(offer.toString());
                    rank.setAttribute("id", new Integer(rankId++).toString());
                    ranking.appendChild(rank);
                }
                rankings.appendChild(ranking);
            }
            result.appendChild(rankings);
            if (this.totalExecutionTime > -1L) {
                Element execTime = xml.createElement("executiontime");
                execTime.setTextContent(new Long(this.totalExecutionTime).toString());
                result.appendChild(execTime);
            }
            Element macroAvg = xml.createElement("macroaveraged");
            if (this.macroAvgRP != null) {
                Element rp = xml.createElement("recallprecision");
                this.appendRecallPrecisionValues(xml, rp, this.macroAvgRP);
                macroAvg.appendChild(rp);
            }
            if (this.macroAvgF1 != null) {
                Element f1 = xml.createElement("f1values");
                this.appendF1Values(xml, f1, this.macroAvgF1);
                macroAvg.appendChild(f1);
            }
            if (this.macroAvgRF != null) {
                Element rf = xml.createElement("recallfallout");
                this.appendRecallFalloutValues(xml, rf, this.macroAvgRF);
                macroAvg.appendChild(rf);
            }
            result.appendChild(macroAvg);
            Element microAvg = xml.createElement("microaveraged");
            if (this.microAvgRP != null) {
                Element rp = xml.createElement("recallprecision");
                this.appendRecallPrecisionValues(xml, rp, this.microAvgRP);
                microAvg.appendChild(rp);
            }
            if (this.microAvgF1 != null) {
                Element f1 = xml.createElement("f1values");
                this.appendF1Values(xml, f1, this.microAvgF1);
                microAvg.appendChild(f1);
            }
            if (this.microAvgRF != null) {
                Element rf = xml.createElement("recallfallout");
                this.appendRecallFalloutValues(xml, rf, this.microAvgRF);
                microAvg.appendChild(rf);
            }
            result.appendChild(microAvg);
            if (this.queryResponseTimes != null) {
                Element qrt = xml.createElement("queryresponsetime");
                for (URL query : this.queryResponseTimes.keySet()) {
                    Long time = this.queryResponseTimes.get(query);
                    Element timeElem = xml.createElement("time");
                    timeElem.setAttribute("query", query.toString());
                    timeElem.setTextContent(time.toString());
                    qrt.appendChild(timeElem);
                }
                result.appendChild(qrt);
            }
            if (this.APs != null) {
                averagedPrecisionsElem = xml.createElement("averagedprecisions");
                for (URL query : this.APs.keySet()) {
                    AP = this.APs.get(query);
                    apElem = xml.createElement("averagedprecision");
                    apElem.setAttribute("query", query.toString());
                    apElem.setTextContent(AP.toString());
                    averagedPrecisionsElem.appendChild(apElem);
                }
                result.appendChild(averagedPrecisionsElem);
            }
            if (this.APPrimes != null) {
                averagedPrecisionsElem = xml.createElement("averagedprecisionprimes");
                for (URL query : this.APPrimes.keySet()) {
                    AP = this.APPrimes.get(query);
                    apElem = xml.createElement("averagedprecisionprime");
                    apElem.setAttribute("query", query.toString());
                    apElem.setTextContent(AP.toString());
                    averagedPrecisionsElem.appendChild(apElem);
                }
                result.appendChild(averagedPrecisionsElem);
            }
            if (this.Qs != null) {
                Element qsElem = xml.createElement("qs");
                for (URL query : this.Qs.keySet()) {
                    Double Q = this.Qs.get(query);
                    Element qElem = xml.createElement("q");
                    qElem.setAttribute("query", query.toString());
                    qElem.setTextContent(Q.toString());
                    qsElem.appendChild(qElem);
                }
                result.appendChild(qsElem);
            }
            if (this.QPrimes != null) {
                Element qPrimesElem = xml.createElement("qprimes");
                for (URL query : this.QPrimes.keySet()) {
                    Double QPrime = this.QPrimes.get(query);
                    Element qprimeElem = xml.createElement("qprime");
                    qprimeElem.setAttribute("query", query.toString());
                    qprimeElem.setTextContent(QPrime.toString());
                    qPrimesElem.appendChild(qprimeElem);
                }
                result.appendChild(qPrimesElem);
            }
            if (this.nDCGs != null) {
                Element ndcgsElem = xml.createElement("ndcgs");
                for (URL query : this.nDCGs.keySet()) {
                    Double ndcg = this.nDCGs.get(query);
                    Element ndcgElem = xml.createElement("ndcg");
                    ndcgElem.setAttribute("query", query.toString());
                    ndcgElem.setTextContent(ndcg.toString());
                    ndcgsElem.appendChild(ndcgElem);
                }
                result.appendChild(ndcgsElem);
            }
            if (this.nDCGPrimes != null) {
                Element ndcgPrimesElem = xml.createElement("ndcgprimes");
                for (URL query : this.nDCGPrimes.keySet()) {
                    Double ndcgPrime = this.nDCGPrimes.get(query);
                    Element ndcgprimeElem = xml.createElement("ndcgprime");
                    ndcgprimeElem.setAttribute("query", query.toString());
                    ndcgprimeElem.setTextContent(ndcgPrime.toString());
                    ndcgPrimesElem.appendChild(ndcgprimeElem);
                }
                result.appendChild(ndcgPrimesElem);
            }
            if (this.memoryConsumption != null) {
                Element memElem = xml.createElement("memoryusage");
                for (Long value : this.memoryConsumption) {
                    Element entry = xml.createElement("sample");
                    entry.setTextContent(value.toString());
                    memElem.appendChild(entry);
                }
                result.appendChild(memElem);
            }
            eval.appendChild(result);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(xml);
                FileOutputStream os = new FileOutputStream(new File(fileName));
                StreamResult streamResult = new StreamResult(os);
                transformer.transform(source, streamResult);
            }
            catch (TransformerConfigurationException e) {
                logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
            }
            catch (TransformerException e) {
                logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
            }
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)("Unable to save evaluation results for " + this.matchmakerName + " at " + fileName + "."), (Throwable)e);
        }
    }

    private void load(Element result) {
        this.matchmakerName = result.getAttribute("matchmaker");
        NodeList subNodes = result.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("environment")) {
                    this.loadEnvironment(node);
                } else if (node.getNodeName().equals("rankings")) {
                    this.loadRankings(node);
                } else if (node.getNodeName().equals("executiontime")) {
                    this.totalExecutionTime = new Long(node.getTextContent());
                } else if (node.getNodeName().equals("macroaveraged")) {
                    this.loadMacroResults(node);
                } else if (node.getNodeName().equals("microaveraged")) {
                    this.loadMicroResults(node);
                } else if (node.getNodeName().equals("queryresponsetime")) {
                    this.loadQueryResponseTimes(node);
                } else if (node.getNodeName().equals("averagedprecisions")) {
                    this.loadAveragedPrecisions(node);
                } else if (node.getNodeName().equals("averagedprecisionprimes")) {
                    this.loadAveragedPrecisionPrimes(node);
                } else if (node.getNodeName().equals("qs")) {
                    this.loadQs(node);
                } else if (node.getNodeName().equals("qprimes")) {
                    this.loadQPrimes(node);
                } else if (node.getNodeName().equals("ndcgs")) {
                    this.loadNDCGs(node);
                } else if (node.getNodeName().equals("ndcgprimes")) {
                    this.loadNDCGPrimes(node);
                } else if (node.getNodeName().equals("memoryusage")) {
                    this.loadMemoryUsage(node);
                }
            }
            ++i;
        }
    }

    private void loadQueryResponseTimes(Node qrtNode) {
        try {
            this.queryResponseTimes = new HashMap();
            NodeList subNodes = qrtNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                this.queryResponseTimes.put(new URL(node.getAttributes().getNamedItem("query").getNodeValue()), new Long(node.getTextContent()));
                ++i;
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Unable to load query response times because of a malformed URL.", (Throwable)e);
            this.queryResponseTimes = null;
        }
    }

    private void loadAveragedPrecisions(Node APNode) {
        try {
            this.APs = new HashMap();
            NodeList subNodes = APNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                this.APs.put(new URL(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                ++i;
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Unable to load APs because of a malformed URL.", (Throwable)e);
            this.APs = null;
        }
    }

    private void loadAveragedPrecisionPrimes(Node APPNode) {
        try {
            this.APPrimes = new HashMap();
            NodeList subNodes = APPNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                this.APPrimes.put(new URL(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                ++i;
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Unable to load AP's because of a malformed URL.", (Throwable)e);
            this.APPrimes = null;
        }
    }

    private void loadQs(Node QNode2) {
        try {
            this.Qs = new HashMap();
            NodeList subNodes = QNode2.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                this.Qs.put(new URL(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                ++i;
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Unable to load Q values because of a malformed URL.", (Throwable)e);
            this.Qs = null;
        }
    }

    private void loadQPrimes(Node QPNode) {
        try {
            this.QPrimes = new HashMap();
            NodeList subNodes = QPNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                this.QPrimes.put(new URL(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                ++i;
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Unable to load Q' values because of a malformed URL.", (Throwable)e);
            this.QPrimes = null;
        }
    }

    private void loadNDCGs(Node nDCGNode) {
        try {
            this.nDCGs = new HashMap();
            NodeList subNodes = nDCGNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                this.nDCGs.put(new URL(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                ++i;
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Unable to load nDCG values because of a malformed URL.", (Throwable)e);
            this.nDCGs = null;
        }
    }

    private void loadNDCGPrimes(Node nDCGPNode) {
        try {
            this.nDCGPrimes = new HashMap();
            NodeList subNodes = nDCGPNode.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                this.nDCGPrimes.put(new URL(node.getAttributes().getNamedItem("query").getNodeValue()), new Double(node.getTextContent()));
                ++i;
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Unable to load nDCG' values because of a malformed URL.", (Throwable)e);
            this.QPrimes = null;
        }
    }

    private void loadMemoryUsage(Node node) {
        this.memoryConsumption = new ArrayList();
        NodeList subNodes = node.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node current = subNodes.item(i);
            this.memoryConsumption.add(new Long(current.getTextContent()));
            ++i;
        }
    }

    private void loadEnvironment(Node environmentNode) {
        NodeList subNodes = environmentNode.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeName().equals("testcollection")) {
                this.tcName = node.getTextContent();
            } else if (node.getNodeName().equals("testcollection")) {
                this.tcName = node.getTextContent();
            }
            ++i;
        }
    }

    private void loadRankings(Node rankingsNode) {
        NodeList subNodes = rankingsNode.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            this.loadRanking(node);
            ++i;
        }
    }

    private void loadRanking(Node rankingNode) {
        try {
            NodeList subNodes = rankingNode.getChildNodes();
            URL query = new URL(rankingNode.getAttributes().getNamedItem("query").getNodeValue());
            Vector<URL> ranking = new Vector<URL>(subNodes.getLength());
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                ranking.add(new Integer(node.getAttributes().getNamedItem("id").getNodeValue()) - 1, new URL(node.getTextContent()));
                ++i;
            }
            this.rankings.put(query, ranking);
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Unable to parse ranking because of malformed URL.", (Throwable)e);
        }
    }

    private void loadMacroResults(Node macroNode) {
        NodeList subNodes = macroNode.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeName().equals("recallprecision")) {
                this.macroAvgRP = this.parseRP(node);
            } else if (node.getNodeName().equals("recallfallout")) {
                this.macroAvgRF = this.parseRF(node);
            } else if (node.getNodeName().equals("f1values")) {
                this.macroAvgF1 = this.parseF1(node);
            }
            ++i;
        }
    }

    private void loadMicroResults(Node microNode) {
        NodeList subNodes = microNode.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            if (node.getNodeName().equals("recallprecision")) {
                this.microAvgRP = this.parseRP(node);
            } else if (node.getNodeName().equals("recallfallout")) {
                this.microAvgRF = this.parseRF(node);
            } else if (node.getNodeName().equals("f1values")) {
                this.microAvgF1 = this.parseF1(node);
            }
            ++i;
        }
    }

    private ArrayList<RecallPrecisionPair> parseRP(Node rpNode) {
        NodeList subNodes = rpNode.getChildNodes();
        ArrayList<RecallPrecisionPair> rps = new ArrayList<RecallPrecisionPair>(subNodes.getLength());
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            RecallPrecisionPair rp = new RecallPrecisionPair(new Double(node.getAttributes().getNamedItem("recall").getNodeValue()), new Double(node.getTextContent()));
            rps.add(rp);
            ++i;
        }
        Collections.sort(rps);
        return rps;
    }

    private ArrayList<RecallFalloutPair> parseRF(Node rfNode) {
        NodeList subNodes = rfNode.getChildNodes();
        ArrayList<RecallFalloutPair> rfs = new ArrayList<RecallFalloutPair>(subNodes.getLength());
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            RecallFalloutPair rf = new RecallFalloutPair(new Double(node.getAttributes().getNamedItem("recall").getNodeValue()), new Double(node.getTextContent()));
            rfs.add(rf);
            ++i;
        }
        Collections.sort(rfs);
        return rfs;
    }

    private ArrayList<Double> parseF1(Node f1Node) {
        NodeList subNodes = f1Node.getChildNodes();
        ArrayList<Double> f1s = new ArrayList<Double>(subNodes.getLength());
        int i = 0;
        while (i < subNodes.getLength()) {
            Node node = subNodes.item(i);
            f1s.add(new Integer(node.getAttributes().getNamedItem("step").getNodeValue()) - 1, new Double(node.getTextContent()));
            ++i;
        }
        return f1s;
    }

    public static MatchmakerEvaluationResult[] load(String fileName) {
        try {
            Vector<MatchmakerEvaluationResult> results = new Vector<MatchmakerEvaluationResult>();
            File file = new File(fileName);
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            Element docRoot = xml.getDocumentElement();
            NodeList subNodes = docRoot.getChildNodes();
            int i = 0;
            while (i < subNodes.getLength()) {
                Node node = subNodes.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equals("result")) {
                    MatchmakerEvaluationResult result = new MatchmakerEvaluationResult();
                    result.load((Element)node);
                    results.add(result);
                }
                ++i;
            }
            return results.toArray(new MatchmakerEvaluationResult[0]);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)("Unable to load evaluation results from " + fileName + "."), (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            logger.error((Object)("Unable to load evaluation results from " + fileName + "."), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            logger.error((Object)("Unable to load evaluation results from " + fileName + "."), (Throwable)e);
            return null;
        }
    }

    private void appendRecallPrecisionValues(Document xmlDoc, Element elem, ArrayList<RecallPrecisionPair> rpPairs) {
        for (RecallPrecisionPair rpPair : rpPairs) {
            Element pairElem = xmlDoc.createElement("precision");
            pairElem.setTextContent(new Double(rpPair.precision).toString());
            pairElem.setAttribute("recall", new Double(rpPair.recall).toString());
            elem.appendChild(pairElem);
        }
    }

    private void appendF1Values(Document xmlDoc, Element elem, ArrayList<Double> f1Values) {
        int i = 1;
        for (Double f1 : f1Values) {
            Element f1Elem = xmlDoc.createElement("f1");
            f1Elem.setTextContent(f1.toString());
            f1Elem.setAttribute("step", new Integer(i++).toString());
            elem.appendChild(f1Elem);
        }
    }

    private void appendRecallFalloutValues(Document xmlDoc, Element elem, ArrayList<RecallFalloutPair> rfPairs) {
        for (RecallFalloutPair rfPair : rfPairs) {
            Element pairElem = xmlDoc.createElement("fallout");
            pairElem.setTextContent(new Double(rfPair.fallout).toString());
            pairElem.setAttribute("recall", new Double(rfPair.recall).toString());
            elem.appendChild(pairElem);
        }
    }

    public ArrayList<RecallPrecisionPair> getMicroAvgRP() {
        return this.microAvgRP;
    }

    public void setMicroAvgRP(ArrayList<RecallPrecisionPair> microAvgRP) {
        this.microAvgRP = microAvgRP;
    }

    public ArrayList<Double> getMacroAvgF1() {
        return this.macroAvgF1;
    }

    public ArrayList<Double> getMicroAvgF1() {
        return this.microAvgF1;
    }

    public ArrayList<RecallFalloutPair> getMacroAvgRF() {
        return this.macroAvgRF;
    }

    public void setMacroAvgRF(ArrayList<RecallFalloutPair> macroAvgRF) {
        this.macroAvgRF = macroAvgRF;
    }

    public ArrayList<RecallFalloutPair> getMicroAvgRF() {
        return this.microAvgRF;
    }

    public void setMicroAvgRF(ArrayList<RecallFalloutPair> microAvgRF) {
        this.microAvgRF = microAvgRF;
    }

    public HashMap<URL, Long> getQueryResponseTimes() {
        return this.queryResponseTimes;
    }

    public void setQueryResponseTimes(HashMap<URL, Long> queryResponseTimes) {
        this.queryResponseTimes = queryResponseTimes;
    }

    public long getAverageQueryResponseTime() {
        if (this.queryResponseTimes == null) {
            return -1L;
        }
        long avgQrt = 0L;
        for (Long qrt : this.queryResponseTimes.values()) {
            avgQrt += qrt.longValue();
        }
        return avgQrt /= (long)this.queryResponseTimes.size();
    }

    public String getTcName() {
        return this.tcName;
    }

    public HashMap<URL, Double> getAPs() {
        return this.APs;
    }

    public void addAP(URL query, Double AP) {
        if (this.APs == null) {
            this.APs = new HashMap();
        }
        this.APs.put(query, AP);
    }

    public void addAPPrime(URL query, Double AP) {
        if (this.APPrimes == null) {
            this.APPrimes = new HashMap();
        }
        this.APPrimes.put(query, AP);
    }

    public void addNDCG(URL query, Double nDCG) {
        if (this.nDCGs == null) {
            this.nDCGs = new HashMap();
        }
        this.nDCGs.put(query, nDCG);
    }

    public void addNDCGPrime(URL query, Double nDCG) {
        if (this.nDCGPrimes == null) {
            this.nDCGPrimes = new HashMap();
        }
        this.nDCGPrimes.put(query, nDCG);
    }

    public HashMap<URL, Double> getQPrimes() {
        return this.QPrimes;
    }

    public void addQPrime(URL query, Double QPrime) {
        if (this.QPrimes == null) {
            this.QPrimes = new HashMap();
        }
        this.QPrimes.put(query, QPrime);
    }

    public void addQ(URL query, Double q) {
        if (this.Qs == null) {
            this.Qs = new HashMap();
        }
        this.Qs.put(query, q);
    }

    public ArrayList<Long> getMemoryConsumption() {
        return this.memoryConsumption;
    }

    public void setMemoryConsumption(ArrayList<Long> memoryConsumption) {
        this.memoryConsumption = memoryConsumption;
    }

    public String toString() {
        return this.matchmakerName;
    }

    public HashMap<URL, Double> getAPPrimes() {
        return this.APPrimes;
    }

    public HashMap<URL, Double> getNDCGPrimes() {
        return this.nDCGPrimes;
    }

    public HashMap<URL, Double> getNDCGs() {
        return this.nDCGs;
    }

    public HashMap<URL, Double> getQs() {
        return this.Qs;
    }
}

