/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;

public class MemoryMonitor
implements Runnable {
    public static long interval = 5000L;
    private State currentState = State.RUNNING;
    private ArrayList<Long> memValues = new ArrayList();

    @Override
    public void run() {
        System.gc();
        MemoryUsage memUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long baseMem = memUsage.getUsed();
        while (this.currentState != State.STOPPED) {
            if (this.currentState == State.SUSPENDED) continue;
            memUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            this.memValues.add(new Long(memUsage.getUsed() - baseMem));
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void resume() {
        this.currentState = State.RUNNING;
    }

    public void suspend() {
        this.currentState = State.SUSPENDED;
    }

    public void stop() {
        this.currentState = State.STOPPED;
    }

    public ArrayList<Long> getMemoryConsumptionPerInterval() {
        return this.memValues;
    }

    private static enum State {
        RUNNING,
        SUSPENDED,
        STOPPED;

    }
}

