/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.Configuration;
import de.dfki.sme2.Matchmaker;
import de.dfki.sme2.MatchmakerEvaluation;
import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.TestCollection;
import de.dfki.sme2.ThreadedEvaluation;
import de.dfki.sme2.gui.SME2MainFrame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SME2 {
    private static final String SETTINGS_FILE = "./settings/settings.xml";
    private String PLUGINS_DIR = "./plugins";
    private String TESTCOLLECTIONS_DIR = "./testcollections";
    private Logger logger = Logger.getLogger(this.getClass());
    private DocumentBuilder xmlDocBuilder;
    private SME2MainFrame gui = null;
    private Configuration config = null;
    private ThreadedEvaluation threadedEval = null;
    private LinkedList<TestCollection> availableTestCollections;
    private LinkedList<Matchmaker> availableMatchmakers;

    public SME2() {
        try {
            this.xmlDocBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.logger.fatal((Object)"Unable to create XML document builder.", (Throwable)e);
            JOptionPane.showMessageDialog(null, "Unable to create XML document builder.\n\n" + e, "SME^2 - Fatal error", 0);
            System.exit(1);
        }
        this.init();
    }

    private void init() {
        this.parseSettings();
        DefaultMutableTreeNode availableMatchmakers = this.parseMatchmakerPlugins();
        DefaultComboBoxModel availableTCs = this.parseTestCollections();
        this.config = new Configuration();
        this.gui = new SME2MainFrame(this);
        this.gui.setAvailableMatchmakers(availableMatchmakers);
        this.gui.setAvailableTestCollections(availableTCs);
        this.config.setTestCollection((TestCollection)availableTCs.getElementAt(0));
    }

    private void parseSettings() {
        try {
            this.logger.info((Object)"Parsing settings file...");
            Document doc = this.xmlDocBuilder.parse(SETTINGS_FILE);
            NodeList nodes = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                String nodeName;
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && (nodeName = node.getNodeName()).equals("directories")) {
                    NodeList subNodes = node.getChildNodes();
                    int j = 0;
                    while (j < subNodes.getLength()) {
                        Node subNode = subNodes.item(j);
                        if (subNode.getNodeType() == 1) {
                            String subNodeName = subNode.getNodeName();
                            if (subNodeName.equals("plugins")) {
                                this.PLUGINS_DIR = subNode.getTextContent();
                            } else if (subNodeName.equals("testcollections")) {
                                this.TESTCOLLECTIONS_DIR = subNode.getTextContent();
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.logger.info((Object)"Setup complete. The following settings will be used:");
        }
        catch (IOException e) {
            this.logger.warn((Object)"Could not find settings file at ./settings/settings.xml. Using default configuration instead.");
        }
        catch (SAXException e) {
            this.logger.warn((Object)"Error while paring settings file ./settings/settings.xml. Using default configuration.", (Throwable)e);
        }
        this.logger.info((Object)("Matchmaker plugins directory: " + this.PLUGINS_DIR));
        this.logger.info((Object)("Testcollections directory:    " + this.TESTCOLLECTIONS_DIR));
    }

    private DefaultMutableTreeNode parseMatchmakerPlugins() {
        DefaultMutableTreeNode availableMatchmakers = new DefaultMutableTreeNode("plugins");
        this.availableMatchmakers = new LinkedList();
        File pluginsDir = new File(this.PLUGINS_DIR);
        if (!pluginsDir.isDirectory()) {
            this.logger.warn((Object)(String.valueOf(this.PLUGINS_DIR) + " is not a directory. No plugins will be loaded."));
            return availableMatchmakers;
        }
        String[] stringArray = pluginsDir.list();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String plugin = stringArray[n];
            DefaultMutableTreeNode mmGroupNode = new DefaultMutableTreeNode(plugin);
            File pluginDir = new File(String.valueOf(this.PLUGINS_DIR) + File.separator + plugin);
            String[] stringArray2 = pluginDir.list(new XMLFilenameFilter());
            int n3 = 0;
            int n4 = stringArray2.length;
            while (n3 < n4) {
                String xmlPluginFile = stringArray2[n3];
                String locationToParse = String.valueOf(this.PLUGINS_DIR) + File.separator + plugin + File.separator + xmlPluginFile;
                Matchmaker parsedMM = Matchmaker.parse(locationToParse);
                if (parsedMM != null) {
                    DefaultMutableTreeNode mmNode = new DefaultMutableTreeNode(parsedMM);
                    mmGroupNode.add(mmNode);
                    this.availableMatchmakers.add(parsedMM);
                }
                ++n3;
            }
            if (mmGroupNode.getChildCount() != 0) {
                availableMatchmakers.add(mmGroupNode);
            }
            ++n;
        }
        return availableMatchmakers;
    }

    private DefaultComboBoxModel parseTestCollections() {
        DefaultComboBoxModel<TestCollection> availableTCs = new DefaultComboBoxModel<TestCollection>();
        this.availableTestCollections = new LinkedList();
        File testcollectionsDir = new File(this.TESTCOLLECTIONS_DIR);
        if (!testcollectionsDir.isDirectory()) {
            this.logger.warn((Object)(String.valueOf(this.TESTCOLLECTIONS_DIR) + " is not a directory. No test collections will be loaded."));
            return availableTCs;
        }
        String[] stringArray = testcollectionsDir.list();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String testcollection = stringArray[n];
            File testcollectionDir = new File(String.valueOf(this.TESTCOLLECTIONS_DIR) + File.separator + testcollection);
            String[] list = testcollectionDir.list(new XMLFilenameFilter());
            if (list != null && list.length != 0) {
                TestCollection parsedTC = TestCollection.parse(String.valueOf(this.TESTCOLLECTIONS_DIR) + File.separator + testcollection + File.separator + list[0]);
                availableTCs.addElement(parsedTC);
                this.availableTestCollections.add(parsedTC);
            }
            ++n;
        }
        return availableTCs;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void loadConfiguration(String fileName) {
        this.config.load(fileName, this.availableTestCollections, this.availableMatchmakers);
        this.gui.updateControls(this.config);
    }

    public MatchmakerEvaluationResult[] evaluate() {
        MatchmakerEvaluation eval = new MatchmakerEvaluation(this.config);
        return eval.evaluate();
    }

    public void startEvaluationThread() {
        if (this.threadedEval == null || this.threadedEval.getState() == ThreadedEvaluation.State.STOPPED) {
            this.threadedEval = new ThreadedEvaluation(this.config, this.gui);
            new Thread(this.threadedEval).start();
        } else {
            this.threadedEval.resume();
        }
    }

    public void suspendEvaluationThread() {
        this.threadedEval.suspend();
    }

    public void stopEvaluationThread() {
        this.threadedEval.stop();
        this.threadedEval = null;
    }

    public TestCollection getTestCollection(String tcName) {
        for (TestCollection tc : this.availableTestCollections) {
            if (!tc.getName().equals(tcName)) continue;
            return tc;
        }
        return null;
    }

    public static void main(String[] args) {
        SME2 main = new SME2();
        main.toString();
    }

    private class XMLFilenameFilter
    implements FilenameFilter {
        private XMLFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }
}

