/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.MatchmakerEvaluationResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TCQualityTestResult {
    private static Logger logger = Logger.getLogger(TCQualityTestResult.class);
    private double[][] avgAPs;
    private int folds;
    private long seed;
    private Vector<String> matchmakerNames = new Vector();

    public TCQualityTestResult(MatchmakerEvaluationResult[][] results, int folds, long seed) {
        this.folds = folds;
        this.seed = seed;
        this.avgAPs = new double[results.length][results[0].length];
        int i = 0;
        while (i < results.length) {
            int j = 0;
            while (j < results[i].length) {
                for (Double apValue : results[i][j].getAPs().values()) {
                    double[] dArray = this.avgAPs[i];
                    int n = j;
                    dArray[n] = dArray[n] + apValue;
                }
                double[] dArray = this.avgAPs[i];
                int n = j;
                dArray[n] = dArray[n] / (double)results[i][j].getAPs().size();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < results[0].length) {
            this.matchmakerNames.add(results[0][i].getMatchmakerName());
            ++i;
        }
    }

    public String getMatchmakerName(int index) {
        return this.matchmakerNames.elementAt(index);
    }

    public double[][] getAvgAPs() {
        return this.avgAPs;
    }

    public int getFolds() {
        return this.folds;
    }

    public long getSeed() {
        return this.seed;
    }

    public void save(String fileName) {
        try {
            Document xml = null;
            Element eval = null;
            File file = new File(fileName);
            if (!file.exists()) {
                xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                eval = xml.createElement("evaluation");
                xml.appendChild(eval);
            } else {
                try {
                    xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                    eval = xml.getDocumentElement();
                }
                catch (IOException e) {
                    logger.error((Object)("Unable to save test collection quality results at " + fileName + "."), (Throwable)e);
                    return;
                }
                catch (SAXException e) {
                    logger.error((Object)("Unable to save test collection quality results at " + fileName + "."), (Throwable)e);
                    return;
                }
            }
            Element tcQuality = xml.createElement("tcquality");
            tcQuality.setAttribute("folds", new Integer(this.folds).toString());
            tcQuality.setAttribute("seed", new Long(this.seed).toString());
            int i = 0;
            while (i < this.folds) {
                Element fold = xml.createElement("fold");
                fold.setAttribute("ID", new Integer(i).toString());
                int j = 0;
                while (j < this.matchmakerNames.size()) {
                    Element aap = xml.createElement("avgap");
                    aap.setAttribute("ID", new Integer(j).toString());
                    aap.setAttribute("matchmaker", this.matchmakerNames.elementAt(j));
                    aap.setTextContent(new Double(this.avgAPs[i][j]).toString());
                    fold.appendChild(aap);
                    ++j;
                }
                tcQuality.appendChild(fold);
                ++i;
            }
            eval.appendChild(tcQuality);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(xml);
                FileOutputStream os = new FileOutputStream(new File(fileName));
                StreamResult streamResult = new StreamResult(os);
                transformer.transform(source, streamResult);
            }
            catch (TransformerConfigurationException e) {
                logger.error((Object)("Unable to save test collection quality results at " + fileName + "."), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Unable to save test collection quality results at " + fileName + "."), (Throwable)e);
            }
            catch (TransformerException e) {
                logger.error((Object)("Unable to save test collection quality results at " + fileName + "."), (Throwable)e);
            }
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)("Unable to save test collection quality results at " + fileName + "."), (Throwable)e);
        }
    }

    public static TCQualityTestResult load(String filename) {
        return null;
    }
}

