/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2;

import de.dfki.sme2.RelevanceSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestCollection {
    private Logger logger = Logger.getLogger(this.getClass());
    private Collection<URL> serviceOffers = new HashSet<URL>();
    private Map<URL, RelevanceSet> queries = new HashMap<URL, RelevanceSet>();
    private String name = null;
    private String type = "";
    private String description = "";
    private String authors = "";

    public void addServiceOffer(URL offer) {
        this.serviceOffers.add(offer);
    }

    public Collection<URL> getServiceOffers() {
        return this.serviceOffers;
    }

    public int getNumberOfServiceOffers() {
        return this.serviceOffers.size();
    }

    public int getNumberOfRequests() {
        return this.queries.size();
    }

    public void addQuery(URL query, RelevanceSet relevanceSet) {
        this.queries.put(query, relevanceSet);
    }

    public Collection<URL> getQueries() {
        return this.queries.keySet();
    }

    public RelevanceSet getRelevanceSet(URL query) {
        return this.queries.get(query);
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isBinaryComplete() {
        for (RelevanceSet set : this.queries.values()) {
            if (set.getNumberOfBinaryJudgements() == this.serviceOffers.size()) continue;
            return false;
        }
        return true;
    }

    public boolean isGradedComplete() {
        for (RelevanceSet set : this.queries.values()) {
            if (set.getNumberOfGradedJudgements() == this.serviceOffers.size()) continue;
            return false;
        }
        return true;
    }

    public static TestCollection parse(String xmlFileName) {
        TestCollection tc = new TestCollection();
        try {
            File xmlFile = new File(xmlFileName);
            xmlFileName = xmlFile.getAbsolutePath();
            String path = xmlFileName.substring(0, xmlFileName.lastIndexOf(File.separator));
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlFileName);
            NodeList nodes = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node configNode = nodes.item(i);
                if (configNode.getNodeType() == 1) {
                    String configNodeName = configNode.getNodeName();
                    if (configNodeName.equals("proprietary")) {
                        tc.proprietaryReadTCData(path);
                    } else if (configNodeName.equals("type")) {
                        tc.type = configNode.getTextContent();
                    } else if (configNodeName.equals("authors")) {
                        tc.authors = configNode.getTextContent();
                    } else if (configNodeName.equals("description")) {
                        tc.description = configNode.getTextContent();
                    } else if (configNodeName.equals("name")) {
                        tc.name = configNode.getTextContent();
                    } else if (configNodeName.equals("relevancegradeexport")) {
                        tc.parseSWSRATExport(configNode);
                    } else if (configNodeName.equals("offers")) {
                        NodeList offerNodes = configNode.getChildNodes();
                        int j = 0;
                        while (j < offerNodes.getLength()) {
                            String offer = ((Element)offerNodes.item(j)).getElementsByTagName("uri").item(0).getTextContent();
                            try {
                                URL offerUrl = new URL(offer);
                                tc.serviceOffers.add(offerUrl);
                            }
                            catch (MalformedURLException e) {
                                tc.logger.warn((Object)("Unable to add service offer " + offer + "."), (Throwable)e);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (tc.name == null) {
                tc.name = xmlFile.getName().replaceFirst(".xml", "");
            }
        }
        catch (SAXException e) {
            tc.logger.warn((Object)("Parsing error while processing " + xmlFileName + "."), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            tc.logger.warn((Object)("File " + xmlFileName + " not found. Unable to parse test collection file"), (Throwable)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            tc.logger.warn((Object)"Unable to create XML parser.", (Throwable)e);
            return null;
        }
        return tc;
    }

    private void parseSWSRATExport(Node rootNode) {
        NodeList childNodes = rootNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("binaryrelevanceset")) {
                NodeList requestNodes = node.getChildNodes();
                int j = 0;
                while (j < requestNodes.getLength()) {
                    try {
                        if (requestNodes.item(j).getNodeType() == 1) {
                            Element requestNode = (Element)requestNodes.item(j);
                            URL requestUrl = new URL(requestNode.getElementsByTagName("uri").item(0).getTextContent().split("#")[0]);
                            RelevanceSet relevanceSet = this.getRelevanceSet(requestUrl);
                            if (relevanceSet == null) {
                                relevanceSet = new RelevanceSet();
                            }
                            NodeList offerNodes = requestNode.getElementsByTagName("offer");
                            int k = 0;
                            while (k < offerNodes.getLength()) {
                                boolean relevant;
                                Element offerNode = (Element)offerNodes.item(k);
                                URL offerUrl = new URL(offerNode.getElementsByTagName("uri").item(0).getTextContent().split("#")[0]);
                                boolean bl = relevant = offerNode.getElementsByTagName("relevant").item(0).getTextContent().equals("1");
                                if (relevant) {
                                    relevanceSet.addAsBinaryRelevant(offerUrl);
                                } else {
                                    relevanceSet.addAsBinaryIrrelevant(offerUrl);
                                }
                                this.addServiceOffer(offerUrl);
                                ++k;
                            }
                            this.addQuery(requestUrl, relevanceSet);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Unable to read request from <binaryrelevanceset> tag.", (Throwable)e);
                    }
                    ++j;
                }
            }
            if (nodeName.equals("relevancegrades")) {
                Element scaleNode = (Element)((Element)node).getElementsByTagName("scale").item(0);
                NodeList requestNodes = scaleNode.getElementsByTagName("services").item(0).getChildNodes();
                int j = 0;
                while (j < requestNodes.getLength()) {
                    try {
                        if (requestNodes.item(j).getNodeType() == 1) {
                            Element requestNode = (Element)requestNodes.item(j);
                            URL requestUrl = new URL(requestNode.getElementsByTagName("uri").item(0).getTextContent().split("#")[0]);
                            RelevanceSet relevanceSet = this.getRelevanceSet(requestUrl);
                            if (relevanceSet == null) {
                                relevanceSet = new RelevanceSet();
                            }
                            NodeList offerNodes = requestNode.getElementsByTagName("offer");
                            int k = 0;
                            while (k < offerNodes.getLength()) {
                                Element offerNode = (Element)offerNodes.item(k);
                                URL offerUrl = new URL(offerNode.getElementsByTagName("uri").item(0).getTextContent().split("#")[0]);
                                Element gradeNode = (Element)offerNode.getElementsByTagName("grade").item(0);
                                String gradeName = gradeNode.getElementsByTagName("name").item(0).getTextContent();
                                Double gain = new Double(gradeNode.getElementsByTagName("value").item(0).getTextContent());
                                relevanceSet.addGrade(gradeName, gain);
                                if (gain == 0.0) {
                                    relevanceSet.addAsGradedIrrelevant(offerUrl);
                                } else {
                                    relevanceSet.addAsGradedRelevant(offerUrl, gradeName);
                                }
                                this.addServiceOffer(offerUrl);
                                ++k;
                            }
                            this.addQuery(requestUrl, relevanceSet);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Unable to read request from <relevancegrades> tag.", (Throwable)e);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void proprietaryReadTCData(String directory) {
        File[] requests;
        File[] services;
        File offerDir = new File(String.valueOf(directory) + File.separator + "services");
        offerDir = new File(String.valueOf(offerDir.getAbsolutePath()) + File.separator + offerDir.list()[0]);
        File[] fileArray = services = offerDir.listFiles();
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File service = fileArray[n];
            try {
                if (service.isFile()) {
                    this.serviceOffers.add(service.toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                this.logger.warn((Object)("Service offer " + service + " is no valid URL."), (Throwable)e);
            }
            ++n;
        }
        File requestDir = new File(String.valueOf(directory) + File.separator + "queries");
        requestDir = new File(String.valueOf(requestDir.getAbsolutePath()) + File.separator + requestDir.list()[0]);
        File[] fileArray2 = requests = requestDir.listFiles();
        int n3 = 0;
        int n4 = fileArray2.length;
        while (n3 < n4) {
            File request = fileArray2[n3];
            try {
                if (request.isFile()) {
                    this.queries.put(request.toURI().toURL(), new RelevanceSet());
                }
            }
            catch (MalformedURLException e) {
                this.logger.warn((Object)("Request " + request + " is no valid URL."), (Throwable)e);
            }
            ++n3;
        }
        File relevanceSetsDir = new File(String.valueOf(directory) + File.separator + "relevance_sets");
        block8: for (URL query : this.queries.keySet()) {
            String queryPath = query.getPath();
            String fileName = queryPath.substring(queryPath.lastIndexOf(47) + 1);
            String[] stringArray = relevanceSetsDir.list();
            int n5 = 0;
            int n6 = stringArray.length;
            while (n5 < n6) {
                String relDir = stringArray[n5];
                String relName = relDir.substring(relDir.indexOf(45) + 1);
                if (fileName.equals(relName)) {
                    File relSetDir = new File(String.valueOf(directory) + File.separator + "relevance_sets" + File.separator + relDir);
                    String[] stringArray2 = relSetDir.list();
                    int n7 = 0;
                    int n8 = stringArray2.length;
                    while (n7 < n8) {
                        String relFile = stringArray2[n7];
                        try {
                            this.queries.get(query).addAsBinaryRelevant(new File(String.valueOf(offerDir.toString()) + File.separator + relFile).toURI().toURL());
                        }
                        catch (MalformedURLException e) {
                            this.logger.warn((Object)("No valid service URL for " + relFile + " could be constructed."), (Throwable)e);
                        }
                        ++n7;
                    }
                    for (URL offer : this.serviceOffers) {
                        if (this.queries.get(query).isBinaryRelevant(offer)) continue;
                        this.queries.get(query).addAsBinaryIrrelevant(offer);
                    }
                    continue block8;
                }
                ++n5;
            }
        }
    }

    public Collection<TestCollection> nFold(int n, long randomSeed) {
        int foldSize = this.serviceOffers.size() / n;
        int overhang = this.serviceOffers.size() % n;
        LinkedList<URL> tmpOffers = new LinkedList<URL>(this.serviceOffers);
        HashSet<TestCollection> resultTCs = new HashSet<TestCollection>();
        Random rnd = new Random(randomSeed);
        int i = 0;
        while (i < n) {
            TestCollection tc = new TestCollection();
            tc.setName(String.valueOf(this.name) + " fold " + (i + 1));
            tc.setDescription("Automatically derived from " + this.name + ".");
            tc.setAuthors(this.authors);
            int mod = i < overhang ? 1 : 0;
            int j = 0;
            while (j < foldSize + mod) {
                int offerIndex = rnd.nextInt(tmpOffers.size());
                tc.addServiceOffer(tmpOffers.get(offerIndex));
                tmpOffers.remove(offerIndex);
                ++j;
            }
            for (URL query : this.queries.keySet()) {
                RelevanceSet relSet = new RelevanceSet();
                HashSet<URL> binaryRelevants = new HashSet<URL>();
                HashSet<URL> binaryIrrelevants = new HashSet<URL>();
                Collection<URL> reducedOffers = tc.getServiceOffers();
                for (URL offer : reducedOffers) {
                    if (this.queries.get(query).isBinaryRelevant(offer)) {
                        binaryRelevants.add(offer);
                        continue;
                    }
                    if (!this.queries.get(query).isBinaryIrrelevant(offer)) continue;
                    binaryIrrelevants.add(offer);
                }
                for (URL offer : binaryRelevants) {
                    relSet.addAsBinaryRelevant(offer);
                }
                for (URL offer : binaryIrrelevants) {
                    relSet.addAsBinaryIrrelevant(offer);
                }
                if (binaryRelevants.isEmpty()) continue;
                tc.addQuery(query, relSet);
            }
            if (!tc.queries.isEmpty()) {
                resultTCs.add(tc);
            }
            ++i;
        }
        return resultTCs;
    }

    public void save(String fileName) {
        try {
            Document xml = null;
            Element tc = null;
            File file = new File(fileName);
            xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            tc = xml.createElement("testcollection");
            xml.appendChild(tc);
            if (this.name != null) {
                Element name = xml.createElement("name");
                name.appendChild(xml.createTextNode(this.name));
                tc.appendChild(name);
            }
            Element authors = xml.createElement("authors");
            authors.appendChild(xml.createTextNode(this.authors));
            tc.appendChild(authors);
            Element type = xml.createElement("type");
            type.appendChild(xml.createTextNode(this.type));
            tc.appendChild(type);
            Element description = xml.createElement("description");
            description.appendChild(xml.createTextNode(this.description));
            tc.appendChild(description);
            Element offers = xml.createElement("offers");
            tc.appendChild(offers);
            for (URL offerUrl : this.serviceOffers) {
                Element element = xml.createElement("offer");
                offers.appendChild(element);
                Element uri = xml.createElement("uri");
                uri.appendChild(xml.createTextNode(offerUrl.toString()));
                element.appendChild(uri);
            }
            Element exports = xml.createElement("relevancegradeexport");
            tc.appendChild(exports);
            Element binSets = xml.createElement("binaryrelevanceset");
            exports.appendChild(binSets);
            for (Map.Entry entry : this.queries.entrySet()) {
                Element relevant;
                Element offerUri;
                Element offer;
                URL requestUrl = (URL)entry.getKey();
                RelevanceSet relSet = (RelevanceSet)entry.getValue();
                Element request = xml.createElement("request");
                binSets.appendChild(request);
                Element reqUri = xml.createElement("uri");
                reqUri.appendChild(xml.createTextNode(requestUrl.toString()));
                request.appendChild(reqUri);
                Element ratings = xml.createElement("ratings");
                request.appendChild(ratings);
                for (URL offerUrl : relSet.getBinaryRelevants()) {
                    offer = xml.createElement("offer");
                    ratings.appendChild(offer);
                    offerUri = xml.createElement("uri");
                    offerUri.appendChild(xml.createTextNode(offerUrl.toString()));
                    offer.appendChild(offerUri);
                    relevant = xml.createElement("relevant");
                    relevant.appendChild(xml.createTextNode("1"));
                    offer.appendChild(relevant);
                }
                for (URL offerUrl : relSet.getBinaryIrrelevants()) {
                    offer = xml.createElement("offer");
                    ratings.appendChild(offer);
                    offerUri = xml.createElement("uri");
                    offerUri.appendChild(xml.createTextNode(offerUrl.toString()));
                    offer.appendChild(offerUri);
                    relevant = xml.createElement("relevant");
                    relevant.appendChild(xml.createTextNode("0"));
                    offer.appendChild(relevant);
                }
            }
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(xml);
                FileOutputStream os = new FileOutputStream(new File(fileName));
                StreamResult streamResult = new StreamResult(os);
                transformer.transform(source, streamResult);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                this.logger.error((Object)("Unable to save test collection to " + fileName + "."), (Throwable)transformerConfigurationException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.error((Object)("Unable to save test collection to " + fileName + "."), (Throwable)fileNotFoundException);
            }
            catch (TransformerException transformerException) {
                this.logger.error((Object)("Unable to save evaluation test collection to " + fileName + "."), (Throwable)transformerException);
            }
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)("Unable to save test collection to " + fileName + "."), (Throwable)e);
        }
    }

    public String toString() {
        return this.name;
    }

    public static void main(String[] args) {
        String input = args[0];
        String output = args[1];
        System.out.println("Load test collection from " + input);
        TestCollection tc = TestCollection.parse(input);
        System.out.println("Save test collection to " + output);
        tc.save(output);
    }
}

