/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui;

import de.dfki.sme2.gui.CustomizableFileFilter;
import de.dfki.sme2.gui.chart.Chart;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class InternalChartFrame
extends JInternalFrame {
    private static final long serialVersionUID = 23273898L;
    private JPanel chartContentPane = null;
    private JComponent chartComponent;
    private JMenuBar chartJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem saveMenuItem = null;
    private Chart chart;
    private JMenuItem saveSmallMenuItem = null;

    public InternalChartFrame(Chart chart, String title) {
        this.chartComponent = chart.getJComponent();
        this.chart = chart;
        this.initialize(title);
    }

    private void initialize(String title) {
        this.setTitle(title);
        this.setJMenuBar(this.getChartJMenuBar());
        this.setSize(600, 400);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setPreferredSize(new Dimension(600, 400));
        this.setResizable(true);
        this.setVisible(true);
        this.setContentPane(this.getChartContentPane());
    }

    private JPanel getChartContentPane() {
        if (this.chartContentPane == null) {
            this.chartContentPane = new JPanel();
            this.chartContentPane.setLayout(new BorderLayout());
            this.chartContentPane.add((Component)this.chartComponent, "Center");
        }
        return this.chartContentPane;
    }

    private JMenuBar getChartJMenuBar() {
        if (this.chartJMenuBar == null) {
            this.chartJMenuBar = new JMenuBar();
            this.chartJMenuBar.setPreferredSize(new Dimension(9, 20));
            this.chartJMenuBar.add(this.getFileMenu());
        }
        return this.chartJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getSaveMenuItem());
            this.fileMenu.add(this.getSaveSmallMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem();
            this.saveMenuItem.setText("Save image (1024x768)");
            this.saveMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                    fileChooser.addChoosableFileFilter(new CustomizableFileFilter("Portable Network Graphics (.png)", "png"));
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileSelectionMode(0);
                    int returnValue = fileChooser.showDialog(null, "Save as image");
                    if (returnValue == 0) {
                        File file = fileChooser.getSelectedFile();
                        String fileName = file.getAbsolutePath();
                        if (!fileName.toLowerCase().endsWith(".png")) {
                            file = new File(String.valueOf(fileName) + ".png");
                        }
                        InternalChartFrame.this.chart.save(file, 1024, 768);
                    }
                }
            });
        }
        return this.saveMenuItem;
    }

    private JMenuItem getSaveSmallMenuItem() {
        if (this.saveSmallMenuItem == null) {
            this.saveSmallMenuItem = new JMenuItem();
            this.saveSmallMenuItem.setText("Save image (640x480)");
            this.saveSmallMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                    fileChooser.addChoosableFileFilter(new CustomizableFileFilter("Portable Network Graphics (.png)", "png"));
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setFileSelectionMode(0);
                    int returnValue = fileChooser.showDialog(null, "Save as image");
                    if (returnValue == 0) {
                        File file = fileChooser.getSelectedFile();
                        String fileName = file.getAbsolutePath();
                        if (!fileName.toLowerCase().endsWith(".png")) {
                            file = new File(String.valueOf(fileName) + ".png");
                        }
                        InternalChartFrame.this.chart.save(file, 640, 480);
                    }
                }
            });
        }
        return this.saveSmallMenuItem;
    }
}

