/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.PdfReport;
import de.dfki.sme2.SME2;
import de.dfki.sme2.TCQualityTestResult;
import de.dfki.sme2.gui.InternalResultsFrame;
import de.dfki.sme2.gui.chart.APChart;
import de.dfki.sme2.gui.chart.APPrimeChart;
import de.dfki.sme2.gui.chart.Chart;
import de.dfki.sme2.gui.chart.F1Chart;
import de.dfki.sme2.gui.chart.MemoryChart;
import de.dfki.sme2.gui.chart.NDCGChart;
import de.dfki.sme2.gui.chart.NDCGPrimeChart;
import de.dfki.sme2.gui.chart.QChart;
import de.dfki.sme2.gui.chart.QPrimeChart;
import de.dfki.sme2.gui.chart.QRTChart;
import de.dfki.sme2.gui.chart.RecallFalloutChart;
import de.dfki.sme2.gui.chart.RecallPrecisionChart;
import de.dfki.sme2.gui.chart.TCQualityChart;
import java.util.Vector;
import javax.swing.JDesktopPane;
import org.apache.log4j.Logger;

public class ResultDesktopPane
extends JDesktopPane {
    private static final long serialVersionUID = 23123428937423894L;
    private Logger logger = Logger.getLogger(this.getClass());
    private String title;
    private MatchmakerEvaluationResult[] results;
    private TCQualityTestResult tcQualityResult = null;
    private boolean saved = false;
    private RecallPrecisionChart microRpChart = null;
    private RecallPrecisionChart macroRpChart = null;
    private F1Chart microF1Chart = null;
    private F1Chart macroF1Chart = null;
    private RecallFalloutChart microRfChart = null;
    private RecallFalloutChart macroRfChart = null;
    private QRTChart qrtChart = null;
    private APChart apChart = null;
    private APPrimeChart appChart = null;
    private QChart qChart = null;
    private QPrimeChart qpChart = null;
    private NDCGChart ndcgChart = null;
    private NDCGPrimeChart ndcgpChart = null;
    private MemoryChart memChart = null;
    private TCQualityChart tcQualityChart = null;
    private SME2 sme2;

    public ResultDesktopPane(SME2 sme2, String title, MatchmakerEvaluationResult[] results, boolean saved) {
        this.sme2 = sme2;
        this.title = title;
        this.results = results;
        this.saved = saved;
        this.buildInternalFrames();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private void buildInternalFrames() {
        MatchmakerEvaluationResult result;
        Vector<MatchmakerEvaluationResult> tmpResults = new Vector<MatchmakerEvaluationResult>();
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = this.results;
        int n = 0;
        int n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getMacroAvgRP() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.macroRpChart = new RecallPrecisionChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]), false);
            this.add(this.macroRpChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getMicroAvgRP() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.microRpChart = new RecallPrecisionChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]), true);
            this.add(this.microRpChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getMacroAvgF1() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.macroF1Chart = new F1Chart(tmpResults.toArray(new MatchmakerEvaluationResult[1]), false);
            this.add(this.macroF1Chart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getMicroAvgF1() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.microF1Chart = new F1Chart(tmpResults.toArray(new MatchmakerEvaluationResult[1]), true);
            this.add(this.microF1Chart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getMacroAvgRF() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.macroRfChart = new RecallFalloutChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]), false);
            this.add(this.macroRfChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getMicroAvgRF() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.microRfChart = new RecallFalloutChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]), true);
            this.add(this.microRfChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getQueryResponseTimes() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.qrtChart = new QRTChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]));
            this.add(this.qrtChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getAPs() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.apChart = new APChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]));
            this.add(this.apChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getAPPrimes() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.appChart = new APPrimeChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]));
            this.add(this.appChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getQs() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.qChart = new QChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]));
            this.add(this.qChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getQPrimes() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.qpChart = new QPrimeChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]));
            this.add(this.qpChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getNDCGs() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.ndcgChart = new NDCGChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]));
            this.add(this.ndcgChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getNDCGPrimes() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.ndcgpChart = new NDCGPrimeChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]));
            this.add(this.ndcgpChart.getInternalFrame());
        }
        tmpResults.clear();
        matchmakerEvaluationResultArray = this.results;
        n = 0;
        n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            result = matchmakerEvaluationResultArray[n];
            if (result.getMemoryConsumption() != null) {
                tmpResults.add(result);
            }
            ++n;
        }
        if (!tmpResults.isEmpty()) {
            this.memChart = new MemoryChart(tmpResults.toArray(new MatchmakerEvaluationResult[1]));
            this.add(this.memChart.getInternalFrame());
        }
        if (this.results.length > 0) {
            this.add(new InternalResultsFrame(this.results, this.sme2));
        }
    }

    public void addTCQualityTestResult(TCQualityTestResult result) {
        this.tcQualityResult = result;
        this.tcQualityChart = new TCQualityChart(result);
        this.add(this.tcQualityChart.getInternalFrame());
    }

    @Override
    public String toString() {
        String str = this.title;
        if (!this.saved) {
            str = String.valueOf(str) + " (not saved)";
        }
        return str;
    }

    public boolean save(String fileName) {
        boolean noErrors = true;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = this.results;
        int n = 0;
        int n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n];
            try {
                result.save(fileName);
            }
            catch (Exception e) {
                noErrors = false;
                this.logger.error((Object)("Unable to save results for " + result.getMatchmakerName() + " at " + fileName + "."), (Throwable)e);
            }
            ++n;
        }
        if (this.tcQualityResult != null) {
            try {
                this.tcQualityResult.save(fileName);
            }
            catch (Exception e) {
                noErrors = false;
                this.logger.error((Object)("Unable to save test collection quality test result at " + fileName + "."), (Throwable)e);
            }
        }
        if (noErrors) {
            this.saved = true;
        }
        return noErrors;
    }

    public boolean exportToPDF(String fileName) {
        try {
            Vector<Chart> charts = new Vector<Chart>();
            if (this.macroRpChart != null) {
                charts.add(this.macroRpChart);
            }
            if (this.microRpChart != null) {
                charts.add(this.microRpChart);
            }
            if (this.macroF1Chart != null) {
                charts.add(this.macroF1Chart);
            }
            if (this.microF1Chart != null) {
                charts.add(this.microF1Chart);
            }
            if (this.macroRfChart != null) {
                charts.add(this.macroRfChart);
            }
            if (this.microRfChart != null) {
                charts.add(this.microRfChart);
            }
            if (this.qrtChart != null) {
                charts.add(this.qrtChart);
            }
            if (this.apChart != null) {
                charts.add(this.apChart);
            }
            if (this.appChart != null) {
                charts.add(this.appChart);
            }
            if (this.qChart != null) {
                charts.add(this.qChart);
            }
            if (this.qpChart != null) {
                charts.add(this.qpChart);
            }
            if (this.ndcgChart != null) {
                charts.add(this.ndcgChart);
            }
            if (this.ndcgpChart != null) {
                charts.add(this.ndcgpChart);
            }
            if (this.memChart != null) {
                charts.add(this.memChart);
            }
            if (this.tcQualityChart != null) {
                charts.add(this.tcQualityChart);
            }
            PdfReport report = new PdfReport(this.results, charts);
            report.write(fileName);
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to save PDF output at " + fileName + "."), (Throwable)e);
            return false;
        }
    }

    public MatchmakerEvaluationResult[] getResults() {
        return this.results;
    }

    public String getTitle() {
        return this.title;
    }
}

