/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui;

import de.dfki.sme2.Configuration;
import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.SME2;
import de.dfki.sme2.TCQualityTestResult;
import de.dfki.sme2.TestCollection;
import de.dfki.sme2.gui.AboutDialog;
import de.dfki.sme2.gui.CustomizableFileFilter;
import de.dfki.sme2.gui.ResultDesktopPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SME2MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel mainPane = null;
    private JPanel titlePanel = null;
    private JLabel titleLabel = null;
    private JTabbedPane mainTabbedPane = null;
    private JPanel configPanel = null;
    private JPanel tcConfigPanel = null;
    private JLabel selectedTCLabel = null;
    private JComboBox tcSelectionComboBox = null;
    private JScrollPane tcInfoScrollPane = null;
    private JTable tcInfoTable = null;
    private JPanel settingsPanel = null;
    private JButton saveSettingsButton = null;
    private JButton loadSettingsButton = null;
    private JTextField settingsFileTextField = null;
    private JLabel settingsFileLabel = null;
    private JLabel outputDirLabel = null;
    private JTextField outputDirTextField = null;
    private JButton changeOutputDirButton = null;
    private JPanel mmSelectionPanel = null;
    private JScrollPane availableMMScrollPane = null;
    private JTree availableMMTree = null;
    private JButton selectMMButton = null;
    private JButton unselectMMButton = null;
    private JScrollPane selectedMMScrollPane = null;
    private JTree selectedMMTree = null;
    private JPanel evaluationSettingsPanel = null;
    private JTabbedPane evalSettingsTabbedPane = null;
    private JPanel generalEvalSettingsPanel = null;
    private JCheckBox qrtCheckBox = null;
    private JCheckBox execTimeCheckBox = null;
    private JCheckBox memoryCheckBox = null;
    private JLabel qrtLabel = null;
    private JLabel execTimeLabel = null;
    private JLabel memoryLabel = null;
    private JPanel scalabilityPanel = null;
    private JCheckBox scalabilityCheckBox = null;
    private JLabel scalabilityEnableLabel = null;
    private JLabel scalabilityFractionLabel = null;
    private JSlider scalabilityFractionSlider = null;
    private JPanel binaryRelevanceEvalSettingsPanel = null;
    private JPanel gradedRelevanceEvalSettingsPanel = null;
    private JPanel binaryCompleteEvalSettingsPanel = null;
    private JPanel binaryIncompleteEvalSettingsPanel = null;
    private JCheckBox rpCheckBox = null;
    private JCheckBox f1CheckBox = null;
    private JCheckBox rfCheckBox = null;
    private JCheckBox apCheckBox = null;
    private JLabel rpLabel = null;
    private JLabel f1Label = null;
    private JLabel rfLabel = null;
    private JLabel apLabel = null;
    private JCheckBox apPrimeCheckBox = null;
    private JLabel apPrimeLabel = null;
    private JCheckBox bprefCheckBox = null;
    private JLabel bprefLabel = null;
    private JPanel gradedCompleteEvalSettingsPanel = null;
    private JPanel gradedIncompleteEvalSettingsPanel = null;
    private JCheckBox qCheckBox = null;
    private JLabel qLabel = null;
    private JCheckBox ndcgCheckBox = null;
    private JLabel ndcgLabel = null;
    private JCheckBox rbpCheckBox = null;
    private JLabel rbpLabel = null;
    private JLabel rbpParamLabel = null;
    private JTextField rbpParamTextField = null;
    private JCheckBox qPrimeCheckBox = null;
    private JLabel qPrimeLabel = null;
    private JCheckBox ndcgPrimeCheckBox = null;
    private JLabel ndcgPrimeLabel = null;
    private JPanel microMacroPanel = null;
    private JRadioButton microRadioButton = null;
    private JRadioButton macroRadioButton = null;
    private JRadioButton bothRadioButton = null;
    private JLabel microLabel = null;
    private JLabel macroLabel = null;
    private JLabel bothLabel = null;
    private ButtonGroup microMacroButtonGroup = null;
    private SME2 sme2 = null;
    private JPanel mainControlPanel = null;
    private JButton startButton = null;
    private JButton suspendButton = null;
    private JButton stopButton = null;
    private JProgressBar evalProgressBar = null;
    private JLabel lambdaLabel = null;
    private JTextField lambdaTextField = null;
    private JCheckBox autoSaveCheckBox = null;
    private JLabel autoSaveLabel = null;
    private JPanel evalResultsPanel = null;
    private JToolBar evalResultsJToolBar = null;
    private JSplitPane evalResultsSplitPane = null;
    private JScrollPane resultTreeScrollPane = null;
    private JTree resultTree = null;
    private JButton saveResultAsXMLButton = null;
    private JButton saveResultAsPDFButton = null;
    private JButton discardResultButton = null;
    private JButton loadResultButton = null;
    private JPanel noResultPanel = null;
    private JButton splitButton = null;
    private JButton mergeButton = null;
    private JPanel tcQualityPanel = null;
    private JCheckBox tcQualityCheckBox = null;
    private JSlider nFoldSlider = null;
    private JLabel nFoldLabel = null;
    private JLabel seedLabel = null;
    private JTextField seedTextField = null;
    private JLabel copyrightLabel = null;
    private JMenuBar jJMenuBar = null;
    private JMenu aboutMenu = null;
    private JMenuItem aboutMenuItem = null;
    private JMenu fileMenu = null;
    private JMenuItem exitMenuItem = null;

    public SME2MainFrame(SME2 sme2) {
        this.sme2 = sme2;
        this.initialize();
    }

    private void initialize() {
        this.microMacroButtonGroup = new ButtonGroup();
        this.setSize(950, 796);
        this.setJMenuBar(this.getJJMenuBar());
        this.setName("SME2MainFrame");
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(950, 0));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("Z:/eclipse_3_2_workspace/sme2_v1_4/resources/images/sme_icon.gif"));
        this.setContentPane(this.getMainPane());
        this.setTitle("SME^2 v2.0");
        this.setVisible(true);
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
            this.mainPane.add((Component)this.getTitlePanel(), "North");
            this.mainPane.add((Component)this.getMainTabbedPane(), "Center");
        }
        return this.mainPane;
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titleLabel = new JLabel();
            this.titleLabel.setText("SME^2 Semantic Web Service Matchmaker Evaluation Environment");
            this.titleLabel.setIcon(new ImageIcon("Z:/eclipse_3_2_workspace/sme2_v1_4/resources/images/sme_logo_med.jpg"));
            this.titlePanel = new JPanel();
            this.titlePanel.setLayout(new GridBagLayout());
            this.titlePanel.setBorder(BorderFactory.createBevelBorder(0));
            this.titlePanel.add((Component)this.titleLabel, new GridBagConstraints());
        }
        return this.titlePanel;
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
            this.mainTabbedPane.addTab("Configuration", null, this.getConfigPanel(), null);
            this.mainTabbedPane.addTab("Evaluation Results", null, this.getEvalResultsPanel(), null);
        }
        return this.mainTabbedPane;
    }

    private JPanel getConfigPanel() {
        if (this.configPanel == null) {
            GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
            gridBagConstraints111.gridx = 1;
            gridBagConstraints111.anchor = 13;
            gridBagConstraints111.insets = new Insets(5, 0, 0, 10);
            gridBagConstraints111.gridy = 3;
            this.copyrightLabel = new JLabel();
            this.copyrightLabel.setText("Copyright (c): DFKI, 2008");
            GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
            gridBagConstraints110.gridy = 2;
            gridBagConstraints110.fill = 2;
            gridBagConstraints110.ipadx = 0;
            gridBagConstraints110.gridwidth = 2;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.fill = 1;
            gridBagConstraints21.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints21.gridwidth = 1;
            gridBagConstraints21.gridy = 1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints14.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.insets = new Insets(0, 5, 10, 0);
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 0, 10, 5);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.ipady = 80;
            gridBagConstraints.gridy = 0;
            this.configPanel = new JPanel();
            this.configPanel.setLayout(new GridBagLayout());
            this.configPanel.setName("Configuration");
            this.configPanel.setBackground(new Color(184, 207, 229));
            this.configPanel.add((Component)this.getTcConfigPanel(), gridBagConstraints);
            this.configPanel.add((Component)this.getSettingsPanel(), gridBagConstraints4);
            this.configPanel.add((Component)this.getMmSelectionPanel(), gridBagConstraints14);
            this.configPanel.add((Component)this.getEvaluationSettingsPanel(), gridBagConstraints21);
            this.configPanel.add((Component)this.getMainControlPanel(), gridBagConstraints110);
            this.configPanel.add((Component)this.copyrightLabel, gridBagConstraints111);
        }
        return this.configPanel;
    }

    private JPanel getTcConfigPanel() {
        if (this.tcConfigPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.ipady = 80;
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.ipady = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints2.anchor = 13;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.gridwidth = 1;
            gridBagConstraints1.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints1.ipady = 0;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.ipadx = 100;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridx = 1;
            this.selectedTCLabel = new JLabel();
            this.selectedTCLabel.setText("Selected test collection:");
            this.tcConfigPanel = new JPanel();
            this.tcConfigPanel.setLayout(new GridBagLayout());
            this.tcConfigPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Test Collection", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.tcConfigPanel.setBackground(new Color(184, 207, 229));
            this.tcConfigPanel.add((Component)this.selectedTCLabel, gridBagConstraints2);
            this.tcConfigPanel.add((Component)this.getTcSelectionComboBox(), gridBagConstraints1);
            this.tcConfigPanel.add((Component)this.getTcInfoScrollPane(), gridBagConstraints3);
        }
        return this.tcConfigPanel;
    }

    private JComboBox getTcSelectionComboBox() {
        if (this.tcSelectionComboBox == null) {
            this.tcSelectionComboBox = new JComboBox();
            this.tcSelectionComboBox.setPreferredSize(new Dimension(100, 25));
            this.tcSelectionComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setTestCollection((TestCollection)SME2MainFrame.this.tcSelectionComboBox.getSelectedItem());
                    SME2MainFrame.this.updateTestCollectionInfo();
                }
            });
        }
        return this.tcSelectionComboBox;
    }

    private JScrollPane getTcInfoScrollPane() {
        if (this.tcInfoScrollPane == null) {
            this.tcInfoScrollPane = new JScrollPane();
            this.tcInfoScrollPane.setName("Information");
            this.tcInfoScrollPane.setPreferredSize(new Dimension(0, 80));
            this.tcInfoScrollPane.setViewportView(this.getTcInfoTable());
        }
        return this.tcInfoScrollPane;
    }

    private JTable getTcInfoTable() {
        if (this.tcInfoTable == null) {
            this.tcInfoTable = new JTable();
            this.tcInfoTable.setPreferredSize(new Dimension(375, 80));
            this.tcInfoTable.setSelectionMode(0);
            this.tcInfoTable.setLocation(new Point(0, 0));
            this.tcInfoTable.setSize(new Dimension(450, 80));
            this.tcInfoTable.setName("Information");
            this.tcInfoTable.setAutoResizeMode(3);
        }
        return this.tcInfoTable;
    }

    private JPanel getSettingsPanel() {
        if (this.settingsPanel == null) {
            GridBagConstraints gridBagConstraints70 = new GridBagConstraints();
            gridBagConstraints70.gridx = 0;
            gridBagConstraints70.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints70.anchor = 13;
            gridBagConstraints70.gridy = 2;
            this.autoSaveLabel = new JLabel();
            this.autoSaveLabel.setText("Auto-save results:");
            GridBagConstraints gridBagConstraints69 = new GridBagConstraints();
            gridBagConstraints69.gridx = 1;
            gridBagConstraints69.anchor = 17;
            gridBagConstraints69.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints69.gridy = 2;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 3;
            gridBagConstraints13.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints13.gridy = 1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.gridy = 1;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.gridwidth = 2;
            gridBagConstraints12.ipadx = 2;
            gridBagConstraints12.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints12.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 0;
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints11.gridy = 1;
            this.outputDirLabel = new JLabel();
            this.outputDirLabel.setText("Output directory:");
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints10.anchor = 13;
            gridBagConstraints10.gridy = 0;
            this.settingsFileLabel = new JLabel();
            this.settingsFileLabel.setText("Current settings file:");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints8.ipadx = 150;
            gridBagConstraints8.ipady = 0;
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridy = -1;
            gridBagConstraints9.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints9.gridx = 2;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 3;
            gridBagConstraints7.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 0;
            this.settingsPanel = new JPanel();
            this.settingsPanel.setLayout(new GridBagLayout());
            this.settingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "General", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.settingsPanel.setBackground(new Color(184, 207, 229));
            this.settingsPanel.add((Component)this.getSaveSettingsButton(), gridBagConstraints9);
            this.settingsPanel.add((Component)this.getLoadSettingsButton(), gridBagConstraints7);
            this.settingsPanel.add((Component)this.getSettingsFileTextField(), gridBagConstraints8);
            this.settingsPanel.add((Component)this.settingsFileLabel, gridBagConstraints10);
            this.settingsPanel.add((Component)this.outputDirLabel, gridBagConstraints11);
            this.settingsPanel.add((Component)this.getOutputDirTextField(), gridBagConstraints12);
            this.settingsPanel.add((Component)this.getChangeOutputDirButton(), gridBagConstraints13);
            this.settingsPanel.add((Component)this.getAutoSaveCheckBox(), gridBagConstraints69);
            this.settingsPanel.add((Component)this.autoSaveLabel, gridBagConstraints70);
        }
        return this.settingsPanel;
    }

    private JButton getSaveSettingsButton() {
        if (this.saveSettingsButton == null) {
            this.saveSettingsButton = new JButton();
            this.saveSettingsButton.setText("Save");
            this.saveSettingsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block3: {
                        File file;
                        block4: {
                            int confirmValue;
                            do {
                                JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                                fileChooser.setFileSelectionMode(0);
                                fileChooser.addChoosableFileFilter(new CustomizableFileFilter("Configuration XML file (.xml)", "xml"));
                                fileChooser.setAcceptAllFileFilterUsed(false);
                                int returnValue = fileChooser.showDialog(null, "Save configuration");
                                if (returnValue != 0) break block3;
                                file = fileChooser.getSelectedFile();
                                String fileName = file.getAbsolutePath();
                                if (!fileName.toLowerCase().endsWith(".xml")) {
                                    file = new File(String.valueOf(fileName) + ".xml");
                                }
                                if (!file.exists()) break block4;
                            } while ((confirmValue = JOptionPane.showConfirmDialog(null, "File " + file.getName() + " already exists! Do you really want to overwrite?", "Warning", 1)) == 1);
                            if (confirmValue == 2) break block3;
                            if (confirmValue == 0) {
                                file.delete();
                            }
                        }
                        SME2MainFrame.this.sme2.getConfiguration().save(file.getAbsolutePath());
                        SME2MainFrame.this.settingsFileTextField.setText(file.getName());
                    }
                }
            });
        }
        return this.saveSettingsButton;
    }

    private JButton getLoadSettingsButton() {
        if (this.loadSettingsButton == null) {
            this.loadSettingsButton = new JButton();
            this.loadSettingsButton.setText("Load");
            this.loadSettingsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.addChoosableFileFilter(new CustomizableFileFilter("Configuration XML file (.xml)", "xml"));
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    int returnValue = fileChooser.showDialog(null, "Load configuration");
                    if (returnValue == 0) {
                        File file = fileChooser.getSelectedFile();
                        SME2MainFrame.this.sme2.loadConfiguration(file.getAbsolutePath());
                        SME2MainFrame.this.settingsFileTextField.setText(file.getName());
                    }
                }
            });
        }
        return this.loadSettingsButton;
    }

    private JTextField getSettingsFileTextField() {
        if (this.settingsFileTextField == null) {
            this.settingsFileTextField = new JTextField();
            this.settingsFileTextField.setPreferredSize(new Dimension(200, 20));
            this.settingsFileTextField.setEditable(false);
        }
        return this.settingsFileTextField;
    }

    private JTextField getOutputDirTextField() {
        if (this.outputDirTextField == null) {
            this.outputDirTextField = new JTextField();
            this.outputDirTextField.setPreferredSize(new Dimension(300, 20));
            this.outputDirTextField.setEditable(false);
        }
        return this.outputDirTextField;
    }

    private JButton getChangeOutputDirButton() {
        if (this.changeOutputDirButton == null) {
            this.changeOutputDirButton = new JButton();
            this.changeOutputDirButton.setText("Change");
            this.changeOutputDirButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                    fileChooser.setFileSelectionMode(1);
                    int returnValue = fileChooser.showDialog(null, "Select result output directory");
                    if (returnValue == 0) {
                        File selectedDir = fileChooser.getSelectedFile();
                        SME2MainFrame.this.sme2.getConfiguration().setOutputDirectory(selectedDir.getAbsolutePath());
                        SME2MainFrame.this.outputDirTextField.setText(selectedDir.getAbsolutePath());
                    }
                }
            });
        }
        return this.changeOutputDirButton;
    }

    private JPanel getMmSelectionPanel() {
        if (this.mmSelectionPanel == null) {
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 1;
            gridBagConstraints18.gridy = 0;
            gridBagConstraints18.weightx = 1.0;
            gridBagConstraints18.weighty = 1.0;
            gridBagConstraints18.gridheight = 2;
            gridBagConstraints18.gridx = 2;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 1;
            gridBagConstraints17.weighty = 0.5;
            gridBagConstraints17.insets = new Insets(10, 0, 0, 10);
            gridBagConstraints17.anchor = 11;
            gridBagConstraints17.gridy = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 1;
            gridBagConstraints16.weighty = 0.5;
            gridBagConstraints16.insets = new Insets(0, 0, 10, 10);
            gridBagConstraints16.anchor = 15;
            gridBagConstraints16.gridy = 0;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.gridy = 0;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.weighty = 1.0;
            gridBagConstraints15.ipady = 180;
            gridBagConstraints15.gridheight = 2;
            gridBagConstraints15.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints15.gridx = 0;
            this.mmSelectionPanel = new JPanel();
            this.mmSelectionPanel.setLayout(new GridBagLayout());
            this.mmSelectionPanel.setPreferredSize(new Dimension(500, 500));
            this.mmSelectionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Matchmaker Selection", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.mmSelectionPanel.setBackground(new Color(184, 207, 229));
            this.mmSelectionPanel.add((Component)this.getAvailableMMScrollPane(), gridBagConstraints15);
            this.mmSelectionPanel.add((Component)this.getSelectMMButton(), gridBagConstraints16);
            this.mmSelectionPanel.add((Component)this.getUnselectMMButton(), gridBagConstraints17);
            this.mmSelectionPanel.add((Component)this.getSelectedMMScrollPane(), gridBagConstraints18);
        }
        return this.mmSelectionPanel;
    }

    private JScrollPane getAvailableMMScrollPane() {
        if (this.availableMMScrollPane == null) {
            this.availableMMScrollPane = new JScrollPane();
            this.availableMMScrollPane.setViewportView(this.getAvailableMMTree());
        }
        return this.availableMMScrollPane;
    }

    private JTree getAvailableMMTree() {
        if (this.availableMMTree == null) {
            this.availableMMTree = new JTree();
            this.availableMMTree.setBounds(new Rectangle(0, 0, 181, 169));
            this.availableMMTree.getSelectionModel().setSelectionMode(1);
        }
        return this.availableMMTree;
    }

    private JButton getSelectMMButton() {
        if (this.selectMMButton == null) {
            this.selectMMButton = new JButton();
            this.selectMMButton.setText(">>");
            this.selectMMButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath path = SME2MainFrame.this.availableMMTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    DefaultMutableTreeNode selectionRoot = (DefaultMutableTreeNode)SME2MainFrame.this.selectedMMTree.getModel().getRoot();
                    DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (currentNode.getLevel() == 1) {
                        boolean found = false;
                        int i = 0;
                        while (i < selectionRoot.getChildCount()) {
                            TreeNode groupNode = selectionRoot.getChildAt(i);
                            if (groupNode.toString().equals(currentNode.toString())) {
                                found = true;
                                while (currentNode.getChildCount() > 0) {
                                    DefaultMutableTreeNode mmNode = (DefaultMutableTreeNode)currentNode.getFirstChild();
                                    ((DefaultMutableTreeNode)groupNode).add(mmNode);
                                }
                                ((DefaultMutableTreeNode)currentNode.getParent()).remove(currentNode);
                                break;
                            }
                            ++i;
                        }
                        if (!found) {
                            selectionRoot.add(currentNode);
                        }
                    } else if (currentNode.getLevel() == 2) {
                        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
                        boolean found = false;
                        int i = 0;
                        while (i < selectionRoot.getChildCount()) {
                            TreeNode groupNode = selectionRoot.getChildAt(i);
                            if (groupNode.toString().equals(currentNode.getParent().toString())) {
                                found = true;
                                ((DefaultMutableTreeNode)groupNode).add(currentNode);
                                break;
                            }
                            ++i;
                        }
                        if (!found) {
                            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(parentNode.toString());
                            newNode.add(currentNode);
                            selectionRoot.add(newNode);
                        }
                        if (parentNode.getChildCount() == 0) {
                            ((DefaultMutableTreeNode)SME2MainFrame.this.availableMMTree.getModel().getRoot()).remove(parentNode);
                        }
                    } else if (currentNode.getLevel() == 0) {
                        DefaultMutableTreeNode availableRoot = (DefaultMutableTreeNode)SME2MainFrame.this.availableMMTree.getModel().getRoot();
                        while (availableRoot.getChildCount() > 0) {
                            DefaultMutableTreeNode availableGroupNode = (DefaultMutableTreeNode)availableRoot.getFirstChild();
                            boolean found = false;
                            int j = 0;
                            while (j < selectionRoot.getChildCount()) {
                                TreeNode selectedGroupNode = selectionRoot.getChildAt(j);
                                if (selectedGroupNode.toString().equals(availableGroupNode.toString())) {
                                    found = true;
                                    while (availableGroupNode.getChildCount() > 0) {
                                        DefaultMutableTreeNode availableMMNode = (DefaultMutableTreeNode)availableGroupNode.getFirstChild();
                                        ((DefaultMutableTreeNode)selectedGroupNode).add(availableMMNode);
                                    }
                                    availableRoot.remove(availableGroupNode);
                                    break;
                                }
                                ++j;
                            }
                            if (found) continue;
                            selectionRoot.add(availableGroupNode);
                        }
                    }
                    SME2MainFrame.this.availableMMTree.updateUI();
                    SME2MainFrame.this.selectedMMTree.updateUI();
                    SME2MainFrame.this.sme2.getConfiguration().setSelectedMatchmakers(SME2MainFrame.this.selectedMMTree.getModel());
                }
            });
        }
        return this.selectMMButton;
    }

    private JButton getUnselectMMButton() {
        if (this.unselectMMButton == null) {
            this.unselectMMButton = new JButton();
            this.unselectMMButton.setText("<<");
            this.unselectMMButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath path = SME2MainFrame.this.selectedMMTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    DefaultMutableTreeNode availableRoot = (DefaultMutableTreeNode)SME2MainFrame.this.availableMMTree.getModel().getRoot();
                    DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (currentNode.getLevel() == 1) {
                        boolean found = false;
                        int i = 0;
                        while (i < availableRoot.getChildCount()) {
                            TreeNode groupNode = availableRoot.getChildAt(i);
                            if (groupNode.toString().equals(currentNode.toString())) {
                                found = true;
                                while (currentNode.getChildCount() > 0) {
                                    DefaultMutableTreeNode mmNode = (DefaultMutableTreeNode)currentNode.getFirstChild();
                                    ((DefaultMutableTreeNode)groupNode).add(mmNode);
                                }
                                ((DefaultMutableTreeNode)currentNode.getParent()).remove(currentNode);
                                break;
                            }
                            ++i;
                        }
                        if (!found) {
                            availableRoot.add(currentNode);
                        }
                    } else if (currentNode.getLevel() == 2) {
                        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
                        boolean found = false;
                        int i = 0;
                        while (i < availableRoot.getChildCount()) {
                            TreeNode groupNode = availableRoot.getChildAt(i);
                            if (groupNode.toString().equals(currentNode.getParent().toString())) {
                                found = true;
                                ((DefaultMutableTreeNode)groupNode).add(currentNode);
                                break;
                            }
                            ++i;
                        }
                        if (!found) {
                            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(parentNode.toString());
                            newNode.add(currentNode);
                            availableRoot.add(newNode);
                        }
                        if (parentNode.getChildCount() == 0) {
                            ((DefaultMutableTreeNode)SME2MainFrame.this.selectedMMTree.getModel().getRoot()).remove(parentNode);
                        }
                    } else if (currentNode.getLevel() == 0) {
                        DefaultMutableTreeNode selectionRoot = (DefaultMutableTreeNode)SME2MainFrame.this.selectedMMTree.getModel().getRoot();
                        while (selectionRoot.getChildCount() > 0) {
                            DefaultMutableTreeNode selectedGroupNode = (DefaultMutableTreeNode)selectionRoot.getFirstChild();
                            boolean found = false;
                            int j = 0;
                            while (j < availableRoot.getChildCount()) {
                                TreeNode availableGroupNode = availableRoot.getChildAt(j);
                                if (availableGroupNode.toString().equals(selectedGroupNode.toString())) {
                                    found = true;
                                    while (selectedGroupNode.getChildCount() > 0) {
                                        DefaultMutableTreeNode selectedMMNode = (DefaultMutableTreeNode)selectedGroupNode.getFirstChild();
                                        ((DefaultMutableTreeNode)availableGroupNode).add(selectedMMNode);
                                    }
                                    selectionRoot.remove(selectedGroupNode);
                                    break;
                                }
                                ++j;
                            }
                            if (found) continue;
                            availableRoot.add(selectedGroupNode);
                        }
                    }
                    SME2MainFrame.this.availableMMTree.updateUI();
                    SME2MainFrame.this.selectedMMTree.updateUI();
                    SME2MainFrame.this.sme2.getConfiguration().setSelectedMatchmakers(SME2MainFrame.this.selectedMMTree.getModel());
                }
            });
        }
        return this.unselectMMButton;
    }

    private JScrollPane getSelectedMMScrollPane() {
        if (this.selectedMMScrollPane == null) {
            this.selectedMMScrollPane = new JScrollPane();
            this.selectedMMScrollPane.setViewportView(this.getSelectedMMTree());
        }
        return this.selectedMMScrollPane;
    }

    private JTree getSelectedMMTree() {
        if (this.selectedMMTree == null) {
            this.selectedMMTree = new JTree();
            this.selectedMMTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("plugins")));
            this.selectedMMTree.getSelectionModel().setSelectionMode(1);
        }
        return this.selectedMMTree;
    }

    private JPanel getEvaluationSettingsPanel() {
        if (this.evaluationSettingsPanel == null) {
            this.evaluationSettingsPanel = new JPanel();
            this.evaluationSettingsPanel.setLayout(new BorderLayout());
            this.evaluationSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), "Evaluation", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.evaluationSettingsPanel.setBackground(new Color(184, 207, 229));
            this.evaluationSettingsPanel.add((Component)this.getEvalSettingsTabbedPane(), "Center");
        }
        return this.evaluationSettingsPanel;
    }

    private JTabbedPane getEvalSettingsTabbedPane() {
        if (this.evalSettingsTabbedPane == null) {
            this.evalSettingsTabbedPane = new JTabbedPane();
            this.evalSettingsTabbedPane.setTabPlacement(1);
            this.evalSettingsTabbedPane.addTab("General", null, this.getGeneralEvalSettingsPanel(), null);
            this.evalSettingsTabbedPane.addTab("Binary Relevance", null, this.getBinaryRelevanceEvalSettingsPanel(), null);
            this.evalSettingsTabbedPane.addTab("Graded Relevance", null, this.getGradedRelevanceEvalSettingsPanel(), null);
            this.evalSettingsTabbedPane.addTab("TC Quality", null, this.getTcQualityPanel(), null);
        }
        return this.evalSettingsTabbedPane;
    }

    private JPanel getGeneralEvalSettingsPanel() {
        if (this.generalEvalSettingsPanel == null) {
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 2;
            gridBagConstraints23.gridheight = 3;
            gridBagConstraints23.fill = 1;
            gridBagConstraints23.ipadx = 0;
            gridBagConstraints23.weightx = 1.0;
            gridBagConstraints23.gridwidth = 1;
            gridBagConstraints23.weighty = 0.0;
            gridBagConstraints23.ipady = 0;
            gridBagConstraints23.gridy = 0;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 1;
            gridBagConstraints26.anchor = 17;
            gridBagConstraints26.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints26.weighty = 1.0;
            gridBagConstraints26.gridy = 2;
            this.memoryLabel = new JLabel();
            this.memoryLabel.setText("Memory Consumption");
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 1;
            gridBagConstraints25.anchor = 17;
            gridBagConstraints25.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints25.weightx = 0.0;
            gridBagConstraints25.weighty = 0.0;
            gridBagConstraints25.gridy = 1;
            this.execTimeLabel = new JLabel();
            this.execTimeLabel.setText("Total Execution Time");
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 1;
            gridBagConstraints24.anchor = 17;
            gridBagConstraints24.insets = new Insets(0, 0, 5, 10);
            gridBagConstraints24.weighty = 1.0;
            gridBagConstraints24.gridy = 0;
            this.qrtLabel = new JLabel();
            this.qrtLabel.setText("Query Response Time");
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints22.weighty = 1.0;
            gridBagConstraints22.gridy = 2;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints20.weighty = 0.0;
            gridBagConstraints20.gridy = 1;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints19.weighty = 1.0;
            gridBagConstraints19.gridy = 0;
            this.generalEvalSettingsPanel = new JPanel();
            this.generalEvalSettingsPanel.setLayout(new GridBagLayout());
            this.generalEvalSettingsPanel.setPreferredSize(new Dimension(0, 63));
            this.generalEvalSettingsPanel.add((Component)this.getQrtCheckBox(), gridBagConstraints19);
            this.generalEvalSettingsPanel.add((Component)this.getExecTimeCheckBox(), gridBagConstraints20);
            this.generalEvalSettingsPanel.add((Component)this.getMemoryCheckBox(), gridBagConstraints22);
            this.generalEvalSettingsPanel.add((Component)this.qrtLabel, gridBagConstraints24);
            this.generalEvalSettingsPanel.add((Component)this.execTimeLabel, gridBagConstraints25);
            this.generalEvalSettingsPanel.add((Component)this.memoryLabel, gridBagConstraints26);
            this.generalEvalSettingsPanel.add((Component)this.getScalabilityPanel(), gridBagConstraints23);
        }
        return this.generalEvalSettingsPanel;
    }

    private JCheckBox getQrtCheckBox() {
        if (this.qrtCheckBox == null) {
            this.qrtCheckBox = new JCheckBox();
            this.qrtCheckBox.setSelected(true);
            this.qrtCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckQRT(SME2MainFrame.this.qrtCheckBox.isSelected());
                }
            });
        }
        return this.qrtCheckBox;
    }

    private JCheckBox getExecTimeCheckBox() {
        if (this.execTimeCheckBox == null) {
            this.execTimeCheckBox = new JCheckBox();
            this.execTimeCheckBox.setSelected(true);
            this.execTimeCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckExecTime(SME2MainFrame.this.execTimeCheckBox.isSelected());
                }
            });
        }
        return this.execTimeCheckBox;
    }

    private JCheckBox getMemoryCheckBox() {
        if (this.memoryCheckBox == null) {
            this.memoryCheckBox = new JCheckBox();
            this.memoryCheckBox.setSelected(true);
            this.memoryCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckMemory(SME2MainFrame.this.memoryCheckBox.isSelected());
                }
            });
        }
        return this.memoryCheckBox;
    }

    private JPanel getScalabilityPanel() {
        if (this.scalabilityPanel == null) {
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.fill = 2;
            gridBagConstraints30.gridy = 1;
            gridBagConstraints30.weightx = 1.0;
            gridBagConstraints30.gridwidth = 2;
            gridBagConstraints30.weighty = 0.0;
            gridBagConstraints30.anchor = 11;
            gridBagConstraints30.gridx = 0;
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.gridx = 0;
            gridBagConstraints29.gridwidth = 2;
            gridBagConstraints29.anchor = 11;
            gridBagConstraints29.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints29.weighty = 1.0;
            gridBagConstraints29.fill = 0;
            gridBagConstraints29.gridy = 2;
            this.scalabilityFractionLabel = new JLabel();
            this.scalabilityFractionLabel.setText("Fraction size (%) of service offers per run");
            this.scalabilityFractionLabel.setEnabled(false);
            this.scalabilityFractionLabel.setPreferredSize(new Dimension(232, 16));
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 1;
            gridBagConstraints28.anchor = 16;
            gridBagConstraints28.weighty = 1.0;
            gridBagConstraints28.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints28.gridy = 0;
            this.scalabilityEnableLabel = new JLabel();
            this.scalabilityEnableLabel.setText("Enabled");
            this.scalabilityEnableLabel.setEnabled(false);
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.gridx = 0;
            gridBagConstraints27.insets = new Insets(0, 0, 2, 5);
            gridBagConstraints27.weighty = 1.0;
            gridBagConstraints27.anchor = 15;
            gridBagConstraints27.gridy = 0;
            this.scalabilityPanel = new JPanel();
            this.scalabilityPanel.setLayout(new GridBagLayout());
            this.scalabilityPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 3), "Scalability Tests", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.scalabilityPanel.add((Component)this.getScalabilityCheckBox(), gridBagConstraints27);
            this.scalabilityPanel.add((Component)this.scalabilityEnableLabel, gridBagConstraints28);
            this.scalabilityPanel.add((Component)this.scalabilityFractionLabel, gridBagConstraints29);
            this.scalabilityPanel.add((Component)this.getScalabilityFractionSlider(), gridBagConstraints30);
        }
        return this.scalabilityPanel;
    }

    private JCheckBox getScalabilityCheckBox() {
        if (this.scalabilityCheckBox == null) {
            this.scalabilityCheckBox = new JCheckBox();
            this.scalabilityCheckBox.setEnabled(false);
            this.scalabilityCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckScalability(SME2MainFrame.this.scalabilityCheckBox.isSelected());
                    SME2MainFrame.this.sme2.getConfiguration().setScalabilityFractionSize(SME2MainFrame.this.scalabilityFractionSlider.getValue());
                    SME2MainFrame.this.scalabilityFractionSlider.setEnabled(SME2MainFrame.this.scalabilityCheckBox.isSelected());
                    SME2MainFrame.this.scalabilityFractionLabel.setEnabled(SME2MainFrame.this.scalabilityCheckBox.isSelected());
                }
            });
        }
        return this.scalabilityCheckBox;
    }

    private JSlider getScalabilityFractionSlider() {
        if (this.scalabilityFractionSlider == null) {
            this.scalabilityFractionSlider = new JSlider();
            this.scalabilityFractionSlider.setExtent(0);
            this.scalabilityFractionSlider.setMinimum(0);
            this.scalabilityFractionSlider.setMajorTickSpacing(10);
            this.scalabilityFractionSlider.setMinorTickSpacing(1);
            this.scalabilityFractionSlider.setPaintTicks(true);
            this.scalabilityFractionSlider.setPreferredSize(new Dimension(200, 50));
            this.scalabilityFractionSlider.setSnapToTicks(true);
            this.scalabilityFractionSlider.setValue(25);
            this.scalabilityFractionSlider.setPaintLabels(true);
            this.scalabilityFractionSlider.setEnabled(false);
            this.scalabilityFractionSlider.setMaximum(50);
            this.scalabilityFractionSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setScalabilityFractionSize(SME2MainFrame.this.scalabilityFractionSlider.getValue());
                }
            });
        }
        return this.scalabilityFractionSlider;
    }

    private JPanel getBinaryRelevanceEvalSettingsPanel() {
        if (this.binaryRelevanceEvalSettingsPanel == null) {
            GridBagConstraints gridBagConstraints68 = new GridBagConstraints();
            gridBagConstraints68.insets = new Insets(3, 0, 0, 0);
            gridBagConstraints68.gridy = 1;
            gridBagConstraints68.fill = 2;
            gridBagConstraints68.ipadx = 0;
            gridBagConstraints68.weightx = 0.0;
            gridBagConstraints68.gridx = 0;
            GridBagConstraints gridBagConstraints67 = new GridBagConstraints();
            gridBagConstraints67.insets = new Insets(5, 0, 2, 0);
            gridBagConstraints67.gridy = 0;
            gridBagConstraints67.fill = 2;
            gridBagConstraints67.ipadx = 0;
            gridBagConstraints67.gridx = 0;
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 1;
            gridBagConstraints32.fill = 1;
            gridBagConstraints32.gridy = 0;
            this.binaryRelevanceEvalSettingsPanel = new JPanel();
            this.binaryRelevanceEvalSettingsPanel.setLayout(new GridBagLayout());
            this.binaryRelevanceEvalSettingsPanel.add((Component)this.getBinaryCompleteEvalSettingsPanel(), gridBagConstraints67);
            this.binaryRelevanceEvalSettingsPanel.add((Component)this.getBinaryIncompleteEvalSettingsPanel(), gridBagConstraints68);
        }
        return this.binaryRelevanceEvalSettingsPanel;
    }

    private JPanel getGradedRelevanceEvalSettingsPanel() {
        if (this.gradedRelevanceEvalSettingsPanel == null) {
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(1);
            this.gradedRelevanceEvalSettingsPanel = new JPanel();
            this.gradedRelevanceEvalSettingsPanel.setLayout(gridLayout1);
            this.gradedRelevanceEvalSettingsPanel.add((Component)this.getGradedCompleteEvalSettingsPanel(), null);
            this.gradedRelevanceEvalSettingsPanel.add((Component)this.getGradedIncompleteEvalSettingsPanel(), null);
        }
        return this.gradedRelevanceEvalSettingsPanel;
    }

    private JPanel getBinaryCompleteEvalSettingsPanel() {
        if (this.binaryCompleteEvalSettingsPanel == null) {
            GridBagConstraints gridBagConstraints66 = new GridBagConstraints();
            gridBagConstraints66.fill = 3;
            gridBagConstraints66.gridy = 0;
            gridBagConstraints66.weightx = 1.0;
            gridBagConstraints66.ipadx = 10;
            gridBagConstraints66.anchor = 17;
            gridBagConstraints66.gridx = 3;
            GridBagConstraints gridBagConstraints65 = new GridBagConstraints();
            gridBagConstraints65.gridx = 2;
            gridBagConstraints65.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints65.weightx = 1.0;
            gridBagConstraints65.anchor = 13;
            gridBagConstraints65.gridy = 0;
            this.lambdaLabel = new JLabel();
            this.lambdaLabel.setText("lambda =");
            GridBagConstraints gridBagConstraints56 = new GridBagConstraints();
            gridBagConstraints56.gridx = 2;
            gridBagConstraints56.gridheight = 2;
            gridBagConstraints56.fill = 1;
            gridBagConstraints56.weightx = 1.0;
            gridBagConstraints56.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints56.gridwidth = 2;
            gridBagConstraints56.gridy = 1;
            GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
            gridBagConstraints39.gridx = 1;
            gridBagConstraints39.anchor = 17;
            gridBagConstraints39.weighty = 1.0;
            gridBagConstraints39.gridwidth = 2;
            gridBagConstraints39.gridy = 3;
            this.apLabel = new JLabel();
            this.apLabel.setText("Average Precision (AP)");
            this.apLabel.setEnabled(true);
            GridBagConstraints gridBagConstraints38 = new GridBagConstraints();
            gridBagConstraints38.gridx = 1;
            gridBagConstraints38.anchor = 17;
            gridBagConstraints38.weighty = 1.0;
            gridBagConstraints38.gridy = 2;
            this.rfLabel = new JLabel();
            this.rfLabel.setText("Recall/Fallout");
            GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
            gridBagConstraints37.gridx = 1;
            gridBagConstraints37.anchor = 17;
            gridBagConstraints37.weighty = 1.0;
            gridBagConstraints37.gridy = 1;
            this.f1Label = new JLabel();
            this.f1Label.setText("F1-measure");
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.gridx = 1;
            gridBagConstraints36.anchor = 17;
            gridBagConstraints36.weighty = 1.0;
            gridBagConstraints36.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints36.gridy = 0;
            this.rpLabel = new JLabel();
            this.rpLabel.setText("Recall/Precision");
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.gridx = 0;
            gridBagConstraints35.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints35.gridy = 3;
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.gridx = 0;
            gridBagConstraints34.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints34.gridy = 2;
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.gridx = 0;
            gridBagConstraints33.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints33.gridy = 1;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints31.gridy = 0;
            this.binaryCompleteEvalSettingsPanel = new JPanel();
            this.binaryCompleteEvalSettingsPanel.setLayout(new GridBagLayout());
            this.binaryCompleteEvalSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 3), "Complete Relevance Sets", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.binaryCompleteEvalSettingsPanel.setPreferredSize(new Dimension(309, 171));
            this.binaryCompleteEvalSettingsPanel.add((Component)this.getRpCheckBox(), gridBagConstraints31);
            this.binaryCompleteEvalSettingsPanel.add((Component)this.getF1CheckBox(), gridBagConstraints33);
            this.binaryCompleteEvalSettingsPanel.add((Component)this.getRfCheckBox(), gridBagConstraints34);
            this.binaryCompleteEvalSettingsPanel.add((Component)this.getApCheckBox(), gridBagConstraints35);
            this.binaryCompleteEvalSettingsPanel.add((Component)this.rpLabel, gridBagConstraints36);
            this.binaryCompleteEvalSettingsPanel.add((Component)this.f1Label, gridBagConstraints37);
            this.binaryCompleteEvalSettingsPanel.add((Component)this.rfLabel, gridBagConstraints38);
            this.binaryCompleteEvalSettingsPanel.add((Component)this.apLabel, gridBagConstraints39);
            this.binaryCompleteEvalSettingsPanel.add((Component)this.getMicroMacroPanel(), gridBagConstraints56);
            this.binaryCompleteEvalSettingsPanel.add((Component)this.lambdaLabel, gridBagConstraints65);
            this.binaryCompleteEvalSettingsPanel.add((Component)this.getLambdaTextField(), gridBagConstraints66);
        }
        return this.binaryCompleteEvalSettingsPanel;
    }

    private JPanel getBinaryIncompleteEvalSettingsPanel() {
        if (this.binaryIncompleteEvalSettingsPanel == null) {
            GridBagConstraints gridBagConstraints43 = new GridBagConstraints();
            gridBagConstraints43.gridx = 1;
            gridBagConstraints43.anchor = 17;
            gridBagConstraints43.weighty = 1.0;
            gridBagConstraints43.insets = new Insets(0, 0, 20, 0);
            gridBagConstraints43.gridy = 1;
            this.bprefLabel = new JLabel();
            this.bprefLabel.setText("bpref");
            this.bprefLabel.setEnabled(false);
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
            gridBagConstraints42.gridx = 0;
            gridBagConstraints42.insets = new Insets(0, 5, 20, 5);
            gridBagConstraints42.gridy = 1;
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridx = 1;
            gridBagConstraints41.anchor = 17;
            gridBagConstraints41.weighty = 1.0;
            gridBagConstraints41.insets = new Insets(20, 0, 0, 0);
            gridBagConstraints41.fill = 0;
            gridBagConstraints41.gridy = 0;
            this.apPrimeLabel = new JLabel();
            this.apPrimeLabel.setText("Average Precision (AP')");
            this.apPrimeLabel.setDisplayedMnemonic(0);
            this.apPrimeLabel.setEnabled(true);
            GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
            gridBagConstraints40.gridx = 0;
            gridBagConstraints40.insets = new Insets(20, 5, 0, 5);
            gridBagConstraints40.gridy = 0;
            this.binaryIncompleteEvalSettingsPanel = new JPanel();
            this.binaryIncompleteEvalSettingsPanel.setLayout(new GridBagLayout());
            this.binaryIncompleteEvalSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 3), "Incomplete Relevance Sets", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.binaryIncompleteEvalSettingsPanel.setPreferredSize(new Dimension(309, 112));
            this.binaryIncompleteEvalSettingsPanel.add((Component)this.getApPrimeCheckBox(), gridBagConstraints40);
            this.binaryIncompleteEvalSettingsPanel.add((Component)this.apPrimeLabel, gridBagConstraints41);
            this.binaryIncompleteEvalSettingsPanel.add((Component)this.getBprefCheckBox(), gridBagConstraints42);
            this.binaryIncompleteEvalSettingsPanel.add((Component)this.bprefLabel, gridBagConstraints43);
        }
        return this.binaryIncompleteEvalSettingsPanel;
    }

    private JCheckBox getRpCheckBox() {
        if (this.rpCheckBox == null) {
            this.rpCheckBox = new JCheckBox();
            this.rpCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckRP(SME2MainFrame.this.rpCheckBox.isSelected());
                }
            });
        }
        return this.rpCheckBox;
    }

    private JCheckBox getF1CheckBox() {
        if (this.f1CheckBox == null) {
            this.f1CheckBox = new JCheckBox();
            this.f1CheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckF1(SME2MainFrame.this.f1CheckBox.isSelected());
                }
            });
        }
        return this.f1CheckBox;
    }

    private JCheckBox getRfCheckBox() {
        if (this.rfCheckBox == null) {
            this.rfCheckBox = new JCheckBox();
            this.rfCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckRF(SME2MainFrame.this.rfCheckBox.isSelected());
                }
            });
        }
        return this.rfCheckBox;
    }

    private JCheckBox getApCheckBox() {
        if (this.apCheckBox == null) {
            this.apCheckBox = new JCheckBox();
            this.apCheckBox.setEnabled(true);
            this.apCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckAP(SME2MainFrame.this.apCheckBox.isSelected());
                }
            });
        }
        return this.apCheckBox;
    }

    private JCheckBox getApPrimeCheckBox() {
        if (this.apPrimeCheckBox == null) {
            this.apPrimeCheckBox = new JCheckBox();
            this.apPrimeCheckBox.setEnabled(true);
            this.apPrimeCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckAPPrime(SME2MainFrame.this.apPrimeCheckBox.isSelected());
                }
            });
        }
        return this.apPrimeCheckBox;
    }

    private JCheckBox getBprefCheckBox() {
        if (this.bprefCheckBox == null) {
            this.bprefCheckBox = new JCheckBox();
            this.bprefCheckBox.setEnabled(false);
        }
        return this.bprefCheckBox;
    }

    private JPanel getGradedCompleteEvalSettingsPanel() {
        if (this.gradedCompleteEvalSettingsPanel == null) {
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            gridBagConstraints51.fill = 0;
            gridBagConstraints51.gridy = 2;
            gridBagConstraints51.weightx = 0.0;
            gridBagConstraints51.anchor = 17;
            gridBagConstraints51.gridx = 3;
            GridBagConstraints gridBagConstraints50 = new GridBagConstraints();
            gridBagConstraints50.gridx = 2;
            gridBagConstraints50.weightx = 0.0;
            gridBagConstraints50.anchor = 13;
            gridBagConstraints50.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints50.gridy = 2;
            this.rbpParamLabel = new JLabel();
            this.rbpParamLabel.setText("p =");
            this.rbpParamLabel.setEnabled(false);
            GridBagConstraints gridBagConstraints49 = new GridBagConstraints();
            gridBagConstraints49.gridx = 1;
            gridBagConstraints49.anchor = 17;
            gridBagConstraints49.weightx = 0.0;
            gridBagConstraints49.gridy = 2;
            this.rbpLabel = new JLabel();
            this.rbpLabel.setText("RBP");
            this.rbpLabel.setEnabled(false);
            GridBagConstraints gridBagConstraints48 = new GridBagConstraints();
            gridBagConstraints48.gridx = 0;
            gridBagConstraints48.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints48.weighty = 1.0;
            gridBagConstraints48.gridy = 2;
            GridBagConstraints gridBagConstraints47 = new GridBagConstraints();
            gridBagConstraints47.gridx = 1;
            gridBagConstraints47.anchor = 17;
            gridBagConstraints47.gridy = 1;
            this.ndcgLabel = new JLabel();
            this.ndcgLabel.setText("nDCG");
            this.ndcgLabel.setEnabled(true);
            GridBagConstraints gridBagConstraints46 = new GridBagConstraints();
            gridBagConstraints46.gridx = 0;
            gridBagConstraints46.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints46.weighty = 1.0;
            gridBagConstraints46.gridy = 1;
            GridBagConstraints gridBagConstraints45 = new GridBagConstraints();
            gridBagConstraints45.gridx = 1;
            gridBagConstraints45.anchor = 17;
            gridBagConstraints45.gridy = 0;
            this.qLabel = new JLabel();
            this.qLabel.setText("Q-measure");
            this.qLabel.setEnabled(true);
            GridBagConstraints gridBagConstraints44 = new GridBagConstraints();
            gridBagConstraints44.gridx = 0;
            gridBagConstraints44.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints44.weighty = 1.0;
            gridBagConstraints44.gridy = 0;
            this.gradedCompleteEvalSettingsPanel = new JPanel();
            this.gradedCompleteEvalSettingsPanel.setLayout(new GridBagLayout());
            this.gradedCompleteEvalSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 3), "Complete Relevance Sets", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.gradedCompleteEvalSettingsPanel.add((Component)this.getQCheckBox(), gridBagConstraints44);
            this.gradedCompleteEvalSettingsPanel.add((Component)this.qLabel, gridBagConstraints45);
            this.gradedCompleteEvalSettingsPanel.add((Component)this.getNdcgCheckBox(), gridBagConstraints46);
            this.gradedCompleteEvalSettingsPanel.add((Component)this.ndcgLabel, gridBagConstraints47);
            this.gradedCompleteEvalSettingsPanel.add((Component)this.getRbpCheckBox(), gridBagConstraints48);
            this.gradedCompleteEvalSettingsPanel.add((Component)this.rbpLabel, gridBagConstraints49);
            this.gradedCompleteEvalSettingsPanel.add((Component)this.rbpParamLabel, gridBagConstraints50);
            this.gradedCompleteEvalSettingsPanel.add((Component)this.getRbpParamTextField(), gridBagConstraints51);
        }
        return this.gradedCompleteEvalSettingsPanel;
    }

    private JPanel getGradedIncompleteEvalSettingsPanel() {
        if (this.gradedIncompleteEvalSettingsPanel == null) {
            GridBagConstraints gridBagConstraints55 = new GridBagConstraints();
            gridBagConstraints55.gridx = 1;
            gridBagConstraints55.anchor = 17;
            gridBagConstraints55.insets = new Insets(0, 0, 20, 0);
            gridBagConstraints55.gridy = 1;
            this.ndcgPrimeLabel = new JLabel();
            this.ndcgPrimeLabel.setText("nDCG'");
            this.ndcgPrimeLabel.setEnabled(true);
            GridBagConstraints gridBagConstraints54 = new GridBagConstraints();
            gridBagConstraints54.gridx = 0;
            gridBagConstraints54.insets = new Insets(0, 5, 20, 5);
            gridBagConstraints54.weighty = 1.0;
            gridBagConstraints54.gridy = 1;
            GridBagConstraints gridBagConstraints53 = new GridBagConstraints();
            gridBagConstraints53.gridx = 1;
            gridBagConstraints53.anchor = 17;
            gridBagConstraints53.insets = new Insets(20, 0, 0, 0);
            gridBagConstraints53.gridy = 0;
            this.qPrimeLabel = new JLabel();
            this.qPrimeLabel.setText("Q-measure (Q')");
            this.qPrimeLabel.setEnabled(true);
            GridBagConstraints gridBagConstraints52 = new GridBagConstraints();
            gridBagConstraints52.gridx = 0;
            gridBagConstraints52.insets = new Insets(20, 5, 0, 5);
            gridBagConstraints52.weighty = 1.0;
            gridBagConstraints52.gridy = 0;
            this.gradedIncompleteEvalSettingsPanel = new JPanel();
            this.gradedIncompleteEvalSettingsPanel.setLayout(new GridBagLayout());
            this.gradedIncompleteEvalSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 3), "Incomplete Relevance Sets", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.gradedIncompleteEvalSettingsPanel.add((Component)this.getQPrimeCheckBox(), gridBagConstraints52);
            this.gradedIncompleteEvalSettingsPanel.add((Component)this.qPrimeLabel, gridBagConstraints53);
            this.gradedIncompleteEvalSettingsPanel.add((Component)this.getNdcgPrimeCheckBox(), gridBagConstraints54);
            this.gradedIncompleteEvalSettingsPanel.add((Component)this.ndcgPrimeLabel, gridBagConstraints55);
        }
        return this.gradedIncompleteEvalSettingsPanel;
    }

    private JCheckBox getQCheckBox() {
        if (this.qCheckBox == null) {
            this.qCheckBox = new JCheckBox();
            this.qCheckBox.setEnabled(true);
            this.qCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckQ(SME2MainFrame.this.qCheckBox.isSelected());
                }
            });
        }
        return this.qCheckBox;
    }

    private JCheckBox getNdcgCheckBox() {
        if (this.ndcgCheckBox == null) {
            this.ndcgCheckBox = new JCheckBox();
            this.ndcgCheckBox.setEnabled(true);
            this.ndcgCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckNDCG(SME2MainFrame.this.ndcgCheckBox.isSelected());
                }
            });
        }
        return this.ndcgCheckBox;
    }

    private JCheckBox getRbpCheckBox() {
        if (this.rbpCheckBox == null) {
            this.rbpCheckBox = new JCheckBox();
            this.rbpCheckBox.setEnabled(false);
        }
        return this.rbpCheckBox;
    }

    private JTextField getRbpParamTextField() {
        if (this.rbpParamTextField == null) {
            this.rbpParamTextField = new JTextField();
            this.rbpParamTextField.setText("0.8");
            this.rbpParamTextField.setEditable(false);
            this.rbpParamTextField.setEnabled(false);
            this.rbpParamTextField.setPreferredSize(new Dimension(40, 20));
        }
        return this.rbpParamTextField;
    }

    private JCheckBox getQPrimeCheckBox() {
        if (this.qPrimeCheckBox == null) {
            this.qPrimeCheckBox = new JCheckBox();
            this.qPrimeCheckBox.setEnabled(true);
            this.qPrimeCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckQPrime(SME2MainFrame.this.qPrimeCheckBox.isSelected());
                }
            });
        }
        return this.qPrimeCheckBox;
    }

    private JCheckBox getNdcgPrimeCheckBox() {
        if (this.ndcgPrimeCheckBox == null) {
            this.ndcgPrimeCheckBox = new JCheckBox();
            this.ndcgPrimeCheckBox.setEnabled(true);
            this.ndcgPrimeCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckNDCGPrime(SME2MainFrame.this.ndcgPrimeCheckBox.isSelected());
                }
            });
        }
        return this.ndcgPrimeCheckBox;
    }

    private JPanel getMicroMacroPanel() {
        if (this.microMacroPanel == null) {
            GridBagConstraints gridBagConstraints62 = new GridBagConstraints();
            gridBagConstraints62.gridx = 1;
            gridBagConstraints62.anchor = 17;
            gridBagConstraints62.gridy = 2;
            this.bothLabel = new JLabel();
            this.bothLabel.setText("Both");
            GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
            gridBagConstraints61.gridx = 1;
            gridBagConstraints61.anchor = 17;
            gridBagConstraints61.gridy = 1;
            this.macroLabel = new JLabel();
            this.macroLabel.setText("Macro");
            GridBagConstraints gridBagConstraints60 = new GridBagConstraints();
            gridBagConstraints60.gridx = 1;
            gridBagConstraints60.anchor = 17;
            gridBagConstraints60.gridy = 0;
            this.microLabel = new JLabel();
            this.microLabel.setText("Micro");
            GridBagConstraints gridBagConstraints59 = new GridBagConstraints();
            gridBagConstraints59.gridx = 0;
            gridBagConstraints59.gridy = 2;
            GridBagConstraints gridBagConstraints58 = new GridBagConstraints();
            gridBagConstraints58.gridx = 0;
            gridBagConstraints58.gridy = 1;
            GridBagConstraints gridBagConstraints57 = new GridBagConstraints();
            gridBagConstraints57.gridx = 0;
            gridBagConstraints57.gridy = 0;
            this.microMacroPanel = new JPanel();
            this.microMacroPanel.setLayout(new GridBagLayout());
            this.microMacroPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray, 1), "Averaging", 0, 0, null, null));
            this.microMacroPanel.add((Component)this.getMicroRadioButton(), gridBagConstraints57);
            this.microMacroPanel.add((Component)this.getMacroRadioButton(), gridBagConstraints58);
            this.microMacroPanel.add((Component)this.getBothRadioButton(), gridBagConstraints59);
            this.microMacroPanel.add((Component)this.microLabel, gridBagConstraints60);
            this.microMacroPanel.add((Component)this.macroLabel, gridBagConstraints61);
            this.microMacroPanel.add((Component)this.bothLabel, gridBagConstraints62);
        }
        return this.microMacroPanel;
    }

    private JRadioButton getMicroRadioButton() {
        if (this.microRadioButton == null) {
            this.microRadioButton = new JRadioButton();
            this.microRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setUseMicroAvg(true);
                    SME2MainFrame.this.sme2.getConfiguration().setUseMacroAvg(false);
                }
            });
            this.microMacroButtonGroup.add(this.microRadioButton);
        }
        return this.microRadioButton;
    }

    private JRadioButton getMacroRadioButton() {
        if (this.macroRadioButton == null) {
            this.macroRadioButton = new JRadioButton();
            this.macroRadioButton.setSelected(true);
            this.macroRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setUseMicroAvg(false);
                    SME2MainFrame.this.sme2.getConfiguration().setUseMacroAvg(true);
                }
            });
            this.microMacroButtonGroup.add(this.macroRadioButton);
        }
        return this.macroRadioButton;
    }

    private JRadioButton getBothRadioButton() {
        if (this.bothRadioButton == null) {
            this.bothRadioButton = new JRadioButton();
            this.bothRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setUseMicroAvg(true);
                    SME2MainFrame.this.sme2.getConfiguration().setUseMacroAvg(true);
                }
            });
            this.microMacroButtonGroup.add(this.bothRadioButton);
        }
        return this.bothRadioButton;
    }

    private JPanel getMainControlPanel() {
        if (this.mainControlPanel == null) {
            GridBagConstraints gridBagConstraints64 = new GridBagConstraints();
            gridBagConstraints64.gridx = 0;
            gridBagConstraints64.gridwidth = 3;
            gridBagConstraints64.fill = 2;
            gridBagConstraints64.ipadx = 0;
            gridBagConstraints64.weightx = 1.0;
            gridBagConstraints64.gridy = 1;
            GridBagConstraints gridBagConstraints63 = new GridBagConstraints();
            gridBagConstraints63.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints63.anchor = 13;
            gridBagConstraints63.ipadx = 0;
            gridBagConstraints63.weightx = 1.0;
            gridBagConstraints63.fill = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.gridy = 0;
            this.mainControlPanel = new JPanel();
            this.mainControlPanel.setLayout(new GridBagLayout());
            this.mainControlPanel.setBackground(new Color(184, 207, 229));
            this.mainControlPanel.add((Component)this.getStartButton(), gridBagConstraints63);
            this.mainControlPanel.add((Component)this.getSuspendButton(), gridBagConstraints5);
            this.mainControlPanel.add((Component)this.getStopButton(), gridBagConstraints6);
            this.mainControlPanel.add((Component)this.getEvalProgressBar(), gridBagConstraints64);
        }
        return this.mainControlPanel;
    }

    private JButton getStartButton() {
        if (this.startButton == null) {
            this.startButton = new JButton();
            this.startButton.setText("Start");
            this.startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SME2MainFrame.this.sme2.getConfiguration().isValid()) {
                        SME2MainFrame.this.switchControlsWhileEvaluating();
                        SME2MainFrame.this.sme2.startEvaluationThread();
                    } else {
                        JOptionPane.showMessageDialog(null, "The configuration is not valid. Please check if a test collection is available and at least one matchmaker plugin is selected.", "Invalid Configuration", 0);
                    }
                }
            });
        }
        return this.startButton;
    }

    private JButton getSuspendButton() {
        if (this.suspendButton == null) {
            this.suspendButton = new JButton();
            this.suspendButton.setText("Suspend");
            this.suspendButton.setEnabled(false);
            this.suspendButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SME2MainFrame.this.sme2.suspendEvaluationThread();
                    SME2MainFrame.this.suspendButton.setEnabled(false);
                    SME2MainFrame.this.startButton.setEnabled(true);
                }
            });
        }
        return this.suspendButton;
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setText("Abort");
            this.stopButton.setEnabled(false);
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SME2MainFrame.this.suspendButton.setEnabled(false);
                    SME2MainFrame.this.stopButton.setEnabled(false);
                    SME2MainFrame.this.sme2.stopEvaluationThread();
                }
            });
        }
        return this.stopButton;
    }

    private JProgressBar getEvalProgressBar() {
        if (this.evalProgressBar == null) {
            this.evalProgressBar = new JProgressBar();
            this.evalProgressBar.setStringPainted(true);
            this.evalProgressBar.setValue(0);
            this.evalProgressBar.setString("Ready");
        }
        return this.evalProgressBar;
    }

    public void setAvailableMatchmakers(DefaultMutableTreeNode rootNode) {
        this.availableMMTree.setModel(new DefaultTreeModel(rootNode));
    }

    public void setAvailableTestCollections(DefaultComboBoxModel model) {
        this.tcSelectionComboBox.setModel(model);
        this.updateTestCollectionInfo();
    }

    private void updateTestCollectionInfo() {
        TestCollection tc = (TestCollection)this.tcSelectionComboBox.getSelectedItem();
        Object[] columnNames = new String[]{"Property", "Value"};
        Object[][] entries = new String[5][2];
        entries[0][0] = "service type";
        entries[0][1] = tc.getType();
        entries[1][0] = "# of service offers";
        entries[1][1] = "" + tc.getServiceOffers().size();
        entries[2][0] = "# of requests";
        entries[2][1] = "" + tc.getQueries().size();
        entries[3][0] = "authors";
        entries[3][1] = tc.getAuthors();
        entries[4][0] = "description";
        entries[4][1] = tc.getDescription();
        DefaultTableModel model = new DefaultTableModel(entries, columnNames);
        this.tcInfoTable.setModel(model);
        this.tcInfoTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.tcInfoTable.getColumnModel().getColumn(1).setPreferredWidth(320);
    }

    private JTextField getLambdaTextField() {
        if (this.lambdaTextField == null) {
            this.lambdaTextField = new JTextField();
            this.lambdaTextField.setText("20");
            this.lambdaTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    try {
                        SME2MainFrame.this.sme2.getConfiguration().setLambda(new Integer(SME2MainFrame.this.lambdaTextField.getText()));
                    }
                    catch (NumberFormatException ex) {
                        SME2MainFrame.this.sme2.getConfiguration().setLambda(-1);
                    }
                }
            });
        }
        return this.lambdaTextField;
    }

    public ResultDesktopPane addResultDesktopPane(String title, MatchmakerEvaluationResult[] results, boolean saved) {
        ResultDesktopPane resultsPane = new ResultDesktopPane(this.sme2, title, results, saved);
        DefaultMutableTreeNode panelNode = new DefaultMutableTreeNode(resultsPane);
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = 0;
        int n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n];
            DefaultMutableTreeNode resultNode = new DefaultMutableTreeNode(result);
            panelNode.add(resultNode);
            ++n;
        }
        ((DefaultMutableTreeNode)this.resultTree.getModel().getRoot()).add(panelNode);
        this.resultTree.updateUI();
        this.evalResultsSplitPane.setRightComponent(resultsPane);
        return resultsPane;
    }

    public void updateEvalProgressBar(String text, int value) {
        this.evalProgressBar.setString(text);
        this.evalProgressBar.setValue(value);
    }

    public void updateControls(Configuration config) {
        this.tcSelectionComboBox.setSelectedItem(config.getTestCollection());
        this.updateMatchmakerSelection(config);
        this.outputDirTextField.setText(config.getOutputDirectory());
        this.autoSaveCheckBox.setSelected(config.isAutoSave());
        this.qrtCheckBox.setSelected(config.isCheckQRT());
        this.execTimeCheckBox.setSelected(config.isCheckExecTime());
        this.memoryCheckBox.setSelected(config.isCheckMemory());
        this.scalabilityCheckBox.setSelected(config.isCheckScalability());
        this.scalabilityFractionSlider.setEnabled(config.isCheckScalability());
        this.scalabilityFractionSlider.setValue(config.getScalabilityFractionSize());
        this.lambdaTextField.setText(new Integer(config.getLambda()).toString());
        this.rpCheckBox.setSelected(config.isCheckRP());
        this.f1CheckBox.setSelected(config.isCheckF1());
        this.rfCheckBox.setSelected(config.isCheckRF());
        this.apCheckBox.setSelected(config.isCheckAP());
        if (config.isUseMicroAvg() && config.isUseMacroAvg()) {
            this.microRadioButton.setSelected(false);
            this.macroRadioButton.setSelected(false);
            this.bothRadioButton.setSelected(true);
        } else if (config.isUseMicroAvg()) {
            this.microRadioButton.setSelected(true);
            this.macroRadioButton.setSelected(false);
            this.bothRadioButton.setSelected(false);
        } else {
            this.microRadioButton.setSelected(false);
            this.macroRadioButton.setSelected(true);
            this.bothRadioButton.setSelected(false);
        }
        this.apPrimeCheckBox.setSelected(config.isCheckAPPrime());
        this.bprefCheckBox.setSelected(config.isCheckBpref());
        this.qCheckBox.setSelected(config.isCheckQ());
        this.ndcgCheckBox.setSelected(config.isCheckNDCG());
        this.rbpCheckBox.setSelected(config.isCheckRBP());
        this.rbpParamTextField.setText(new Double(config.getRbpParam()).toString());
        this.qPrimeCheckBox.setSelected(config.isCheckQPrime());
        this.ndcgPrimeCheckBox.setSelected(config.isCheckNDCGPrime());
        this.tcQualityCheckBox.setSelected(config.isCheckTCQuality());
        this.nFoldSlider.setEnabled(config.isCheckTCQuality());
        this.nFoldSlider.setValue(config.getFolds());
        this.seedTextField.setText(new Long(config.getSeed()).toString());
    }

    private void updateMatchmakerSelection(Configuration config) {
    }

    private JCheckBox getAutoSaveCheckBox() {
        if (this.autoSaveCheckBox == null) {
            this.autoSaveCheckBox = new JCheckBox();
            this.autoSaveCheckBox.setSelected(false);
            this.autoSaveCheckBox.setBackground(new Color(184, 207, 229));
            this.autoSaveCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setAutoSave(SME2MainFrame.this.autoSaveCheckBox.isSelected());
                }
            });
        }
        return this.autoSaveCheckBox;
    }

    public void switchControlsWhileEvaluating() {
        this.startButton.setEnabled(false);
        this.suspendButton.setEnabled(true);
        this.stopButton.setEnabled(true);
        this.tcSelectionComboBox.setEnabled(false);
        this.saveSettingsButton.setEnabled(false);
        this.loadSettingsButton.setEnabled(false);
        this.changeOutputDirButton.setEnabled(false);
        this.autoSaveCheckBox.setEnabled(false);
        this.selectMMButton.setEnabled(false);
        this.unselectMMButton.setEnabled(false);
        this.qrtCheckBox.setEnabled(false);
        this.execTimeCheckBox.setEnabled(false);
        this.memoryCheckBox.setEnabled(false);
        this.scalabilityCheckBox.setEnabled(false);
        this.scalabilityFractionSlider.setEnabled(false);
        this.lambdaTextField.setEnabled(false);
        this.rpCheckBox.setEnabled(false);
        this.f1CheckBox.setEnabled(false);
        this.rfCheckBox.setEnabled(false);
        this.microRadioButton.setEnabled(false);
        this.macroRadioButton.setEnabled(false);
        this.bothRadioButton.setEnabled(false);
        this.apCheckBox.setEnabled(false);
        this.tcQualityCheckBox.setEnabled(false);
        this.nFoldSlider.setEnabled(false);
        this.seedTextField.setEnabled(false);
    }

    public void switchControlsAfterEvaluation() {
        this.startButton.setEnabled(true);
        this.suspendButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.tcSelectionComboBox.setEnabled(true);
        this.saveSettingsButton.setEnabled(true);
        this.loadSettingsButton.setEnabled(true);
        this.changeOutputDirButton.setEnabled(true);
        this.autoSaveCheckBox.setEnabled(true);
        this.selectMMButton.setEnabled(true);
        this.unselectMMButton.setEnabled(true);
        this.qrtCheckBox.setEnabled(true);
        this.execTimeCheckBox.setEnabled(true);
        this.memoryCheckBox.setEnabled(true);
        this.scalabilityCheckBox.setEnabled(true);
        this.scalabilityFractionSlider.setEnabled(this.scalabilityCheckBox.isSelected());
        this.lambdaTextField.setEnabled(true);
        this.rpCheckBox.setEnabled(true);
        this.f1CheckBox.setEnabled(true);
        this.rfCheckBox.setEnabled(true);
        this.microRadioButton.setEnabled(true);
        this.macroRadioButton.setEnabled(true);
        this.bothRadioButton.setEnabled(true);
        this.apCheckBox.setEnabled(true);
        this.tcQualityCheckBox.setEnabled(true);
        this.nFoldSlider.setEnabled(this.tcQualityCheckBox.isSelected());
        this.seedTextField.setEnabled(this.tcQualityCheckBox.isSelected());
    }

    private JPanel getEvalResultsPanel() {
        if (this.evalResultsPanel == null) {
            this.evalResultsPanel = new JPanel();
            this.evalResultsPanel.setLayout(new BorderLayout());
            this.evalResultsPanel.add((Component)this.getEvalResultsJToolBar(), "North");
            this.evalResultsPanel.add((Component)this.getEvalResultsSplitPane(), "Center");
        }
        return this.evalResultsPanel;
    }

    private JToolBar getEvalResultsJToolBar() {
        if (this.evalResultsJToolBar == null) {
            this.evalResultsJToolBar = new JToolBar();
            this.evalResultsJToolBar.setFloatable(false);
            this.evalResultsJToolBar.add(this.getSaveResultAsXMLButton());
            this.evalResultsJToolBar.add(this.getSaveResultAsPDFButton());
            this.evalResultsJToolBar.add(this.getDiscardResultButton());
            this.evalResultsJToolBar.add(this.getLoadResultButton());
            this.evalResultsJToolBar.add(this.getSplitButton());
            this.evalResultsJToolBar.add(this.getMergeButton());
        }
        return this.evalResultsJToolBar;
    }

    private JSplitPane getEvalResultsSplitPane() {
        if (this.evalResultsSplitPane == null) {
            this.evalResultsSplitPane = new JSplitPane();
            this.evalResultsSplitPane.setLeftComponent(this.getResultTreeScrollPane());
            this.evalResultsSplitPane.setRightComponent(this.getNoResultPanel());
        }
        return this.evalResultsSplitPane;
    }

    private JScrollPane getResultTreeScrollPane() {
        if (this.resultTreeScrollPane == null) {
            this.resultTreeScrollPane = new JScrollPane();
            this.resultTreeScrollPane.setViewportView(this.getResultTree());
        }
        return this.resultTreeScrollPane;
    }

    private JTree getResultTree() {
        if (this.resultTree == null) {
            this.resultTree = new JTree();
            this.resultTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("results")));
            this.resultTree.setPreferredSize(new Dimension(180, 20));
            this.resultTree.setSize(new Dimension(150, 624));
            this.resultTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    try {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)SME2MainFrame.this.resultTree.getSelectionPath().getPathComponent(1);
                        ResultDesktopPane resultPane = (ResultDesktopPane)node.getUserObject();
                        SME2MainFrame.this.evalResultsSplitPane.setRightComponent(resultPane);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.resultTree.getSelectionModel().setSelectionMode(4);
        }
        return this.resultTree;
    }

    private JButton getSaveResultAsXMLButton() {
        if (this.saveResultAsXMLButton == null) {
            this.saveResultAsXMLButton = new JButton();
            this.saveResultAsXMLButton.setText("Save");
            this.saveResultAsXMLButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block8: {
                        try {
                            boolean result;
                            ResultDesktopPane resultPane;
                            File file;
                            block9: {
                                int confirmValue;
                                do {
                                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)SME2MainFrame.this.resultTree.getSelectionPath().getLastPathComponent();
                                    resultPane = (ResultDesktopPane)node.getUserObject();
                                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                                    fileChooser.setFileSelectionMode(0);
                                    fileChooser.addChoosableFileFilter(new CustomizableFileFilter("Evaluation result XML file (.xml)", "xml"));
                                    fileChooser.setAcceptAllFileFilterUsed(false);
                                    int returnValue = fileChooser.showDialog(null, "Save result");
                                    if (returnValue != 0) break block8;
                                    file = fileChooser.getSelectedFile();
                                    String fileName = file.getAbsolutePath();
                                    if (!fileName.toLowerCase().endsWith(".xml")) {
                                        file = new File(String.valueOf(fileName) + ".xml");
                                    }
                                    if (!file.exists()) break block9;
                                } while ((confirmValue = JOptionPane.showConfirmDialog(null, "File " + file.getName() + " already exists! Do you really want to overwrite?", "Warning", 1)) == 1);
                                if (confirmValue == 2) break block8;
                                if (confirmValue == 0) {
                                    file.delete();
                                }
                            }
                            if (!(result = resultPane.save(file.getAbsolutePath()))) {
                                JOptionPane.showMessageDialog(null, "Error: Could not save results.", "Save error", 0);
                            } else {
                                resultPane.setTitle(file.getName().replaceAll(".xml", ""));
                                SME2MainFrame.this.resultTree.updateUI();
                            }
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, "Error: No result has been selected for save operation.", "Save error", 0);
                        }
                    }
                }
            });
        }
        return this.saveResultAsXMLButton;
    }

    private JButton getSaveResultAsPDFButton() {
        if (this.saveResultAsPDFButton == null) {
            this.saveResultAsPDFButton = new JButton();
            this.saveResultAsPDFButton.setText("PDF Export");
            this.saveResultAsPDFButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block7: {
                        try {
                            boolean result;
                            ResultDesktopPane resultPane;
                            File file;
                            block8: {
                                int confirmValue;
                                do {
                                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)SME2MainFrame.this.resultTree.getSelectionPath().getLastPathComponent();
                                    resultPane = (ResultDesktopPane)node.getUserObject();
                                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                                    fileChooser.setFileSelectionMode(0);
                                    fileChooser.addChoosableFileFilter(new CustomizableFileFilter("Evaluation report as PDF (.pdf)", "pdf"));
                                    fileChooser.setAcceptAllFileFilterUsed(false);
                                    int returnValue = fileChooser.showDialog(null, "Export as PDF");
                                    if (returnValue != 0) break block7;
                                    file = fileChooser.getSelectedFile();
                                    String fileName = file.getAbsolutePath();
                                    if (!fileName.toLowerCase().endsWith(".pdf")) {
                                        file = new File(String.valueOf(fileName) + ".pdf");
                                    }
                                    if (!file.exists()) break block8;
                                } while ((confirmValue = JOptionPane.showConfirmDialog(null, "File " + file.getName() + " already exists! Do you really want to overwrite?", "Warning", 1)) == 1);
                                if (confirmValue == 2) break block7;
                                if (confirmValue == 0) {
                                    file.delete();
                                }
                            }
                            if (!(result = resultPane.exportToPDF(file.getAbsolutePath()))) {
                                JOptionPane.showMessageDialog(null, "Error: Could not export results.", "Save error", 0);
                            }
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, "Error: No result has been selected for save operation.", "Save error", 0);
                        }
                    }
                }
            });
        }
        return this.saveResultAsPDFButton;
    }

    private JButton getDiscardResultButton() {
        if (this.discardResultButton == null) {
            this.discardResultButton = new JButton();
            this.discardResultButton.setText("Load");
            this.discardResultButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.addChoosableFileFilter(new CustomizableFileFilter("Evaluation result XML file (.xml)", "xml"));
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    int returnValue = fileChooser.showDialog(null, "Load result");
                    if (returnValue == 0) {
                        File file = fileChooser.getSelectedFile();
                        MatchmakerEvaluationResult[] results = MatchmakerEvaluationResult.load(file.getAbsolutePath());
                        ResultDesktopPane pane = SME2MainFrame.this.addResultDesktopPane(file.getName().replaceAll(".xml", ""), results, true);
                        TCQualityTestResult tcTest = TCQualityTestResult.load(file.getAbsolutePath());
                        if (tcTest != null) {
                            pane.addTCQualityTestResult(tcTest);
                        }
                    }
                }
            });
        }
        return this.discardResultButton;
    }

    private JButton getLoadResultButton() {
        if (this.loadResultButton == null) {
            this.loadResultButton = new JButton();
            this.loadResultButton.setText("Discard");
            this.loadResultButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)SME2MainFrame.this.resultTree.getSelectionPath().getLastPathComponent();
                        ResultDesktopPane resultPane = (ResultDesktopPane)node.getUserObject();
                        ((DefaultTreeModel)SME2MainFrame.this.resultTree.getModel()).removeNodeFromParent(node);
                        if ((ResultDesktopPane)SME2MainFrame.this.evalResultsSplitPane.getRightComponent() == resultPane) {
                            SME2MainFrame.this.evalResultsSplitPane.setRightComponent(SME2MainFrame.this.noResultPanel);
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Error: No result has been selected for discard operation.", "Discard error", 0);
                    }
                }
            });
        }
        return this.loadResultButton;
    }

    private JPanel getNoResultPanel() {
        if (this.noResultPanel == null) {
            this.noResultPanel = new JPanel();
            this.noResultPanel.setLayout(new GridBagLayout());
        }
        return this.noResultPanel;
    }

    private JButton getSplitButton() {
        if (this.splitButton == null) {
            this.splitButton = new JButton();
            this.splitButton.setText("Split");
            this.splitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)SME2MainFrame.this.resultTree.getSelectionPath().getLastPathComponent();
                        ResultDesktopPane resultPane = (ResultDesktopPane)node.getUserObject();
                        ((DefaultMutableTreeNode)node.getParent()).remove(node);
                        String originalTitle = resultPane.getTitle();
                        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = resultPane.getResults();
                        int n = 0;
                        int n2 = matchmakerEvaluationResultArray.length;
                        while (n < n2) {
                            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n];
                            SME2MainFrame.this.addResultDesktopPane(String.valueOf(originalTitle) + "_" + result.getMatchmakerName(), new MatchmakerEvaluationResult[]{result}, false);
                            ++n;
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "The split functionality does not work for selected item. Please select an evaluation run result.", "Split error", 0);
                    }
                }
            });
        }
        return this.splitButton;
    }

    private JButton getMergeButton() {
        if (this.mergeButton == null) {
            this.mergeButton = new JButton();
            this.mergeButton.setText("Merge");
            this.mergeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath selection;
                    TreePath[] selections = SME2MainFrame.this.resultTree.getSelectionPaths();
                    if (selections.length < 2) {
                        JOptionPane.showMessageDialog(null, "At least two evaluation results must be selected for the merge operation.", "Merge error", 0);
                        return;
                    }
                    Vector<MatchmakerEvaluationResult> results = new Vector<MatchmakerEvaluationResult>();
                    TreePath[] treePathArray = selections;
                    int n = 0;
                    int n2 = treePathArray.length;
                    while (n < n2) {
                        selection = treePathArray[n];
                        try {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection.getLastPathComponent();
                            ResultDesktopPane resultPane = (ResultDesktopPane)node.getUserObject();
                            MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = resultPane.getResults();
                            int n3 = 0;
                            int n4 = matchmakerEvaluationResultArray.length;
                            while (n3 < n4) {
                                MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n3];
                                results.add(result);
                                ++n3;
                            }
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, "Only evaluation run results must be selected for merging.", "Merge error", 0);
                            return;
                        }
                        ++n;
                    }
                    treePathArray = selections;
                    n = 0;
                    n2 = treePathArray.length;
                    while (n < n2) {
                        selection = treePathArray[n];
                        ((DefaultMutableTreeNode)selection.getLastPathComponent()).removeFromParent();
                        ++n;
                    }
                    SME2MainFrame.this.addResultDesktopPane("Merged results", results.toArray(new MatchmakerEvaluationResult[1]), false);
                }
            });
        }
        return this.mergeButton;
    }

    private JPanel getTcQualityPanel() {
        if (this.tcQualityPanel == null) {
            GridBagConstraints gridBagConstraints75 = new GridBagConstraints();
            gridBagConstraints75.fill = 3;
            gridBagConstraints75.gridy = 3;
            gridBagConstraints75.weightx = 0.5;
            gridBagConstraints75.ipadx = 40;
            gridBagConstraints75.anchor = 17;
            gridBagConstraints75.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints75.gridx = 1;
            GridBagConstraints gridBagConstraints74 = new GridBagConstraints();
            gridBagConstraints74.gridx = 0;
            gridBagConstraints74.weightx = 0.5;
            gridBagConstraints74.anchor = 13;
            gridBagConstraints74.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints74.gridy = 3;
            this.seedLabel = new JLabel();
            this.seedLabel.setText("Random seed");
            this.seedLabel.setEnabled(false);
            GridBagConstraints gridBagConstraints73 = new GridBagConstraints();
            gridBagConstraints73.gridx = 0;
            gridBagConstraints73.gridwidth = 2;
            gridBagConstraints73.gridy = 2;
            this.nFoldLabel = new JLabel();
            this.nFoldLabel.setText("# of folds");
            this.nFoldLabel.setEnabled(false);
            GridBagConstraints gridBagConstraints72 = new GridBagConstraints();
            gridBagConstraints72.fill = 3;
            gridBagConstraints72.gridy = 1;
            gridBagConstraints72.weightx = 1.0;
            gridBagConstraints72.ipady = 0;
            gridBagConstraints72.weighty = 0.0;
            gridBagConstraints72.gridwidth = 2;
            gridBagConstraints72.gridx = 0;
            GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
            gridBagConstraints71.gridx = 0;
            gridBagConstraints71.weighty = 0.0;
            gridBagConstraints71.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints71.gridwidth = 2;
            gridBagConstraints71.gridy = 0;
            this.tcQualityPanel = new JPanel();
            this.tcQualityPanel.setLayout(new GridBagLayout());
            this.tcQualityPanel.add((Component)this.getTcQualityCheckBox(), gridBagConstraints71);
            this.tcQualityPanel.add((Component)this.getNFoldSlider(), gridBagConstraints72);
            this.tcQualityPanel.add((Component)this.nFoldLabel, gridBagConstraints73);
            this.tcQualityPanel.add((Component)this.seedLabel, gridBagConstraints74);
            this.tcQualityPanel.add((Component)this.getSeedTextField(), gridBagConstraints75);
        }
        return this.tcQualityPanel;
    }

    private JCheckBox getTcQualityCheckBox() {
        if (this.tcQualityCheckBox == null) {
            this.tcQualityCheckBox = new JCheckBox();
            this.tcQualityCheckBox.setText("Test collection quality measuring");
            this.tcQualityCheckBox.setEnabled(false);
            this.tcQualityCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setCheckTCQuality(SME2MainFrame.this.tcQualityCheckBox.isSelected());
                    SME2MainFrame.this.nFoldSlider.setEnabled(SME2MainFrame.this.tcQualityCheckBox.isSelected());
                    SME2MainFrame.this.nFoldLabel.setEnabled(SME2MainFrame.this.tcQualityCheckBox.isSelected());
                    SME2MainFrame.this.seedLabel.setEnabled(SME2MainFrame.this.tcQualityCheckBox.isSelected());
                    SME2MainFrame.this.seedTextField.setEnabled(SME2MainFrame.this.tcQualityCheckBox.isSelected());
                }
            });
        }
        return this.tcQualityCheckBox;
    }

    private JSlider getNFoldSlider() {
        if (this.nFoldSlider == null) {
            this.nFoldSlider = new JSlider();
            this.nFoldSlider.setMinimum(2);
            this.nFoldSlider.setName("nFold");
            this.nFoldSlider.setPaintLabels(true);
            this.nFoldSlider.setPaintTicks(true);
            this.nFoldSlider.setSnapToTicks(true);
            this.nFoldSlider.setValue(10);
            this.nFoldSlider.setExtent(0);
            this.nFoldSlider.setMinorTickSpacing(1);
            this.nFoldSlider.setMajorTickSpacing(3);
            this.nFoldSlider.setEnabled(false);
            this.nFoldSlider.setMaximum(20);
            this.nFoldSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setFolds(SME2MainFrame.this.nFoldSlider.getValue());
                }
            });
        }
        return this.nFoldSlider;
    }

    private JTextField getSeedTextField() {
        if (this.seedTextField == null) {
            this.seedTextField = new JTextField();
            this.seedTextField.setText("1");
            this.seedTextField.setEnabled(false);
            this.seedTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SME2MainFrame.this.sme2.getConfiguration().setSeed(new Long(SME2MainFrame.this.seedTextField.getText()));
                }
            });
        }
        return this.seedTextField;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getAboutMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getAboutMenu() {
        if (this.aboutMenu == null) {
            this.aboutMenu = new JMenu();
            this.aboutMenu.setText("About");
            this.aboutMenu.add(this.getAboutMenuItem());
        }
        return this.aboutMenu;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog about = new AboutDialog(null);
                    about.display();
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setName("File");
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SME2MainFrame.this.quitApplication();
                }
            });
        }
        return this.exitMenuItem;
    }

    private void quitApplication() {
        this.dispose();
    }
}

