/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.gui.InternalChartFrame;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class Chart {
    protected JFreeChart chart;
    protected JComponent jComponent = null;
    protected String title = "Chart";

    public Chart(String title) {
        this.title = title;
    }

    public BufferedImage snapshot(int resX, int resY) {
        return this.chart.createBufferedImage(resX, resY);
    }

    public JComponent getJComponent() {
        if (this.jComponent == null) {
            this.jComponent = new ChartPanel(this.chart);
        }
        return this.jComponent;
    }

    public void save(File file, int resX, int resY) {
        String suffix = file.toString().split("\\.")[1];
        try {
            ImageIO.write((RenderedImage)this.snapshot(resX, resY), suffix, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save(JFreeChart chart, File file, int resX, int resY) {
        String suffix = file.toString().split("\\.")[1];
        try {
            ImageIO.write((RenderedImage)chart.createBufferedImage(resX, resY), suffix, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public InternalChartFrame getInternalFrame() {
        return new InternalChartFrame(this, this.title);
    }

    public static enum Type {
        RP_MICRO,
        RP_MACRO,
        F1_MICRO,
        F1_MACRO,
        RF_MICRO,
        RF_MACRO,
        EXEC_TIME,
        QRT,
        MEM_USAGE,
        SCALABILITY;

    }
}

