/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.gui.chart.Chart;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MemoryChart
extends Chart {
    public MemoryChart(MatchmakerEvaluationResult[] results) {
        super("Memory usage");
        XYSeriesCollection dataset = new XYSeriesCollection();
        int seriesID = 0;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = 0;
        int n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n];
            ArrayList<Long> memValues = result.getMemoryConsumption();
            List<Double> avgValues = this.averageValues(memValues, 100);
            XYSeries series = new XYSeries((Comparable)((Object)result.getMatchmakerName()));
            int percent = 0;
            for (Double memValue : avgValues) {
                series.add((double)percent, (Number)memValue);
                ++percent;
            }
            dataset.addSeries(series);
            ++seriesID;
            ++n;
        }
        this.chart = ChartFactory.createXYLineChart((String)this.title, (String)"runtime (%)", (String)"bytes", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getXYPlot().getDomainAxis().setRange(0.0, 100.0);
    }

    protected List<Double> averageValues(List<? extends Number> list, int count) {
        Vector<Double> res = new Vector<Double>(count);
        if (list.size() < count) {
            double D;
            double d = D = (double)count / (double)list.size() - 1.0;
            int list_i = 0;
            int i = 0;
            while (i < count) {
                double tmp;
                if (1.0 < d) {
                    d -= 1.0;
                    double prev = res.size() > 0 ? res.lastElement().doubleValue() : list.get(list.size() > list_i ? list_i : list.size()).doubleValue();
                    int index1 = Math.max(list.size() > list_i ? list_i : list.size() - 1, 0);
                    double cur = list.get(index1).doubleValue();
                    tmp = (cur + prev) / 2.0;
                } else {
                    d += D;
                    tmp = list.size() > list_i ? list.get(list_i++).doubleValue() : list.get(list.size() - 1).doubleValue();
                }
                res.add(i, tmp);
                ++i;
            }
        } else {
            double D = (double)list.size() / (double)count;
            double dd = 0.0;
            int list_i = 0;
            int i = 0;
            while (i < count) {
                int dif = 0;
                if (1.0 <= (dd += D - (double)((int)D))) {
                    dd = 0.0;
                    dif = 1;
                }
                double d = 0.0;
                int j = 0;
                while (j < (int)D + dif) {
                    d += list.get(list_i++).doubleValue();
                    ++j;
                }
                res.add(i, d /= (double)((int)D + dif));
                ++i;
            }
        }
        return res;
    }
}

