/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.gui.chart.Chart;
import de.dfki.sme2.util.metric.FriedmanTest;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryPointerAnnotation;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class NDCGPrimeChart
extends Chart {
    public NDCGPrimeChart(MatchmakerEvaluationResult[] results) {
        super("nDCG'");
        DefaultCategoryDataset dataSet = new DefaultCategoryDataset();
        double[] avgs = new double[results.length];
        double maxAvg = 0.0;
        int i = 0;
        while (i < results.length) {
            for (Double value : results[i].getNDCGPrimes().values()) {
                int n = i;
                avgs[n] = avgs[n] + value;
            }
            int n = i;
            avgs[n] = avgs[n] / (double)results[i].getNDCGPrimes().size();
            if (maxAvg < avgs[i]) {
                maxAvg = avgs[i];
            }
            ++i;
        }
        double maxValue = 0.0;
        int i2 = 0;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = 0;
        int n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n];
            int column = 1;
            dataSet.addValue(avgs[i2], (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)"avg"));
            dataSet.addValue(0.0, (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)""));
            for (Double value : result.getNDCGPrimes().values()) {
                dataSet.addValue((Number)value, (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)("qry " + column)));
                ++column;
                if (!(value > maxValue)) continue;
                maxValue = value;
            }
            ++i2;
            ++n;
        }
        this.chart = ChartFactory.createBarChart((String)this.title, (String)"queries", (String)"nDCG'", (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getCategoryPlot().getDomainAxis().setTickLabelsVisible(false);
        Vector<Vector<Double>> input = new Vector<Vector<Double>>();
        MatchmakerEvaluationResult[] column = results;
        n2 = 0;
        int n3 = column.length;
        while (n2 < n3) {
            MatchmakerEvaluationResult result = column[n2];
            input.add(new Vector<Double>(result.getNDCGPrimes().values()));
            ++n2;
        }
        double p = FriedmanTest.test(input);
        String annotationText = "Friedman test result: ";
        annotationText = FriedmanTest.isSignificant(p) ? String.valueOf(annotationText) + "there is a " + FriedmanTest.SIGNIFICANCE_THRESHOLD * 100.0 + "% significant difference (p = " + p + ")" : String.valueOf(annotationText) + "no " + FriedmanTest.SIGNIFICANCE_THRESHOLD * 100.0 + "% significant difference (p = " + p + ")";
        CategoryTextAnnotation annotation = new CategoryTextAnnotation(annotationText, dataSet.getColumnKey(dataSet.getColumnCount() / 2), maxValue + 0.01);
        this.chart.getCategoryPlot().addAnnotation((CategoryAnnotation)annotation);
        CategoryPointerAnnotation avgAnn = new CategoryPointerAnnotation("avg", (Comparable)((Object)"avg"), maxAvg, -1.55);
        this.chart.getCategoryPlot().addAnnotation((CategoryAnnotation)avgAnn);
    }
}

