/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.gui.chart.Chart;
import de.dfki.sme2.util.metric.FriedmanTest;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryPointerAnnotation;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class QChart
extends Chart {
    public QChart(MatchmakerEvaluationResult[] results) {
        super("Q-measure");
        DefaultCategoryDataset qDataSet = new DefaultCategoryDataset();
        double[] avgQs = new double[results.length];
        double maxAvg = 0.0;
        int i = 0;
        while (i < results.length) {
            for (Double qValue : results[i].getQs().values()) {
                int n = i;
                avgQs[n] = avgQs[n] + qValue;
            }
            int n = i;
            avgQs[n] = avgQs[n] / (double)results[i].getQs().size();
            if (maxAvg < avgQs[i]) {
                maxAvg = avgQs[i];
            }
            ++i;
        }
        double maxValue = 0.0;
        int i2 = 0;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = 0;
        int n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n];
            int column = 1;
            qDataSet.addValue(avgQs[i2], (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)"avg"));
            qDataSet.addValue(0.0, (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)""));
            for (Double qValue : result.getQs().values()) {
                qDataSet.addValue((Number)qValue, (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)("qry " + column)));
                ++column;
                if (!(qValue > maxValue)) continue;
                maxValue = qValue;
            }
            ++i2;
            ++n;
        }
        this.chart = ChartFactory.createBarChart((String)this.title, (String)"queries", (String)"Q", (CategoryDataset)qDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getCategoryPlot().getDomainAxis().setTickLabelsVisible(false);
        Vector<Vector<Double>> qResults = new Vector<Vector<Double>>();
        MatchmakerEvaluationResult[] column = results;
        n2 = 0;
        int n3 = column.length;
        while (n2 < n3) {
            MatchmakerEvaluationResult result = column[n2];
            qResults.add(new Vector<Double>(result.getQs().values()));
            ++n2;
        }
        double p = FriedmanTest.test(qResults);
        String annotationText = "Friedman test result: ";
        annotationText = FriedmanTest.isSignificant(p) ? String.valueOf(annotationText) + "there is a " + FriedmanTest.SIGNIFICANCE_THRESHOLD * 100.0 + "% significant difference (p = " + p + ")" : String.valueOf(annotationText) + "no " + FriedmanTest.SIGNIFICANCE_THRESHOLD * 100.0 + "% significant difference (p = " + p + ")";
        CategoryTextAnnotation annotation = new CategoryTextAnnotation(annotationText, qDataSet.getColumnKey(qDataSet.getColumnCount() / 2), maxValue + 0.01);
        this.chart.getCategoryPlot().addAnnotation((CategoryAnnotation)annotation);
        CategoryPointerAnnotation avgAnn = new CategoryPointerAnnotation("avg", (Comparable)((Object)"avg"), maxAvg, -1.55);
        this.chart.getCategoryPlot().addAnnotation((CategoryAnnotation)avgAnn);
    }
}

