/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.gui.chart.Chart;
import de.dfki.sme2.util.metric.FriedmanTest;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryPointerAnnotation;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class QPrimeChart
extends Chart {
    public QPrimeChart(MatchmakerEvaluationResult[] results) {
        super("Q'-measure");
        DefaultCategoryDataset qpDataSet = new DefaultCategoryDataset();
        double[] avgQPs = new double[results.length];
        double maxAvg = 0.0;
        int i = 0;
        while (i < results.length) {
            for (Double qpValue : results[i].getQPrimes().values()) {
                int n = i;
                avgQPs[n] = avgQPs[n] + qpValue;
            }
            int n = i;
            avgQPs[n] = avgQPs[n] / (double)results[i].getQPrimes().size();
            if (maxAvg < avgQPs[i]) {
                maxAvg = avgQPs[i];
            }
            ++i;
        }
        double maxValue = 0.0;
        int i2 = 0;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = 0;
        int n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n];
            int column = 1;
            qpDataSet.addValue(avgQPs[i2], (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)"avg"));
            qpDataSet.addValue(0.0, (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)""));
            for (Double qpValue : result.getQPrimes().values()) {
                qpDataSet.addValue((Number)qpValue, (Comparable)((Object)result.getMatchmakerName()), (Comparable)((Object)("qry " + column)));
                ++column;
                if (!(qpValue > maxValue)) continue;
                maxValue = qpValue;
            }
            ++i2;
            ++n;
        }
        this.chart = ChartFactory.createBarChart((String)this.title, (String)"queries", (String)"Q'", (CategoryDataset)qpDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getCategoryPlot().getDomainAxis().setTickLabelsVisible(false);
        Vector<Vector<Double>> qpResults = new Vector<Vector<Double>>();
        MatchmakerEvaluationResult[] column = results;
        n2 = 0;
        int n3 = column.length;
        while (n2 < n3) {
            MatchmakerEvaluationResult result = column[n2];
            qpResults.add(new Vector<Double>(result.getQPrimes().values()));
            ++n2;
        }
        double p = FriedmanTest.test(qpResults);
        String annotationText = "Friedman test result: ";
        annotationText = FriedmanTest.isSignificant(p) ? String.valueOf(annotationText) + "there is a " + FriedmanTest.SIGNIFICANCE_THRESHOLD * 100.0 + "% significant difference (p = " + p + ")" : String.valueOf(annotationText) + "no " + FriedmanTest.SIGNIFICANCE_THRESHOLD * 100.0 + "% significant difference (p = " + p + ")";
        CategoryTextAnnotation annotation = new CategoryTextAnnotation(annotationText, qpDataSet.getColumnKey(qpDataSet.getColumnCount() / 2), maxValue + 0.01);
        this.chart.getCategoryPlot().addAnnotation((CategoryAnnotation)annotation);
        CategoryPointerAnnotation avgAnn = new CategoryPointerAnnotation("avg", (Comparable)((Object)"avg"), maxAvg, -1.55);
        this.chart.getCategoryPlot().addAnnotation((CategoryAnnotation)avgAnn);
    }
}

