/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.gui.chart;

import de.dfki.sme2.MatchmakerEvaluationResult;
import de.dfki.sme2.gui.chart.Chart;
import de.dfki.sme2.util.metric.RecallFalloutPair;
import java.util.ArrayList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RecallFalloutChart
extends Chart {
    public RecallFalloutChart(MatchmakerEvaluationResult[] results, boolean microAvg) {
        super("Recall/Fallout");
        this.title = microAvg ? String.valueOf(this.title) + " (micro-averaged)" : String.valueOf(this.title) + " (macro-averaged)";
        XYSeriesCollection dataset = new XYSeriesCollection();
        int seriesID = 0;
        MatchmakerEvaluationResult[] matchmakerEvaluationResultArray = results;
        int n = 0;
        int n2 = matchmakerEvaluationResultArray.length;
        while (n < n2) {
            MatchmakerEvaluationResult result = matchmakerEvaluationResultArray[n];
            ArrayList<RecallFalloutPair> rpPairs = microAvg ? result.getMicroAvgRF() : result.getMacroAvgRF();
            XYSeries series = new XYSeries((Comparable)((Object)result.getMatchmakerName()));
            for (RecallFalloutPair pair : rpPairs) {
                series.add(pair.recall, pair.fallout);
            }
            dataset.addSeries(series);
            ++seriesID;
            ++n;
        }
        this.chart = ChartFactory.createXYLineChart((String)this.title, (String)"recall", (String)"fallout", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.chart.getXYPlot().getDomainAxis().setRange(0.0, 1.0);
    }
}

