/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.util.metric;

import de.dfki.sme2.util.metric.RecallPrecisionPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class MacroAvgRecallPrecision {
    public final int LEMDA_LEVELS;
    private double[] recall_levels;
    private double[] precisions;
    private int numOfQueries = 0;

    public MacroAvgRecallPrecision(int lambda) {
        this.LEMDA_LEVELS = lambda;
        this.recall_levels = new double[lambda];
        int i = 0;
        while (i < lambda) {
            this.recall_levels[i] = (double)i / (double)(lambda - 1);
            ++i;
        }
        this.precisions = new double[lambda];
        i = 0;
        while (i < lambda) {
            this.precisions[i] = 0.0;
            ++i;
        }
    }

    public void processRecallPrecision(List retrievals, ArrayList correctRetrievals) {
        ++this.numOfQueries;
        ArrayList<RecallPrecisionPair> RPs = new ArrayList<RecallPrecisionPair>();
        Vector<Double> retrieved = new Vector<Double>();
        Vector<Double> retrievedRelevant = new Vector<Double>();
        int goodRetrievals = 0;
        int i = 0;
        while (i < retrievals.size()) {
            int numRetrieved = i + 1;
            if (correctRetrievals.contains(retrievals.get(i))) {
                retrievedRelevant.add(new Double(++goodRetrievals));
                retrieved.add(new Double(numRetrieved));
                double recall = (double)goodRetrievals / (double)correctRetrievals.size();
                double precision = (double)goodRetrievals / (double)numRetrieved;
                RPs.add(new RecallPrecisionPair(recall, precision));
            }
            ++i;
        }
        double[] interpolatedPs = this.interpolatePrecision(RPs);
        int i2 = 0;
        while (i2 < this.LEMDA_LEVELS) {
            int n = i2;
            this.precisions[n] = this.precisions[n] + interpolatedPs[i2];
            ++i2;
        }
    }

    public ArrayList<RecallPrecisionPair> getMacroAveragePrecisions() {
        ArrayList<RecallPrecisionPair> rpList = new ArrayList<RecallPrecisionPair>();
        int i = 0;
        while (i < this.LEMDA_LEVELS) {
            rpList.add(new RecallPrecisionPair(this.recall_levels[i], this.precisions[i] / (double)this.numOfQueries));
            ++i;
        }
        return rpList;
    }

    private double[] interpolatePrecision(ArrayList rpPairs) {
        double[] precisions = new double[this.LEMDA_LEVELS];
        int i = 0;
        while (i < this.LEMDA_LEVELS) {
            double maxPrecision = 0.0;
            int j = 0;
            while (j < rpPairs.size()) {
                RecallPrecisionPair rpPair = (RecallPrecisionPair)rpPairs.get(j);
                if (rpPair.recall >= this.recall_levels[i] && rpPair.precision > maxPrecision) {
                    maxPrecision = rpPair.precision;
                }
                ++j;
            }
            precisions[i] = maxPrecision;
            ++i;
        }
        return precisions;
    }
}

