/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.util.metric;

import de.dfki.sme2.util.metric.RecallFalloutPair;
import java.util.ArrayList;
import java.util.List;

public class MicroAvgRecallFallout {
    private int LAMBDA;
    private int A = 0;
    private int notA = 0;
    private int[] retrievedIrrelevantAtOrAboveLambda;
    private int[] retrievedRelevantAtOrAboveLambda;

    public MicroAvgRecallFallout(int lambda) {
        this.LAMBDA = lambda;
        this.retrievedIrrelevantAtOrAboveLambda = new int[this.LAMBDA];
        int i = 0;
        while (i < this.LAMBDA) {
            this.retrievedIrrelevantAtOrAboveLambda[i] = 0;
            ++i;
        }
        this.retrievedRelevantAtOrAboveLambda = new int[this.LAMBDA];
        i = 0;
        while (i < this.LAMBDA) {
            this.retrievedRelevantAtOrAboveLambda[i] = 0;
            ++i;
        }
    }

    public void processRecallFallout(List retrievals, ArrayList correctRetrievals, int numOfDocs) {
        this.A += correctRetrievals.size();
        this.notA += numOfDocs - correctRetrievals.size();
        int retrievedRelevantDocs = 0;
        for (Object retrievedObject : retrievals) {
            if (!correctRetrievals.contains(retrievedObject)) continue;
            ++retrievedRelevantDocs;
        }
        double maxRecall = (double)retrievedRelevantDocs / (double)correctRetrievals.size();
        maxRecall = (double)Math.round(maxRecall * 100.0) / 100.0;
        double stepSize = maxRecall / (double)this.LAMBDA;
        retrievedRelevantDocs = 0;
        int retrievedDocs = 0;
        int retrievedCount = 0;
        int currentLevel = 0;
        int[] retrievedIrrelevantAtLambda = new int[this.LAMBDA];
        int[] retrievedRelevantAtLambda = new int[this.LAMBDA];
        int i = 0;
        while (i < this.LAMBDA) {
            retrievedIrrelevantAtLambda[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.LAMBDA) {
            retrievedRelevantAtLambda[i] = 0;
            ++i;
        }
        for (Object retrievedObject : retrievals) {
            ++retrievedDocs;
            ++retrievedCount;
            if (!correctRetrievals.contains(retrievedObject)) continue;
            double recall = (double)(++retrievedRelevantDocs) / (double)correctRetrievals.size();
            recall = (double)Math.round(recall * 100.0) / 100.0;
            while (recall > (double)(currentLevel + 1) * stepSize) {
                ++currentLevel;
            }
            if (currentLevel >= this.LAMBDA) {
                currentLevel = this.LAMBDA - 1;
            }
            int n = currentLevel;
            retrievedIrrelevantAtLambda[n] = retrievedIrrelevantAtLambda[n] + (retrievedCount - 1);
            int n2 = currentLevel;
            retrievedRelevantAtLambda[n2] = retrievedRelevantAtLambda[n2] + 1;
            retrievedCount = 0;
        }
        i = 0;
        while (i < this.LAMBDA) {
            int j = 0;
            while (j <= i) {
                int n = i;
                this.retrievedIrrelevantAtOrAboveLambda[n] = this.retrievedIrrelevantAtOrAboveLambda[n] + retrievedIrrelevantAtLambda[j];
                int n3 = i;
                this.retrievedRelevantAtOrAboveLambda[n3] = this.retrievedRelevantAtOrAboveLambda[n3] + retrievedRelevantAtLambda[j];
                ++j;
            }
            ++i;
        }
    }

    public ArrayList<RecallFalloutPair> getMicroAverageFallouts() {
        ArrayList<RecallFalloutPair> rfPairs = new ArrayList<RecallFalloutPair>();
        int i = 0;
        while (i < this.LAMBDA) {
            double recall = (double)this.retrievedRelevantAtOrAboveLambda[i] / (double)this.A;
            double fallout = (double)this.retrievedIrrelevantAtOrAboveLambda[i] / (double)this.notA;
            rfPairs.add(new RecallFalloutPair(recall, fallout));
            ++i;
        }
        return rfPairs;
    }
}

