/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.util.metric;

import de.dfki.sme2.util.metric.RecallPrecisionPair;
import java.util.ArrayList;
import java.util.List;

public class MicroAvgRecallPrecision {
    private int LAMBDA;
    private int A = 0;
    private int[] retrievedAtOrAboveLambda;
    private int[] retrievedRelevantAtOrAboveLambda;

    public MicroAvgRecallPrecision(int lambda) {
        this.LAMBDA = lambda;
        this.retrievedAtOrAboveLambda = new int[this.LAMBDA];
        int i = 0;
        while (i < this.LAMBDA) {
            this.retrievedAtOrAboveLambda[i] = 0;
            ++i;
        }
        this.retrievedRelevantAtOrAboveLambda = new int[this.LAMBDA];
        i = 0;
        while (i < this.LAMBDA) {
            this.retrievedRelevantAtOrAboveLambda[i] = 0;
            ++i;
        }
    }

    public void processRecallPrecision(List retrievals, ArrayList correctRetrievals) {
        this.A += correctRetrievals.size();
        int retrievedRelevantDocs = 0;
        for (Object retrievedObject : retrievals) {
            if (!correctRetrievals.contains(retrievedObject)) continue;
            ++retrievedRelevantDocs;
        }
        double maxRecall = (double)retrievedRelevantDocs / (double)correctRetrievals.size();
        maxRecall = (double)Math.round(maxRecall * 100.0) / 100.0;
        double stepSize = maxRecall / (double)this.LAMBDA;
        retrievedRelevantDocs = 0;
        int retrievedDocs = 0;
        int retrievedCount = 0;
        int currentLevel = 0;
        int[] retrievedAtLambda = new int[this.LAMBDA];
        int[] retrievedRelevantAtLambda = new int[this.LAMBDA];
        int i = 0;
        while (i < this.LAMBDA) {
            retrievedAtLambda[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.LAMBDA) {
            retrievedRelevantAtLambda[i] = 0;
            ++i;
        }
        for (Object retrievedObject : retrievals) {
            ++retrievedDocs;
            ++retrievedCount;
            if (!correctRetrievals.contains(retrievedObject)) continue;
            double recall = (double)(++retrievedRelevantDocs) / (double)correctRetrievals.size();
            recall = (double)Math.round(recall * 100.0) / 100.0;
            while (recall > (double)(currentLevel + 1) * stepSize) {
                ++currentLevel;
            }
            if (currentLevel >= this.LAMBDA) {
                currentLevel = this.LAMBDA - 1;
            }
            int n = currentLevel;
            retrievedAtLambda[n] = retrievedAtLambda[n] + retrievedCount;
            int n2 = currentLevel;
            retrievedRelevantAtLambda[n2] = retrievedRelevantAtLambda[n2] + 1;
            retrievedCount = 0;
        }
        i = 0;
        while (i < this.LAMBDA) {
            int j = 0;
            while (j <= i) {
                int n = i;
                this.retrievedAtOrAboveLambda[n] = this.retrievedAtOrAboveLambda[n] + retrievedAtLambda[j];
                int n3 = i;
                this.retrievedRelevantAtOrAboveLambda[n3] = this.retrievedRelevantAtOrAboveLambda[n3] + retrievedRelevantAtLambda[j];
                ++j;
            }
            ++i;
        }
    }

    public ArrayList<RecallPrecisionPair> getMicroAveragePrecisions() {
        ArrayList<RecallPrecisionPair> rpPairs = new ArrayList<RecallPrecisionPair>();
        int i = 0;
        while (i < this.LAMBDA) {
            double recall = (double)this.retrievedRelevantAtOrAboveLambda[i] / (double)this.A;
            double precision = (double)this.retrievedRelevantAtOrAboveLambda[i] / (double)this.retrievedAtOrAboveLambda[i];
            rpPairs.add(new RecallPrecisionPair(recall, precision));
            ++i;
        }
        return rpPairs;
    }
}

