/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.sme2.util.metric;

import de.dfki.sme2.RelevanceSet;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class SingleQueryMeasures {
    public static double BETA = 1.0;
    public static int A = 2;
    public static int L = 100;

    public static double getAveragePrecision(Vector<URL> ranking, Set<URL> relevants) {
        int R = relevants.size();
        if (R == 0) {
            return 1.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < ranking.size()) {
            URL elementAtRank = ranking.elementAt(i);
            if (relevants.contains(elementAtRank)) {
                sum += (double)SingleQueryMeasures.count(ranking, i, relevants) / (double)(i + 1);
            }
            ++i;
        }
        return sum / (double)R;
    }

    private static int count(Vector<URL> ranking, int rank, Set<URL> relevants) {
        int count = 0;
        int i = 0;
        while (i <= rank) {
            if (relevants.contains(ranking.elementAt(i))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static double getAveragePrecisionPrime(Vector<URL> ranking, RelevanceSet relSet) {
        Vector<URL> condensedR = new Vector<URL>();
        for (URL offer : ranking) {
            if (!relSet.isBinaryRelevant(offer) && !relSet.isBinaryIrrelevant(offer)) continue;
            condensedR.add(offer);
        }
        return SingleQueryMeasures.getAveragePrecision(condensedR, relSet.getBinaryRelevants());
    }

    public static double getQ(Vector<URL> ranking, RelevanceSet relSet) {
        Set<URL> relevants = relSet.getGradedRelevants().keySet();
        int R = relevants.size();
        double sum = 0.0;
        int i = 0;
        while (i < ranking.size()) {
            URL elementAtRank = ranking.elementAt(i);
            if (relSet.isGradedRelevant(elementAtRank)) {
                sum += (BETA * SingleQueryMeasures.cg(ranking, i, relSet) + (double)SingleQueryMeasures.count(ranking, i, relevants)) / (BETA * SingleQueryMeasures.cgI(i, relSet) + (double)i + 1.0);
            }
            ++i;
        }
        return sum / (double)R;
    }

    public static double getQPrime(Vector<URL> ranking, RelevanceSet relSet) {
        Vector<URL> condensedR = new Vector<URL>();
        for (URL offer : ranking) {
            if (!relSet.isGradedRelevant(offer) && !relSet.isGradedIrrelevant(offer)) continue;
            condensedR.add(offer);
        }
        return SingleQueryMeasures.getQ(condensedR, relSet);
    }

    private static double cg(Vector<URL> ranking, int rank, RelevanceSet relSet) {
        double sum = 0.0;
        int i = 0;
        while (i <= rank) {
            sum += relSet.getGain(ranking.elementAt(i));
            ++i;
        }
        return sum;
    }

    private static double cgI(int rank, RelevanceSet relSet) {
        double sum = 0.0;
        HashMap<URL, String> relevants = relSet.getGradedRelevants();
        Vector<Double> optimalRanking = new Vector<Double>();
        for (Map.Entry<URL, String> entry : relevants.entrySet()) {
            optimalRanking.add(new Double(relSet.getGain(entry.getValue())));
        }
        Collections.sort(optimalRanking);
        Collections.reverse(optimalRanking);
        int i = 0;
        while (i <= rank) {
            if (i >= optimalRanking.size()) break;
            sum += ((Double)optimalRanking.elementAt(i)).doubleValue();
            ++i;
        }
        return sum;
    }

    public static double getNDCG(Vector<URL> ranking, RelevanceSet relSet) {
        double nom = 0.0;
        double denom = 0.0;
        double logA = Math.log(A);
        int r = 1;
        while (r <= ranking.size() && r <= L) {
            URL service = ranking.elementAt(r - 1);
            double dg = relSet.getGain(service);
            if (r > A) {
                dg /= Math.log(r) / logA;
            }
            nom += dg;
            ++r;
        }
        HashMap<URL, String> relevants = relSet.getGradedRelevants();
        Vector<Double> optimalRanking = new Vector<Double>();
        for (Map.Entry<URL, String> entry : relevants.entrySet()) {
            optimalRanking.add(new Double(relSet.getGain(entry.getValue())));
        }
        Collections.sort(optimalRanking);
        Collections.reverse(optimalRanking);
        int r2 = 1;
        while (r2 <= optimalRanking.size() && r2 <= L) {
            double dgI = (Double)optimalRanking.elementAt(r2 - 1);
            if (r2 > A) {
                dgI /= Math.log(r2) / logA;
            }
            denom += dgI;
            ++r2;
        }
        return nom / denom;
    }

    public static double getNDCGPrime(Vector<URL> ranking, RelevanceSet relSet) {
        Vector<URL> condensedR = new Vector<URL>();
        for (URL offer : ranking) {
            if (!relSet.isGradedRelevant(offer) && !relSet.isGradedIrrelevant(offer)) continue;
            condensedR.add(offer);
        }
        return SingleQueryMeasures.getNDCG(condensedR, relSet);
    }
}

