/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.Map;
import org.mindswap.pellet.datatypes.RDFXMLLiteral;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;

public class JenaUtils {
    public static final Literal XSD_BOOLEAN_TRUE = ResourceFactory.createTypedLiteral((String)Boolean.TRUE.toString(), (RDFDatatype)XSDDatatype.XSDboolean);

    public static ATermAppl makeLiteral(LiteralLabel jenaLiteral) {
        String lexicalValue = jenaLiteral.getLexicalForm();
        String datatypeURI = jenaLiteral.getDatatypeURI();
        ATermAppl literalValue = null;
        literalValue = datatypeURI != null ? ATermUtils.makeTypedLiteral((String)lexicalValue, (String)datatypeURI) : (jenaLiteral.language() != null ? ATermUtils.makePlainLiteral((String)lexicalValue, (String)jenaLiteral.language()) : ATermUtils.makePlainLiteral((String)lexicalValue));
        return literalValue;
    }

    public static ATermAppl makeATerm(RDFNode node) {
        return JenaUtils.makeATerm(node.asNode());
    }

    public static ATermAppl makeATerm(Node node) {
        if (node.isLiteral()) {
            return JenaUtils.makeLiteral(node.getLiteral());
        }
        if (node.isBlank()) {
            return ATermUtils.makeBnode((String)node.getBlankNodeLabel());
        }
        if (node.isURI()) {
            if (node.equals((Object)OWL.Thing.asNode())) {
                return ATermUtils.TOP;
            }
            if (node.equals((Object)OWL.Nothing.asNode())) {
                return ATermUtils.BOTTOM;
            }
            if (node.equals((Object)OWL2.topDataProperty.asNode())) {
                return ATermUtils.TOP_DATA_PROPERTY;
            }
            if (node.equals((Object)OWL2.bottomDataProperty.asNode())) {
                return ATermUtils.BOTTOM_DATA_PROPERTY;
            }
            if (node.equals((Object)OWL2.topObjectProperty.asNode())) {
                return ATermUtils.TOP_OBJECT_PROPERTY;
            }
            if (node.equals((Object)OWL2.bottomObjectProperty.asNode())) {
                return ATermUtils.BOTTOM_OBJECT_PROPERTY;
            }
            return ATermUtils.makeTermAppl((String)node.getURI());
        }
        if (node.isVariable()) {
            return ATermUtils.makeVar((String)node.getName());
        }
        return null;
    }

    public static Node makeGraphLiteral(ATermAppl literal) {
        Node node;
        String lexicalValue = ((ATermAppl)literal.getArgument(0)).getName();
        String lang = ((ATermAppl)literal.getArgument(1)).getName();
        String datatypeURI = ((ATermAppl)literal.getArgument(2)).getName();
        if (!lang.equals("")) {
            node = Node.createLiteral((String)lexicalValue, (String)lang, (boolean)false);
        } else if (datatypeURI.equals("")) {
            node = Node.createLiteral((String)lexicalValue);
        } else if (datatypeURI.equals(RDFXMLLiteral.instance.getURI())) {
            node = Node.createLiteral((String)lexicalValue, (String)"", (boolean)true);
        } else {
            RDFDatatype datatype = TypeMapper.getInstance().getTypeByName(datatypeURI);
            node = Node.createLiteral((String)lexicalValue, (String)"", (RDFDatatype)datatype);
        }
        return node;
    }

    public static Node makeGraphResource(ATermAppl term) {
        if (ATermUtils.isBnode((ATermAppl)term)) {
            return Node.createAnon((AnonId)new AnonId(((ATermAppl)term.getArgument(0)).getName()));
        }
        if (term.equals(ATermUtils.TOP)) {
            return OWL.Thing.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM)) {
            return OWL.Nothing.asNode();
        }
        if (term.equals(ATermUtils.TOP_DATA_PROPERTY)) {
            return OWL2.topDataProperty.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM_DATA_PROPERTY)) {
            return OWL2.bottomDataProperty.asNode();
        }
        if (term.equals(ATermUtils.TOP_OBJECT_PROPERTY)) {
            return OWL2.topObjectProperty.asNode();
        }
        if (term.equals(ATermUtils.BOTTOM_OBJECT_PROPERTY)) {
            return OWL2.bottomObjectProperty.asNode();
        }
        if (term.getArity() == 0) {
            return Node.createURI((String)term.getName());
        }
        throw new InternalReasonerException("Invalid term found " + term);
    }

    public static Node makeGraphNode(ATermAppl value) {
        if (ATermUtils.isLiteral((ATermAppl)value)) {
            return JenaUtils.makeGraphLiteral(value);
        }
        return JenaUtils.makeGraphResource(value);
    }

    public static Literal makeLiteral(ATermAppl literal, Model model) {
        return (Literal)model.asRDFNode(JenaUtils.makeGraphLiteral(literal));
    }

    public static Resource makeResource(ATermAppl term, Model model) {
        return (Resource)model.asRDFNode(JenaUtils.makeGraphResource(term));
    }

    public static RDFNode makeRDFNode(ATermAppl term, Model model) {
        return model.asRDFNode(JenaUtils.makeGraphNode(term));
    }

    public static QNameProvider makeQNameProvider(PrefixMapping mapping) {
        QNameProvider qnames = new QNameProvider();
        for (Map.Entry entry : mapping.getNsPrefixMap().entrySet()) {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            qnames.setMapping(prefix, uri);
        }
        return qnames;
    }
}

