/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.example;

import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.io.StringWriter;
import uk.ac.man.cs.img.dig.example.Header;
import uk.ac.man.cs.img.dig.example.Hierarchy;
import uk.ac.man.cs.img.dig.example.graph.Graph;
import uk.ac.man.cs.img.dig.helper.Response;
import uk.ac.man.cs.img.dig.reasoner.ReasonerException;
import uk.ac.man.cs.img.dig.reasoner.impl.HTTPReasoner;

public class Comparer {
    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                System.out.println("Usage: Comparer url1 url2 kb");
                System.exit(0);
            }
            String url1 = args[0];
            String url2 = args[1];
            String kb = args[2];
            StringBuffer sb = null;
            Response serverResponse = null;
            HTTPReasoner reasoner1 = new HTTPReasoner(url1);
            sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append("<getIdentifier " + Header.namespaces + "/>");
            StringWriter sw = new StringWriter();
            StringReader sr = new StringReader(sb.toString());
            reasoner1.request(sr, sw);
            serverResponse = new Response(sw.toString());
            String name1 = serverResponse.extractIdentifier();
            HTTPReasoner reasoner2 = new HTTPReasoner(url2);
            sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append("<getIdentifier " + Header.namespaces + "/>");
            sw = new StringWriter();
            sr = new StringReader(sb.toString());
            reasoner2.request(sr, sw);
            serverResponse = new Response(sw.toString());
            String name2 = serverResponse.extractIdentifier();
            FileReader r = null;
            r = new FileReader(new File(kb));
            sw = new StringWriter();
            long start = System.currentTimeMillis();
            reasoner1.request(r, sw);
            long end = System.currentTimeMillis();
            System.out.println(name1);
            System.out.println("  Told: " + (end - start));
            Graph g1 = Hierarchy.buildGraph(reasoner1);
            r = new FileReader(new File(kb));
            sw = new StringWriter();
            start = System.currentTimeMillis();
            reasoner2.request(r, sw);
            end = System.currentTimeMillis();
            System.out.println(name2);
            System.out.println("  Told: " + (end - start));
            Graph g2 = Hierarchy.buildGraph(reasoner2);
            if (g1.equivalent(g2) && g2.equivalent(g1)) {
                System.out.println("Hierarchies agree");
            } else {
                System.out.println("!! Hierarchies disagree !!");
            }
        }
        catch (ReasonerException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

