/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.example;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import uk.ac.man.cs.img.dig.example.Header;
import uk.ac.man.cs.img.dig.helper.Response;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.reasoner.impl.HTTPReasoner;

public class Console
extends JFrame
implements ActionListener {
    private JTabbedPane reasoners;
    private JComboBox file;
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$dig$example$Console == null ? (class$uk$ac$man$cs$img$dig$example$Console = Console.class$("uk.ac.man.cs.img.dig.example.Console")) : class$uk$ac$man$cs$img$dig$example$Console));
    static /* synthetic */ Class class$uk$ac$man$cs$img$dig$example$Console;

    public Console() {
        this.setTitle("Dig Client");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic('f');
        JMenuItem item = new JMenuItem("Quit");
        item.addActionListener(this);
        item.setMnemonic('q');
        item.setAccelerator(KeyStroke.getKeyStroke("alt F4"));
        menu.add(item);
        menuBar.add(menu);
        JPanel panel = new JPanel(new BorderLayout());
        GridBagLayout gbl = new GridBagLayout();
        JPanel settings = new JPanel();
        settings.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 100.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        JLabel lab = new JLabel("file:");
        gbl.setConstraints(lab, gbc);
        settings.add(lab);
        gbc = new GridBagConstraints();
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.fill = 1;
        String[] files = new String[]{};
        this.file = new JComboBox<String>(files);
        this.file.setEditable(false);
        lab.setLabelFor(this.file);
        gbl.setConstraints(this.file, gbc);
        settings.add(this.file);
        JButton browse = new JButton("Browse...");
        browse.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 100.0;
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbl.setConstraints(browse, gbc);
        settings.add(browse);
        panel.add((Component)settings, "Center");
        JPanel buttons = new JPanel(new GridLayout(1, 4));
        JButton add = new JButton("Add");
        add.addActionListener(this);
        add.setBackground(Color.yellow);
        buttons.add(add);
        JButton remove = new JButton("Remove");
        remove.addActionListener(this);
        remove.setBackground(Color.blue);
        buttons.add(remove);
        JButton transmit = new JButton("Transmit");
        transmit.addActionListener(this);
        transmit.setBackground(Color.green);
        buttons.add(transmit);
        JButton quit = new JButton("Quit");
        quit.addActionListener(this);
        quit.setBackground(Color.red);
        buttons.add(quit);
        panel.add((Component)buttons, "North");
        container.add((Component)panel, "North");
        this.reasoners = new JTabbedPane();
        container.add((Component)this.reasoners, "Center");
    }

    public Dimension getPreferredSize() {
        return new Dimension(640, 480);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("Quit")) {
            System.exit(0);
        } else if (evt.getActionCommand().equals("Browse...")) {
            FileDialog fd = new FileDialog((Frame)this, "File");
            fd.show();
            File f = null;
            try {
                f = new File(fd.getDirectory(), fd.getFile());
                if (f != null) {
                    this.file.addItem(f);
                    this.file.setSelectedItem(f);
                }
            }
            catch (Exception ex) {}
        } else if (evt.getActionCommand().equals("Transmit")) {
            this.transmit();
        } else if (evt.getActionCommand().equals("Add")) {
            String url = (String)JOptionPane.showInputDialog(this, "URL", "Add Reasoner", 3, null, null, "http://localhost:8080");
            if (url != null && !url.equals("")) {
                try {
                    HTTPReasoner r = new HTTPReasoner(url);
                    ReasonerPanel rp = new ReasonerPanel(r);
                    this.reasoners.addTab(rp.label(), rp);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (evt.getActionCommand().equals("Remove")) {
            this.reasoners.removeTabAt(this.reasoners.getSelectedIndex());
        }
    }

    public void transmit() {
        File f = (File)this.file.getSelectedItem();
        int i = 0;
        while (i < this.reasoners.getTabCount()) {
            ReasonerPanel rp = (ReasonerPanel)this.reasoners.getComponentAt(i);
            rp.transmit(f);
            ++i;
        }
    }

    public static void main(String[] args) {
        PropertyConfigurator.configure((String)"log4j.properties");
        Console console = new Console();
        console.setSize(console.getPreferredSize());
        console.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        console.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReasonerPanel
    extends JPanel {
        Reasoner reasoner;
        private JTextArea response;

        ReasonerPanel(Reasoner r) {
            super(new BorderLayout(5, 5));
            this.reasoner = r;
            this.response = new JTextArea(20, 40);
            this.add(new JScrollPane(this.response));
        }

        public String label() {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                sb.append("<getIdentifier \n" + Header.namespaces + "/>");
                logger.debug((Object)sb.toString());
                StringWriter sw = new StringWriter();
                StringReader sr = new StringReader(sb.toString());
                this.reasoner.request(sr, sw);
                Response serverResponse = new Response(sw.toString());
                return serverResponse.extractIdentifier();
            }
            catch (Exception ex) {
                return "XXX";
            }
        }

        public void transmit(File f) {
            try {
                this.response.setText("");
                FileReader r = new FileReader(f);
                StringWriter sw = new StringWriter();
                this.reasoner.request(r, sw);
                this.response.setText(sw.toString());
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                this.response.setText(sw.toString());
            }
        }
    }
}

