/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.example;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import uk.ac.man.cs.img.dig.example.Header;
import uk.ac.man.cs.img.dig.example.graph.Graph;
import uk.ac.man.cs.img.dig.helper.Response;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.reasoner.ReasonerException;
import uk.ac.man.cs.img.dig.reasoner.impl.HTTPReasoner;

public class Hierarchy {
    public static void main(String[] args) {
        try {
            String url = "";
            String kb = null;
            String hier = "";
            if (args.length == 3) {
                url = args[0];
                kb = args[1];
                hier = args[2];
            } else if (args.length == 2) {
                url = args[0];
                hier = args[1];
            } else {
                System.out.println("usage: Hierarchy url [kb] dot-file");
            }
            HTTPReasoner reasoner = new HTTPReasoner(url);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append("<getIdentifier " + Header.namespaces + "/>");
            StringWriter sw = new StringWriter();
            StringReader sr = new StringReader(sb.toString());
            reasoner.request(sr, sw);
            Response serverResponse = new Response(sw.toString());
            System.out.println(serverResponse.extractIdentifier());
            if (kb != null) {
                FileReader r = new FileReader(new File(kb));
                sw = new StringWriter();
                reasoner.request(r, sw);
            }
            Graph g = Hierarchy.buildGraph(reasoner);
            PrintWriter pw = new PrintWriter(new FileOutputStream(hier), true);
            g.render(pw);
        }
        catch (ReasonerException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Graph buildGraph(Reasoner reasoner) throws ReasonerException {
        boolean individuals = true;
        ArrayList<Object> allNames = new ArrayList<Object>();
        Graph g = new Graph();
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<asks " + Header.namespaces + ">");
        sb.append("<allConceptNames id=\"q1\"/>");
        sb.append("</asks>");
        StringReader sr = new StringReader(sb.toString());
        StringWriter sw = new StringWriter();
        long start = System.currentTimeMillis();
        reasoner.request(sr, sw);
        long end = System.currentTimeMillis();
        System.out.println("  All Concepts: " + (end - start));
        Response serverResponse = new Response(sw.toString());
        Element r = serverResponse.extractResponse("q1");
        List l = serverResponse.extractSynonymSets(r);
        int i = 0;
        while (i < l.size()) {
            List l2 = (List)l.get(i);
            int j = 0;
            while (j < l2.size()) {
                Response.Concept name = (Response.Concept)l2.get(j);
                allNames.add(name);
                g.addNode(name.toString());
                ++j;
            }
            ++i;
        }
        sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<asks " + Header.namespaces + ">");
        int i2 = 0;
        while (i2 < allNames.size()) {
            Response.Concept c = (Response.Concept)allNames.get(i2);
            sb.append("<children id=\"c" + i2 + "\">");
            sb.append(c.getXML());
            sb.append("</children>");
            sb.append("<equivalents id=\"e" + i2 + "\">");
            sb.append(c.getXML());
            sb.append("</equivalents>");
            ++i2;
        }
        sb.append("</asks>");
        sr = new StringReader(sb.toString());
        sw = new StringWriter();
        start = System.currentTimeMillis();
        reasoner.request(sr, sw);
        end = System.currentTimeMillis();
        System.out.println("  Children and Equivalences: " + (end - start));
        serverResponse = new Response(sw.toString());
        int i3 = 0;
        while (i3 < allNames.size()) {
            r = serverResponse.extractResponse("c" + i3);
            l = serverResponse.extractSynonymSets(r);
            int j = 0;
            while (j < l.size()) {
                List l2 = (List)l.get(j);
                int k = 0;
                while (k < l2.size()) {
                    Response.Concept kid = (Response.Concept)l2.get(k);
                    g.addEdge(((Response.Concept)allNames.get(i3)).toString(), kid.toString());
                    ++k;
                }
                ++j;
            }
            r = serverResponse.extractResponse("e" + i3);
            l = serverResponse.extractSynonymSets(r);
            int j2 = 0;
            while (j2 < l.size()) {
                List l2 = (List)l.get(j2);
                Response.Concept eq1 = (Response.Concept)l2.get(0);
                int k = 1;
                while (k < l2.size()) {
                    Response.Concept eq2 = (Response.Concept)l2.get(k);
                    g.mergeNodes(eq1.toString(), eq2.toString());
                    ++k;
                }
                ++j2;
            }
            ++i3;
        }
        if (individuals) {
            sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append("<asks " + Header.namespaces + ">");
            sb.append("<allIndividuals id=\"q1\"/>");
            sb.append("</asks>");
            sr = new StringReader(sb.toString());
            sw = new StringWriter();
            reasoner.request(sr, sw);
            serverResponse = new Response(sw.toString());
            r = serverResponse.extractResponse("q1");
            allNames = new ArrayList();
            l = serverResponse.extractIndividuals(r);
            int i4 = 0;
            while (i4 < l.size()) {
                String name = (String)l.get(i4);
                allNames.add(name);
                g.addNode(name, true);
                ++i4;
            }
            sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append("<asks " + Header.namespaces + ">");
            int i5 = 0;
            while (i5 < allNames.size()) {
                String c = (String)allNames.get(i5);
                sb.append("<types id=\"t" + i5 + "\">");
                sb.append("<individual name=\"" + c + "\"/>");
                sb.append("</types>");
                ++i5;
            }
            sb.append("</asks>");
            sr = new StringReader(sb.toString());
            sw = new StringWriter();
            reasoner.request(sr, sw);
            serverResponse = new Response(sw.toString());
            int i6 = 0;
            while (i6 < allNames.size()) {
                String ind = (String)allNames.get(i6);
                r = serverResponse.extractResponse("t" + i6);
                l = serverResponse.extractSynonymSets(r);
                int j = 0;
                while (j < l.size()) {
                    List l2 = (List)l.get(j);
                    int k = 0;
                    while (k < l2.size()) {
                        Response.Concept typeName = (Response.Concept)l2.get(k);
                        g.addEdge(typeName.toString(), ind);
                        ++k;
                    }
                    ++j;
                }
                ++i6;
            }
        }
        return g;
    }
}

