/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.example;

import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import uk.ac.man.cs.img.dig.example.Header;
import uk.ac.man.cs.img.dig.helper.Response;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.reasoner.impl.HTTPReasoner;

public class Tester {
    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                System.out.println("Usage: Tester url [test1 test2 ... testn]");
                System.exit(0);
            }
            String url = args[0];
            StringBuffer sb = null;
            Response serverResponse = null;
            HTTPReasoner reasoner = new HTTPReasoner(url);
            sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            sb.append("<getIdentifier " + Header.namespaces + "/>");
            StringWriter sw = new StringWriter();
            StringReader sr = new StringReader(sb.toString());
            reasoner.request(sr, sw);
            serverResponse = new Response(sw.toString());
            String name = serverResponse.extractIdentifier();
            Tester.log(name);
            Tester.log();
            boolean passed = true;
            int i = 1;
            while (i < args.length) {
                try {
                    URL testUrl = new URL(args[i] + "/");
                    boolean testPassed = Tester.runTest(reasoner, testUrl);
                    passed = passed && testPassed;
                }
                catch (MalformedURLException ex) {
                    Tester.log(ex.getMessage());
                }
                ++i;
            }
            if (passed) {
                Tester.log("ALL TESTS PASSED!!");
                Tester.log();
            } else {
                Tester.log("TESTS FAILED!!");
                Tester.log();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void log(String str) {
        System.out.print(str);
    }

    private static void log() {
        System.out.println();
    }

    private static boolean runTest(Reasoner reasoner, URL testURL) throws Exception {
        try {
            Object sb = null;
            StringWriter sw = null;
            Response serverResponse = null;
            boolean passed = true;
            InputStreamReader r = null;
            Tester.log("Running Test: " + testURL);
            Tester.log();
            URL url = new URL(testURL, "kb.xml");
            r = new InputStreamReader(url.openStream());
            sw = new StringWriter();
            Tester.log("  Loading KB...");
            long start = System.currentTimeMillis();
            reasoner.request(r, sw);
            long end = System.currentTimeMillis();
            Tester.log("...Time: " + (end - start));
            Tester.log();
            Tester.log("  --");
            Tester.log();
            url = new URL(testURL, "queries.xml");
            r = new InputStreamReader(url.openStream());
            sw = new StringWriter();
            start = System.currentTimeMillis();
            reasoner.request(r, sw);
            end = System.currentTimeMillis();
            serverResponse = new Response(sw.toString());
            Set ids = serverResponse.getIds();
            if (ids.size() > 0) {
                Tester.log("  " + ids.size() + " queries");
                Tester.log();
                Iterator it = ids.iterator();
                while (it.hasNext()) {
                    String id = (String)it.next();
                    String expected = "";
                    if (id.startsWith("true")) {
                        expected = "true";
                    } else if (id.startsWith("false")) {
                        expected = "false";
                    }
                    Element el = serverResponse.extractResponse(id);
                    if (el.getTagName().equals(expected)) {
                        Tester.log("  " + id + " passed");
                        Tester.log();
                        continue;
                    }
                    Tester.log("  " + id + " FAILED");
                    Tester.log();
                    passed = false;
                }
            }
            Tester.log("  Time: " + (end - start));
            Tester.log();
            return passed;
        }
        catch (MalformedURLException ex) {
            Tester.log(ex.getMessage());
            return false;
        }
    }
}

