/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.example.graph;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import uk.ac.man.cs.img.dig.example.graph.Node;

public class Graph {
    private Map nodeMap = new HashMap();

    public Node addNode(String s) {
        Node n = new Node();
        n.addName(s);
        this.nodeMap.put(s, n);
        return n;
    }

    public Node addNode(String s, boolean individual) {
        Node n = new Node();
        n.individual = individual;
        n.addName(s);
        this.nodeMap.put(s, n);
        return n;
    }

    public void mergeNodes(String s, String t) {
        Node nt;
        Node ns = this.getNode(s);
        if (ns != (nt = this.getNode(t))) {
            ns.merge(nt);
            int i = 0;
            while (i < nt.names.size()) {
                this.nodeMap.put(nt.names.get(i), ns);
                ++i;
            }
            Iterator it = this.allNodes();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                n.removeChild(nt);
            }
        }
    }

    public void addEdge(String s, String t) {
        Node ns = this.getNode(s);
        Node nt = this.getNode(t);
        ns.addChild(nt);
    }

    private Node getNode(String s) {
        try {
            Object o = this.nodeMap.get(s);
            if (o != null) {
                return (Node)o;
            }
            return this.addNode(s);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private Iterator allNodes() {
        HashSet hs = new HashSet(this.nodeMap.values());
        return hs.iterator();
    }

    public boolean equivalent(Graph g) {
        Iterator it = this.allNodes();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            boolean found = false;
            Iterator git = g.allNodes();
            while (!found && git.hasNext()) {
                Node m = (Node)git.next();
                boolean bl = found = n.sameNames(m) && n.sameChildren(m);
            }
            if (found) continue;
            System.out.println("Bad node: " + n);
            return false;
        }
        return true;
    }

    public void render(PrintWriter pw) {
        pw.println("digraph generated {");
        pw.println("ratio=fill;");
        pw.println("  ranksep=1.5;");
        pw.println("  node [style=filled];");
        pw.println("");
        Iterator it = this.allNodes();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            String colour = "yellow";
            String shape = "ellipse";
            if (n.hasName("BOTTOM")) {
                colour = "red";
            } else if (n.individual) {
                colour = "green";
                shape = "box";
            }
            pw.println("    \"" + n.label() + "\"[color=" + colour + ",shape=" + shape + ",fontcolor=black];");
            int j = 0;
            while (j < n.children.size()) {
                Node childNode = (Node)n.children.get(j);
                pw.println("    \"" + n.label() + "\"->{ \"" + childNode.label() + "\" }");
                ++j;
            }
        }
        pw.println("}");
    }
}

