/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.helper;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Response {
    Document doc;
    Map map;

    public Response(String str) {
        this.doc = Response.parse(str);
        if (this.doc != null) {
            this.map = new HashMap();
            Element responses = this.doc.getDocumentElement();
            if (responses.getTagName().equals("responses")) {
                NodeList nl = responses.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node nod = nl.item(i);
                    if (nod.getNodeType() != 3) {
                        Element enod = (Element)nod;
                        this.map.put(enod.getAttribute("id"), enod);
                    }
                    ++i;
                }
            }
        }
    }

    private static Document parse(String in) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            InputSource input = new InputSource(new StringReader(in));
            Document doc = builder.parse(input);
            return doc;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public String extractIdentifier() {
        if (this.doc != null) {
            Element id = this.doc.getDocumentElement();
            if (!id.getTagName().equals("identifier")) {
                return "Unknown Reasoner!";
            }
            return id.getAttribute("name") + " " + id.getAttribute("version");
        }
        return "Unknown Reasoner!";
    }

    public String[] extractLanguage() {
        ArrayList<String> l = new ArrayList<String>();
        try {
            Element id;
            if (this.doc != null && (id = this.doc.getDocumentElement()).getTagName().equals("identifier")) {
                Element support = (Element)id.getElementsByTagName("supports").item(0);
                Element language = (Element)support.getElementsByTagName("language").item(0);
                NodeList nl = language.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node nod = nl.item(i);
                    if (nod.getNodeType() != 3) {
                        Element enod = (Element)nod;
                        l.add(enod.getTagName());
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l.toArray(new String[l.size()]);
    }

    public String[] extractTellLanguage() {
        ArrayList<String> l = new ArrayList<String>();
        try {
            Element id;
            if (this.doc != null && (id = this.doc.getDocumentElement()).getTagName().equals("identifier")) {
                Element support = (Element)id.getElementsByTagName("supports").item(0);
                Element language = (Element)support.getElementsByTagName("tell").item(0);
                NodeList nl = language.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node nod = nl.item(i);
                    if (nod.getNodeType() != 3) {
                        Element enod = (Element)nod;
                        l.add(enod.getTagName());
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l.toArray(new String[l.size()]);
    }

    public String[] extractAskLanguage() {
        ArrayList<String> l = new ArrayList<String>();
        try {
            Element id;
            if (this.doc != null && (id = this.doc.getDocumentElement()).getTagName().equals("identifier")) {
                Element support = (Element)id.getElementsByTagName("supports").item(0);
                Element language = (Element)support.getElementsByTagName("ask").item(0);
                NodeList nl = language.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node nod = nl.item(i);
                    if (nod.getNodeType() != 3) {
                        Element enod = (Element)nod;
                        l.add(enod.getTagName());
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l.toArray(new String[l.size()]);
    }

    public Element extractResponse(String id) {
        if (this.doc != null) {
            try {
                Element e = (Element)this.map.get(id);
                return e;
            }
            catch (ClassCastException ex) {
                return null;
            }
        }
        return null;
    }

    public Set getIds() {
        return this.map.keySet();
    }

    public List extractSynonymSets(Element response) {
        ArrayList<List> l = new ArrayList<List>();
        NodeList nl = response.getElementsByTagName("synonyms");
        int i = 0;
        while (i < nl.getLength()) {
            Element enod = (Element)nl.item(i);
            if (enod.getTagName().equals("synonyms")) {
                l.add(this.extractNames(enod));
            }
            ++i;
        }
        return l;
    }

    public List extractNames(Element synonyms) {
        ArrayList<Concept> l = new ArrayList<Concept>();
        NodeList nl = synonyms.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node nod = nl.item(i);
            if (nod.getNodeType() != 3) {
                Element enod = (Element)nod;
                if (enod.getTagName().equals("catom")) {
                    l.add(new ConceptName(enod.getAttribute("name")));
                } else if (enod.getTagName().equals("top")) {
                    l.add(new TopName());
                } else if (enod.getTagName().equals("bottom")) {
                    l.add(new BottomName());
                }
            }
            ++i;
        }
        return l;
    }

    public List extractIndividuals(Element response) {
        ArrayList<String> l = new ArrayList<String>();
        NodeList nl = response.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element enod;
            Node nod = nl.item(i);
            if (nod.getNodeType() != 3 && (enod = (Element)nod).getTagName().equals("individual")) {
                l.add(enod.getAttribute("name"));
            }
            ++i;
        }
        return l;
    }

    public class BottomName
    extends Concept {
        public String toString() {
            return "BOTTOM";
        }

        public boolean equals(Concept c) {
            return c instanceof BottomName;
        }

        public boolean isBottom() {
            return true;
        }

        public String getXML() {
            return "<bottom/>";
        }
    }

    public class TopName
    extends Concept {
        public String toString() {
            return "TOP";
        }

        public boolean equals(Concept c) {
            return c instanceof TopName;
        }

        public boolean isTop() {
            return true;
        }

        public String getXML() {
            return "<top/>";
        }
    }

    public class ConceptName
    extends Concept {
        protected String n;

        ConceptName(String n) {
            this.n = n;
        }

        public String toString() {
            return this.n;
        }

        public boolean equals(Concept c) {
            return c instanceof ConceptName && this.n.equals(((ConceptName)c).n);
        }

        public String getXML() {
            return "<catom name=\"" + this.n + "\"/>";
        }
    }

    public abstract class Concept {
        public abstract boolean equals(Concept var1);

        public boolean isTop() {
            return false;
        }

        public boolean isBottom() {
            return false;
        }

        public abstract String getXML();
    }
}

