/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.reasoner.ReasonerException;
import uk.ac.man.cs.img.dig.reasoner.impl.FaCTReasoner;
import uk.ac.man.cs.img.dig.reasoner.impl.JLinkerWrapper;

public class DIGServlet
extends HttpServlet {
    public static Reasoner reasoner;
    static Logger logger;
    static /* synthetic */ Class class$uk$ac$man$cs$img$dig$http$DIGServlet;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        BasicConfigurator.configure();
        logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$dig$http$DIGServlet == null ? (class$uk$ac$man$cs$img$dig$http$DIGServlet = DIGServlet.class$("uk.ac.man.cs.img.dig.http.DIGServlet")) : class$uk$ac$man$cs$img$dig$http$DIGServlet));
        if (reasoner == null) {
            try {
                logger.info((Object)"Creating Reasoner");
                String shiqApp = sc.getInitParameter("dig.shiqapp");
                if (shiqApp != null && !shiqApp.equals("")) {
                    System.setProperty("dig.shiqapp", shiqApp);
                }
                logger.info((Object)("SHIQ: " + shiqApp));
                JLinkerWrapper li = new JLinkerWrapper();
                if (!JLinkerWrapper.connected) {
                    throw new ServletException("Not Connected!");
                }
                reasoner = new FaCTReasoner(li);
            }
            catch (ReasonerException ex) {
                this.log("ERROR: " + ex.getMessage());
                ex.printStackTrace();
                throw new UnavailableException((Servlet)this, ex.getMessage());
            }
        }
    }

    public void destroy() {
        logger.info((Object)"Destroying");
        reasoner.release();
        super.destroy();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/xml");
        logger.info((Object)"POST!");
        PrintWriter writer = response.getWriter();
        InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream());
        this.handle(reader, writer);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/xml");
        logger.info((Object)"GET!");
        PrintWriter writer = response.getWriter();
        writer.println("<?xml version=\"1.0\" ?>");
        writer.println("<!DOCTYPE html ");
        writer.println("PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        writer.println("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<title>DIG</title>");
        writer.println("</head>");
        writer.println("");
        writer.println("<body style=\"font-family:arial\">");
        writer.println("<h1>DIG</h1>");
        writer.println("<p>You are trying to connect to a DIG reasoner using GET.</p>");
        writer.println("<p>The reasoner is here, but you must use POST to submit requests.</p>");
        writer.println("</body>");
        writer.println("</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(Reader reader, PrintWriter writer) {
        if (reader != null) {
            try {
                long s = System.currentTimeMillis();
                Reasoner reasoner = DIGServlet.reasoner;
                synchronized (reasoner) {
                    DIGServlet.reasoner.request(reader, writer);
                }
                long t = System.currentTimeMillis();
                logger.info((Object)("Request handled: " + (t - s)));
            }
            catch (ReasonerException ex) {
                writer.println("<error message=\"" + ex.getMessage() + "\" code=\"" + ex.getCode() + "\">" + ex.getLongMessage() + "</error>");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

