/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.reasoner.impl;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.man.cs.img.dig.reasoner.impl.ConversionException;
import uk.ac.man.cs.img.dig.reasoner.impl.Names;
import uk.ac.man.cs.img.dig.reasoner.impl.UnsupportedOperatorException;
import uk.ac.man.cs.img.dig.reasoner.impl.Util;

public class Concept {
    private Names names;

    public Concept(Names names) {
        this.names = names;
    }

    public String convert(Node n) throws UnsupportedOperatorException, ConversionException {
        String name = n.getNodeName();
        try {
            if (name.equals("catom")) {
                Element e = (Element)n;
                return this.names.toFaCT(e.getAttribute("name"));
            }
            if (name.equals("ratom")) {
                Element e = (Element)n;
                return this.names.toFaCT(e.getAttribute("name"));
            }
            if (name.equals("feature")) {
                Element e = (Element)n;
                return this.names.toFaCT(e.getAttribute("name"));
            }
            if (name.equals("attribute")) {
                Element e = (Element)n;
                return this.names.toFaCT(e.getAttribute("name"));
            }
            if (name.equals("individual")) {
                Element e = (Element)n;
                return this.names.toFaCTIndividual(e.getAttribute("name"));
            }
            if (name.equals("top")) {
                return ":TOP";
            }
            if (name.equals("bottom")) {
                return ":BOTTOM";
            }
            if (name.equals("and")) {
                String result = "(and";
                Node[] children = Util.getNonTextChildNodes(n);
                int i = 0;
                while (i < children.length) {
                    result = result + " " + this.convert(children[i]);
                    ++i;
                }
                result = result + ")";
                return result;
            }
            if (name.equals("or")) {
                String result = "(or";
                Node[] children = Util.getNonTextChildNodes(n);
                int i = 0;
                while (i < children.length) {
                    result = result + " " + this.convert(children[i]);
                    ++i;
                }
                result = result + ")";
                return result;
            }
            if (name.equals("not")) {
                String result = "(not";
                Node[] children = Util.getNonTextChildNodes(n);
                result = result + " " + this.convert(children[0]);
                result = result + ")";
                return result;
            }
            if (name.equals("some")) {
                String result = "(some";
                Node[] children = Util.getNonTextChildNodes(n);
                result = result + " " + this.convert(children[0]);
                result = result + " " + this.convert(children[1]);
                result = result + ")";
                return result;
            }
            if (name.equals("all")) {
                String result = "(all";
                Node[] children = Util.getNonTextChildNodes(n);
                result = result + " " + this.convert(children[0]);
                result = result + " " + this.convert(children[1]);
                result = result + ")";
                return result;
            }
            if (name.equals("atmost")) {
                String result = "(atmost";
                Node[] children = Util.getNonTextChildNodes(n);
                Element e = (Element)n;
                Attr num = e.getAttributeNode("num");
                result = result + " " + num.getValue();
                result = result + " " + this.convert(children[0]);
                result = result + " " + this.convert(children[1]);
                result = result + ")";
                return result;
            }
            if (name.equals("atleast")) {
                String result = "(atleast";
                Node[] children = Util.getNonTextChildNodes(n);
                Element e = (Element)n;
                Attr num = e.getAttributeNode("num");
                result = result + " " + num.getValue();
                result = result + " " + this.convert(children[0]);
                result = result + " " + this.convert(children[1]);
                result = result + ")";
                return result;
            }
            if (name.equals("iset")) {
                String result = "(or ";
                Node[] children = Util.getNonTextChildNodes(n);
                int c = 0;
                while (c < children.length) {
                    result = result + " " + this.convert(children[c]);
                    ++c;
                }
                result = result + ")";
                return result;
            }
            if (name.equals("inverse")) {
                String result = "(inv";
                Node[] children = Util.getNonTextChildNodes(n);
                result = result + " " + this.convert(children[0]);
                result = result + ")";
                return result;
            }
            System.out.println("Tag is: " + name);
            throw new UnsupportedOperatorException(name);
        }
        catch (UnsupportedOperatorException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ConversionException("Unexpected exception from Concept: " + e.getMessage());
        }
    }
}

