/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.reasoner.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.reasoner.ReasonerException;
import uk.ac.man.cs.img.dig.reasoner.impl.Ask;
import uk.ac.man.cs.img.dig.reasoner.impl.AskException;
import uk.ac.man.cs.img.dig.reasoner.impl.LispInterpreter;
import uk.ac.man.cs.img.dig.reasoner.impl.Names;
import uk.ac.man.cs.img.dig.reasoner.impl.Tell;
import uk.ac.man.cs.img.dig.reasoner.impl.TellException;
import uk.ac.man.cs.img.dig.reasoner.impl.UnsupportedOperatorException;
import uk.ac.man.cs.img.dig.reasoner.impl.UnsupportedTellException;

public class FaCTReasoner
implements Reasoner {
    private LispInterpreter lispInterpreter;
    private Names names;
    private Tell tell;
    private Ask ask;
    private DocumentBuilder builder;
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$dig$reasoner$impl$FaCTReasoner == null ? (class$uk$ac$man$cs$img$dig$reasoner$impl$FaCTReasoner = FaCTReasoner.class$("uk.ac.man.cs.img.dig.reasoner.impl.FaCTReasoner")) : class$uk$ac$man$cs$img$dig$reasoner$impl$FaCTReasoner));
    static /* synthetic */ Class class$uk$ac$man$cs$img$dig$reasoner$impl$FaCTReasoner;

    public FaCTReasoner(LispInterpreter li) throws ReasonerException {
        this.lispInterpreter = li;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            this.builder = dbf.newDocumentBuilder();
        }
        catch (Throwable t) {
            throw new ReasonerException(t.getMessage(), 6001, "Exception when creating Reasoner");
        }
        this.names = new Names();
        this.tell = new Tell(this.names, this.lispInterpreter);
        this.tell.setStrict(false);
        this.ask = new Ask(this.names, this.lispInterpreter);
    }

    public void release() {
        this.lispInterpreter.release();
    }

    private void tell(Document tellDoc, Writer writer) throws ReasonerException {
        block9: {
            StringWriter warnings = new StringWriter();
            try {
                Element e = tellDoc.getDocumentElement();
                if (!e.getTagName().equals("tells")) {
                    writer.write(this.errorMessage("No Tells", 2000, ""));
                    break block9;
                }
                NodeList tells = e.getChildNodes();
                int i = 0;
                while (i < tells.getLength()) {
                    try {
                        Node n = tells.item(i);
                        if (this.okNode(n)) {
                            this.tell.handle((Element)n, warnings);
                        }
                    }
                    catch (TellException ex) {
                        logger.warn((Object)ex.getMessage());
                        this.error("Tell Error", 3000, ex.getMessage());
                    }
                    catch (UnsupportedTellException ex) {
                        logger.warn((Object)ex.getMessage());
                        this.error("Tell Error", 1000, ex.getMessage());
                    }
                    catch (UnsupportedOperatorException ex) {
                        logger.warn((Object)ex.getMessage());
                        this.error("Tell Error", 1002, ex.getMessage());
                    }
                    ++i;
                }
                String r = this.lispInterpreter.eval("(fact::classify-tkb)");
                writer.write("<?xml version=\"1.0\"?>\n<response>\n <ok>\n" + warnings.toString() + " </ok>\n</response>");
            }
            catch (IOException ex) {
                throw new ReasonerException(ex.getMessage());
            }
        }
    }

    public void request(Reader reader, Writer writer) throws ReasonerException {
        long start = System.currentTimeMillis();
        Document doc = this.parse(reader);
        this.request(doc, writer);
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("request: " + (end - start)));
        }
    }

    public String request(String request) throws ReasonerException {
        StringReader reader = new StringReader(request);
        StringWriter writer = new StringWriter();
        Document doc = this.parse(reader);
        this.request(doc, (Writer)writer);
        return writer.toString();
    }

    private void ask(Document askDoc, Writer writer) throws ReasonerException {
        block7: {
            try {
                Element e = askDoc.getDocumentElement();
                if (!e.getTagName().equals("asks")) {
                    writer.write(this.errorMessage("No Asks", 2001, ""));
                    break block7;
                }
                NodeList asks = e.getChildNodes();
                writer.write("<?xml version=\"1.0\"?>\n <responses>");
                int i = 0;
                while (i < asks.getLength()) {
                    try {
                        Node n = asks.item(i);
                        if (this.okNode(n)) {
                            Element query = (Element)n;
                            writer.write(this.ask.handle(query));
                        }
                    }
                    catch (AskException ex) {
                        logger.warn((Object)ex.getMessage());
                        this.error("Ask Error", 3001, ex.getMessage());
                    }
                    ++i;
                }
                writer.write("\n</responses>");
            }
            catch (IOException ex) {
                throw new ReasonerException(ex.getMessage());
            }
        }
    }

    private void request(Document opDoc, Writer writer) throws ReasonerException {
        Element e = opDoc.getDocumentElement();
        if (e.getTagName().equals("asks")) {
            this.ask(opDoc, writer);
        } else if (e.getTagName().equals("tells")) {
            this.tell(opDoc, writer);
        } else if (e.getTagName().equals("getIdentifier")) {
            this.identifier(writer);
        } else {
            try {
                writer.write(this.errorMessage("Unknown Request", 4000, ""));
            }
            catch (IOException ex) {
                throw new ReasonerException(ex.getMessage());
            }
        }
    }

    private String identifier() {
        StringWriter sw = new StringWriter();
        String v = this.lispInterpreter.eval("(format nil \"~A.~A\" FACT::*version-number* FACT::*reasoner-version-number*)");
        if (v.length() > 6) {
            v = v.substring(3, v.length() - 3);
        }
        sw.write("<?xml version=\"1.0\"?>\n");
        sw.write("<identifier name=\"FaCT\" version=\"" + v + "\">\n");
        sw.write("<supports>");
        sw.write("<language>");
        sw.write("<and/>");
        sw.write("<or/>");
        sw.write("<not/>");
        sw.write("<some/>");
        sw.write("<all/>");
        sw.write("<atmost/>");
        sw.write("<atleast/>");
        sw.write("<iset/>");
        sw.write("<individual/>");
        sw.write("<feature/>");
        sw.write("<inverse/>");
        sw.write("</language>");
        sw.write("<tell>");
        sw.write("<impliesc/>");
        sw.write("<impliesr/>");
        sw.write("<equalc/>");
        sw.write("<equalr/>");
        sw.write("<domain/>");
        sw.write("<range/>");
        sw.write("<transitive/>");
        sw.write("<functional/>");
        sw.write("<disjoint/>");
        sw.write("<instanceof/>");
        sw.write("<related/>");
        sw.write("</tell>");
        sw.write("<ask>");
        sw.write("<allConceptNames/>");
        sw.write("<allRoleNames/>");
        sw.write("<allIndividuals/>");
        sw.write("<satisfiable/>");
        sw.write("<subsumes/>");
        sw.write("<disjoint/>");
        sw.write("<children/>");
        sw.write("<equivalents/>");
        sw.write("<instances/>");
        sw.write("<types/>");
        sw.write("<roleFillers/>");
        sw.write("<relatedIndividual/>");
        sw.write("</ask>");
        sw.write("</supports>");
        sw.write("</identifier>\n");
        return sw.toString();
    }

    private void identifier(Writer writer) throws ReasonerException {
        try {
            writer.write(this.identifier());
        }
        catch (IOException ex) {
            throw new ReasonerException(ex.getMessage());
        }
    }

    private Document parse(Reader r) throws ReasonerException {
        try {
            InputSource input = new InputSource(r);
            Document doc = this.builder.parse(input);
            return doc;
        }
        catch (Exception err) {
            String msg = "** Parsing error\n   " + err.getMessage();
            throw new ReasonerException(msg);
        }
        catch (Throwable t) {
            throw new ReasonerException(t.getMessage());
        }
    }

    private boolean okNode(Node n) {
        return n.getNodeType() != 3 && n.getNodeType() != 8;
    }

    private void error(String message, int code, String longMessage) throws ReasonerException {
        throw new ReasonerException(message, code, longMessage);
    }

    private String errorMessage(String message, int code, String longMessage) {
        return "<?xml version=\"1.0\"?><response><error message=\"" + message + "\" code=\"" + code + "\">" + longMessage + "</error></response>";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

