/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.reasoner.impl;

import com.franz.jlinker.JavaLinkDist;
import com.franz.jlinker.TranStruct;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import uk.ac.man.cs.img.dig.reasoner.impl.LispInterpreter;

public class JLinkerWrapper
implements LispInterpreter {
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$dig$reasoner$impl$JLinkerWrapper == null ? (class$uk$ac$man$cs$img$dig$reasoner$impl$JLinkerWrapper = JLinkerWrapper.class$("uk.ac.man.cs.img.dig.reasoner.impl.JLinkerWrapper")) : class$uk$ac$man$cs$img$dig$reasoner$impl$JLinkerWrapper));
    static Object lock = new Object();
    public static boolean connected = false;
    static int cons = 0;
    int port = 4321;
    int call = 0;
    Process lisp;
    static /* synthetic */ Class class$uk$ac$man$cs$img$dig$reasoner$impl$JLinkerWrapper;

    public JLinkerWrapper(int p) {
        this.port = p;
        this.initialise();
    }

    public JLinkerWrapper() {
        String p = System.getProperty("dig.shiqport");
        if (p != null) {
            try {
                this.port = Integer.parseInt(p);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() {
        if (this.fireUpLisp()) {
            Object object = lock;
            synchronized (object) {
                ++cons;
            }
            String[] err = new String[]{"unknown reason"};
            String localHost = "";
            try {
                localHost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            logger.info((Object)("Connecting: " + localHost + " -> " + localHost));
            JavaLinkDist.connect((String)localHost, (int)this.port, (String)localHost, (int)0, (int)1000, (int)300);
            if (JavaLinkDist.query()) {
                connected = true;
                logger.info((Object)"Connected");
            } else {
                connected = false;
                logger.info((Object)("Failed to connect to Lisp: " + err[0]));
            }
        } else {
            connected = false;
            logger.info((Object)"Failed to start Lisp");
        }
    }

    private boolean fireUpLisp() {
        try {
            if (!JavaLinkDist.query()) {
                String[] cmd = null;
                String shiqapp = System.getProperty("dig.shiqapp");
                if (shiqapp == null) {
                    shiqapp = "shiq-app/shiq-app.exe";
                }
                Object shiqAppPath = null;
                File shiqAppFile = new File(shiqapp);
                logger.info((Object)"Locating SHIQ");
                logger.info((Object)("Trying: " + shiqapp));
                if (shiqAppFile.exists()) {
                    logger.info((Object)"Found!");
                    cmd = new String[]{shiqAppFile.getAbsolutePath(), "--", "-jlinker", Integer.toString(this.port)};
                } else {
                    logger.info((Object)("Can't find " + shiqapp));
                    logger.info((Object)"Trying relative path...");
                    ClassLoader loader = this.getClass().getClassLoader();
                    URL url = loader.getResource(shiqapp);
                    if (url != null && url.getFile() != null) {
                        logger.info((Object)"Found!");
                        File f = new File(url.getFile());
                        cmd = new String[]{f.getAbsolutePath(), "--", "-jlinker", Integer.toString(this.port)};
                    }
                }
                if (cmd != null) {
                    if (System.getProperty("os.name").equals("Linux")) {
                        logger.info((Object)"Trying to change permissions...");
                        String[] chmod = new String[]{"chmod", "+x", cmd[0]};
                        Process cp = Runtime.getRuntime().exec(chmod);
                        try {
                            cp.waitFor();
                        }
                        catch (InterruptedException ex) {
                            logger.debug((Object)"Chmod on executable interrupted!");
                            return false;
                        }
                        logger.info((Object)"Permissions changed...");
                    }
                    logger.info((Object)("Starting: " + cmd[0]));
                    this.lisp = Runtime.getRuntime().exec(cmd);
                } else {
                    logger.info((Object)"Couldn't find SHIQ");
                    return false;
                }
            }
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            connected = false;
            return false;
        }
    }

    public void release() {
        JavaLinkDist.disconnect();
        this.lisp.destroy();
    }

    public String eval(String exp) {
        long start = System.currentTimeMillis();
        TranStruct t = JavaLinkDist.newDistOb((String)exp);
        TranStruct[] args = new TranStruct[]{t};
        logger.debug((Object)exp);
        TranStruct[] ts = this.callLisp("lisp-server::evalstring", args);
        String result = JavaLinkDist.stringValue((TranStruct)ts[1]);
        long end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("T:[" + (end - start) + "]"));
        }
        logger.debug((Object)result);
        return result;
    }

    private TranStruct[] callLisp(String lispFunc, TranStruct[] args) {
        if (connected && JavaLinkDist.query((boolean)false)) {
            return JavaLinkDist.invokeInLisp((int)2, (TranStruct)JavaLinkDist.newDistOb((String)lispFunc), (TranStruct[])args);
        }
        logger.error((Object)("Not connected to Lisp when calling " + lispFunc));
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

