/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.reasoner.impl;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;
import uk.ac.man.cs.img.dig.reasoner.impl.ConversionException;
import uk.ac.man.cs.img.dig.reasoner.impl.Names;
import uk.ac.man.cs.img.dig.reasoner.impl.sexpr.Parser;

public class Response {
    private Names names;

    public Response(Names names) {
        this.names = names;
    }

    public String convert(Element query, String response) throws ConversionException {
        String id = query.getAttribute("id");
        StringWriter result = new StringWriter();
        if (this.booleanQuery(query)) {
            if (this.parseToBool(response)) {
                result.write("\n  <true id=\"");
                result.write(id);
                result.write("\"/>");
            } else {
                result.write("\n  <false id=\"");
                result.write(id);
                result.write("\"/>");
            }
        } else if (this.conceptSetQuery(query)) {
            result.write("\n  <conceptSet id=\"");
            result.write(id);
            result.write("\">");
            Vector v = this.parseToVector(response);
            Enumeration ns = v.elements();
            while (ns.hasMoreElements()) {
                Vector iv = (Vector)ns.nextElement();
                Vector<String> iv2 = new Vector<String>();
                Enumeration ins = iv.elements();
                while (ins.hasMoreElements()) {
                    String nm = (String)ins.nextElement();
                    if (nm.equals(":TOP")) {
                        iv2.add(" <top/>");
                        continue;
                    }
                    if (nm.equals(":BOTTOM")) {
                        iv2.add(" <bottom/>");
                        continue;
                    }
                    if (nm.startsWith(Names.individualPrefix)) continue;
                    iv2.add(" <catom name=\"" + this.names.fromFaCT(nm) + "\"/>");
                }
                if (iv2.size() <= 0) continue;
                result.write("\n   <synonyms>");
                Enumeration ins2 = iv2.elements();
                while (ins2.hasMoreElements()) {
                    String nm = (String)ins2.nextElement();
                    result.write(nm);
                }
                result.write(" </synonyms>");
            }
            result.write("\n  </conceptSet>");
        } else if (this.individualSetQuery(query)) {
            result.write("\n  <individualSet id=\"");
            result.write(id);
            result.write("\">");
            Vector v = this.parseToVector(response);
            Enumeration ns = v.elements();
            while (ns.hasMoreElements()) {
                Vector iv = (Vector)ns.nextElement();
                Enumeration ins = iv.elements();
                while (ins.hasMoreElements()) {
                    String nm = (String)ins.nextElement();
                    if (!nm.startsWith(Names.individualPrefix)) continue;
                    result.write("\n    <individual name=\"");
                    result.write(this.names.fromFaCT(nm));
                    result.write("\"/>");
                }
            }
            result.write("\n  </individualSet>");
        }
        return result.toString();
    }

    public String error(Element query, String message, int code) {
        String id = query.getAttribute("id");
        StringWriter result = new StringWriter();
        result.write("\n  <error id=\"" + id + "\"");
        result.write(" code=\"" + code + "\"");
        result.write(" message=\"" + message + "\"");
        result.write("/>");
        return result.toString();
    }

    protected Vector parseToVector(String res) throws ConversionException {
        try {
            Parser.ReInit(new StringReader(res));
            Vector v = Parser.cnames();
            return v;
        }
        catch (Throwable t) {
            throw new ConversionException(t.getMessage());
        }
    }

    protected Vector parseSynonymsFromTaxonomyNode(String res) throws ConversionException {
        try {
            Parser.ReInit(new StringReader(res));
            Vector[] vs = Parser.taxonomyNode();
            return vs[2];
        }
        catch (Throwable t) {
            throw new ConversionException(t.getMessage());
        }
    }

    protected Vector parseSupersFromTaxonomyNode(String res) throws ConversionException {
        try {
            Parser.ReInit(new StringReader(res));
            Vector[] vs = Parser.taxonomyNode();
            return vs[0];
        }
        catch (Throwable t) {
            throw new ConversionException(t.getMessage());
        }
    }

    protected Vector parseSubsFromTaxonomyNode(String res) throws ConversionException {
        try {
            Parser.ReInit(new StringReader(res));
            Vector[] vs = Parser.taxonomyNode();
            return vs[1];
        }
        catch (Throwable t) {
            throw new ConversionException(t.getMessage());
        }
    }

    protected boolean parseToBool(String res) throws ConversionException {
        try {
            Parser.ReInit(new StringReader(res));
            return Parser.bool();
        }
        catch (Throwable t) {
            throw new ConversionException(t.getMessage());
        }
    }

    protected boolean booleanQuery(Element e) {
        String name = e.getTagName();
        return name.equals("satisfiable") || name.equals("subsumes") || name.equals("disjoint");
    }

    protected boolean conceptSetQuery(Element e) {
        String name = e.getTagName();
        return name.equals("parents") || name.equals("children") || name.equals("ancestors") || name.equals("descendants") || name.equals("allConceptNames") || name.equals("equivalents") || name.equals("types");
    }

    protected boolean individualSetQuery(Element e) {
        String name = e.getTagName();
        return name.equals("allIndividuals") || name.equals("instances");
    }
}

