/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.test;

import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import uk.ac.man.cs.img.dig.helper.Response;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.test.Test;

public class SimpleTest
extends Test {
    public SimpleTest(Reasoner reasoner, URL url, Element log) {
        super(reasoner, url, log);
    }

    public boolean runTest() throws Exception {
        try {
            this.getInformation();
            this.message(this.getName());
            Object sb = null;
            StringWriter sw = null;
            Response serverResponse = null;
            boolean passed = true;
            InputStreamReader r = null;
            Element testLog = this.log.getOwnerDocument().createElement("simpletest");
            testLog.setAttribute("url", this.url.toString());
            testLog.setAttribute("name", this.getName());
            this.log.appendChild(testLog);
            URL kbUrl = new URL(this.url, "kb.xml");
            r = new InputStreamReader(kbUrl.openStream());
            sw = new StringWriter();
            long start = System.currentTimeMillis();
            this.reasoner.request(r, sw);
            long end = System.currentTimeMillis();
            long loadTime = end - start;
            testLog.setAttribute("loadTime", Long.toString(loadTime));
            this.message("..Loaded");
            URL queryUrl = new URL(this.url, "queries.xml");
            r = new InputStreamReader(queryUrl.openStream());
            sw = new StringWriter();
            start = System.currentTimeMillis();
            this.reasoner.request(r, sw);
            end = System.currentTimeMillis();
            long queryTime = end - start;
            testLog.setAttribute("queryTime", Long.toString(queryTime));
            this.message("..Queried");
            serverResponse = new Response(sw.toString());
            Set ids = serverResponse.getIds();
            if (ids.size() > 0) {
                testLog.setAttribute("queries", Integer.toString(ids.size()));
                Iterator it = ids.iterator();
                while (it.hasNext()) {
                    String id = (String)it.next();
                    String num = "x";
                    String expected = "";
                    if (id.startsWith("true")) {
                        expected = "true";
                        num = id.substring(4);
                    } else if (id.startsWith("false")) {
                        expected = "false";
                        num = id.substring(5);
                    }
                    Element el = serverResponse.extractResponse(id);
                    Element testResult = this.log.getOwnerDocument().createElement("query");
                    testResult.setAttribute("number", num);
                    if (el.getTagName().equals(expected)) {
                        testResult.setAttribute("result", "pass");
                    } else {
                        testResult.setAttribute("result", "fail");
                        passed = false;
                    }
                    testLog.appendChild(testResult);
                }
            }
            return passed;
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

