/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.dig.test;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.test.SimpleTest;
import uk.ac.man.cs.img.dig.test.SoakTest;
import uk.ac.man.cs.img.dig.test.Test;

public class TestSuite {
    private URL url;
    private Reasoner reasoner;
    private Document doc;

    public TestSuite(Reasoner reasoner, URL url, Document doc) {
        this.reasoner = reasoner;
        this.url = url;
        this.doc = doc;
    }

    public void runTests() {
        try {
            Element docElement;
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setValidating(false);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                InputSource input = new InputSource(this.url.openStream());
                Document testDoc = builder.parse(input);
                docElement = testDoc.getDocumentElement();
            }
            catch (Exception ex) {
                Element log = this.doc.createElement("error");
                log.appendChild(this.doc.createTextNode("Unable to open " + this.url.toString()));
                return;
            }
            Element log = this.doc.createElement("suite");
            log.setAttribute("url", this.url.toString());
            this.doc.getDocumentElement().appendChild(log);
            Object sb = null;
            NodeList nl = docElement.getChildNodes();
            ArrayList al = new ArrayList();
            int i = 0;
            while (i < nl.getLength()) {
                Node nod = nl.item(i);
                try {
                    if (nod.getNodeType() != 3 && nod.getNodeType() != 8) {
                        Test test;
                        URL testURL;
                        String str;
                        Element el;
                        if (nod.getNodeName().equals("simpletest")) {
                            el = (Element)nod;
                            str = el.getAttribute("url");
                            testURL = new URL(this.url, str);
                            test = new SimpleTest(this.reasoner, testURL, log);
                            ((SimpleTest)test).runTest();
                        } else if (nod.getNodeName().equals("soaktest")) {
                            el = (Element)nod;
                            str = el.getAttribute("url");
                            testURL = new URL(this.url, str);
                            test = new SoakTest(this.reasoner, testURL, log);
                            ((SoakTest)test).runTest();
                        }
                    }
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

