/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.parser;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.parser.QueryParser;
import com.clarkparsia.pellet.sparqldl.parser.SparqldlExtensionsVocabulary;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARQParser
implements QueryParser {
    public static Logger log = Logger.getLogger(ARQParser.class.getName());
    private Set<Triple> triples;
    private Map<Node, ATerm> terms;
    private KnowledgeBase kb;
    private QuerySolution initialBinding;
    private boolean handleVariableSPO = true;

    public ARQParser() {
        this(true);
    }

    public ARQParser(boolean handleVariableSPO) {
        this.handleVariableSPO = handleVariableSPO;
    }

    @Override
    public Query parse(InputStream stream, KnowledgeBase kb) {
        try {
            return this.parse(new InputStreamReader(stream), kb);
        }
        catch (IOException e) {
            String message = "Error creating a reader from the input stream.";
            log.severe("Error creating a reader from the input stream.");
            throw new RuntimeException("Error creating a reader from the input stream.");
        }
    }

    @Override
    public Query parse(String queryStr, KnowledgeBase kb) {
        com.hp.hpl.jena.query.Query sparql = QueryFactory.create((String)queryStr, (Syntax)Syntax.syntaxSPARQL);
        return this.parse(sparql, kb);
    }

    private Query parse(Reader in, KnowledgeBase kb) throws IOException {
        StringBuffer queryString = new StringBuffer();
        BufferedReader r = new BufferedReader(in);
        String line = r.readLine();
        while (line != null) {
            queryString.append(line).append("\n");
            line = r.readLine();
        }
        return this.parse(queryString.toString(), kb);
    }

    @Override
    public Query parse(com.hp.hpl.jena.query.Query sparql, KnowledgeBase kb) {
        this.kb = kb;
        if (sparql.isDescribeType()) {
            throw new UnsupportedQueryException("DESCRIBE queries cannot be answered with PelletQueryEngine");
        }
        Element pattern = sparql.getQueryPattern();
        if (!(pattern instanceof ElementGroup)) {
            throw new UnsupportedQueryException("ElementGroup was expected, but found '" + pattern.getClass() + "'.");
        }
        ElementGroup elementGroup = (ElementGroup)pattern;
        List elements = elementGroup.getElements();
        Element first = (Element)elements.get(0);
        if (elements.size() != 1 || !(first instanceof ElementTriplesBlock)) {
            throw new UnsupportedQueryException("Complex query patterns are not supported yet.");
        }
        sparql.setResultVars();
        return this.parse(((ElementTriplesBlock)first).getPattern(), sparql.getResultVars(), kb, sparql.isDistinct());
    }

    public Query parse(BasicPattern basicPattern, Collection<?> resultVars, KnowledgeBase kb, boolean isDistinct) throws UnsupportedQueryException {
        this.kb = kb;
        HashSet<ATermAppl> variablePredicates = new HashSet<ATermAppl>();
        HashSet<ATermAppl> variableSubjects = new HashSet<ATermAppl>();
        this.terms = new HashMap<Node, ATerm>();
        this.triples = new LinkedHashSet<Triple>(this.resolveParameterization(basicPattern.getList()));
        QueryImpl query = new QueryImpl(kb, isDistinct);
        for (String var : resultVars) {
            query.addResultVar(ATermUtils.makeVar((String)var));
        }
        for (Triple t : new ArrayList<Triple>(this.triples)) {
            if (!this.triples.contains(t)) continue;
            Node subj = t.getSubject();
            Node pred = t.getPredicate();
            Node obj = t.getObject();
            ATermAppl s1 = this.node2term(subj);
            ATermAppl p1 = this.node2term(pred);
            ATermAppl o1 = this.node2term(obj);
            this.terms.put(subj, (ATerm)s1);
            this.terms.put(pred, (ATerm)p1);
            this.terms.put(obj, (ATerm)o1);
        }
        HashSet<ATermAppl> possibleLiteralVars = new HashSet<ATermAppl>();
        for (Triple t : this.triples) {
            Node subj = t.getSubject();
            Node pred = t.getPredicate();
            Node obj = t.getObject();
            ATermAppl s = (ATermAppl)this.terms.get(subj);
            ATermAppl p = (ATermAppl)this.terms.get(pred);
            ATermAppl o = (ATermAppl)this.terms.get(obj);
            if (pred.equals((Object)RDF.Nodes.type)) {
                if (obj.equals((Object)OWL.ObjectProperty.asNode())) {
                    query.add(QueryAtomFactory.ObjectPropertyAtom(s));
                    if (!ATermUtils.isVar((ATermAppl)s)) continue;
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (!this.handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (obj.equals((Object)OWL.DatatypeProperty.asNode())) {
                    query.add(QueryAtomFactory.DatatypePropertyAtom(s));
                    if (!ATermUtils.isVar((ATermAppl)s)) continue;
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (!this.handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (obj.equals((Object)RDF.Property.asNode())) {
                    if (!ATermUtils.isVar((ATermAppl)s)) continue;
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (!this.handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (obj.equals((Object)OWL.FunctionalProperty.asNode())) {
                    query.add(QueryAtomFactory.FunctionalAtom(s));
                    if (!ATermUtils.isVar((ATermAppl)s)) continue;
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (!this.handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (obj.equals((Object)OWL.InverseFunctionalProperty.asNode())) {
                    query.add(QueryAtomFactory.InverseFunctionalAtom(s));
                    if (!ATermUtils.isVar((ATermAppl)s)) continue;
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (!this.handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (obj.equals((Object)OWL.TransitiveProperty.asNode())) {
                    query.add(QueryAtomFactory.TransitiveAtom(s));
                    if (!ATermUtils.isVar((ATermAppl)s)) continue;
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (!this.handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (obj.equals((Object)OWL.SymmetricProperty.asNode())) {
                    query.add(QueryAtomFactory.SymmetricAtom(s));
                    if (!ATermUtils.isVar((ATermAppl)s)) continue;
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (!this.handleVariableSPO) continue;
                    variablePredicates.remove(s);
                    variableSubjects.add(s);
                    continue;
                }
                if (this.hasObject(pred, RDF.type.asNode(), OWL.AnnotationProperty.asNode())) {
                    query.add(QueryAtomFactory.AnnotationAtom(s, p, o));
                    if (!ATermUtils.isVar((ATermAppl)s) && !ATermUtils.isVar((ATermAppl)p) && !ATermUtils.isVar((ATermAppl)o)) continue;
                    throw new IllegalArgumentException("Variables in annotation atom are not supported.");
                }
                query.add(QueryAtomFactory.TypeAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)o)) {
                    this.ensureDistinguished(obj);
                    query.addDistVar(o, Query.VarType.CLASS);
                } else if (!kb.isClass((ATerm)o) && log.isLoggable(Level.FINE)) {
                    log.fine("Class " + o + " used in the query is not defined in the KB.");
                }
                if (!ARQParser.isDistinguishedVariable(subj)) continue;
                query.addDistVar(s, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (pred.equals((Object)OWL.sameAs.asNode())) {
                query.add(QueryAtomFactory.SameAsAtom(s, o));
                if (ARQParser.isDistinguishedVariable(subj)) {
                    query.addDistVar(s, Query.VarType.INDIVIDUAL);
                }
                if (!ARQParser.isDistinguishedVariable(obj)) continue;
                query.addDistVar(o, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (pred.equals((Object)OWL.differentFrom.asNode())) {
                query.add(QueryAtomFactory.DifferentFromAtom(s, o));
                if (ARQParser.isDistinguishedVariable(subj)) {
                    query.addDistVar(s, Query.VarType.INDIVIDUAL);
                }
                if (!ARQParser.isDistinguishedVariable(obj)) continue;
                query.addDistVar(o, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (pred.equals((Object)RDFS.subClassOf.asNode())) {
                query.add(QueryAtomFactory.SubClassOfAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)SparqldlExtensionsVocabulary.strictSubClassOf.asNode())) {
                query.add(QueryAtomFactory.StrictSubClassOfAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)SparqldlExtensionsVocabulary.directSubClassOf.asNode())) {
                query.add(QueryAtomFactory.DirectSubClassOfAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)OWL.equivalentClass.asNode())) {
                query.add(QueryAtomFactory.EquivalentClassAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)OWL.disjointWith.asNode())) {
                query.add(QueryAtomFactory.DisjointWithAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)OWL.complementOf.asNode())) {
                query.add(QueryAtomFactory.ComplementOfAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.CLASS);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (pred.equals((Object)RDFS.subPropertyOf.asNode())) {
                query.add(QueryAtomFactory.SubPropertyOfAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)SparqldlExtensionsVocabulary.directSubPropertyOf.asNode())) {
                query.add(QueryAtomFactory.DirectSubPropertyOfAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(obj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)SparqldlExtensionsVocabulary.strictSubPropertyOf.asNode())) {
                query.add(QueryAtomFactory.StrictSubPropertyOfAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(obj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)OWL.equivalentProperty.asNode())) {
                query.add(QueryAtomFactory.EquivalentPropertyAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)OWL.inverseOf.asNode())) {
                query.add(QueryAtomFactory.InverseOfAtom(s, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (pred.equals((Object)SparqldlExtensionsVocabulary.directType.asNode())) {
                query.add(QueryAtomFactory.DirectTypeAtom(s, o));
                if (ARQParser.isDistinguishedVariable(subj)) {
                    query.addDistVar(s, Query.VarType.INDIVIDUAL);
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.CLASS);
                continue;
            }
            if (kb.isAnnotationProperty((ATerm)p)) {
                if (!PelletOptions.USE_ANNOTATION_SUPPORT) {
                    throw new UnsupportedQueryException("Cannot answer annotation queries when PelletOptions.USE_ANNOTATION_SUPPORT is false!");
                }
                query.add(QueryAtomFactory.AnnotationAtom(s, p, o));
                if (ATermUtils.isVar((ATermAppl)s)) {
                    this.ensureDistinguished(subj);
                    query.addDistVar(s, Query.VarType.PROPERTY);
                    if (this.handleVariableSPO) {
                        variablePredicates.remove(s);
                        variableSubjects.add(s);
                    }
                }
                if (!ATermUtils.isVar((ATermAppl)o)) continue;
                this.ensureDistinguished(obj);
                query.addDistVar(o, Query.VarType.PROPERTY);
                if (!this.handleVariableSPO) continue;
                variablePredicates.remove(o);
                variableSubjects.add(o);
                continue;
            }
            if (s == null || p == null || o == null) {
                throw new UnsupportedQueryException("Atom conversion incomplete for: " + t);
            }
            query.add(QueryAtomFactory.PropertyValueAtom(s, p, o));
            if (ATermUtils.isVar((ATermAppl)p)) {
                this.ensureDistinguished(pred);
                query.addDistVar(p, Query.VarType.PROPERTY);
                if (!variableSubjects.contains(p)) {
                    variablePredicates.add(p);
                }
            } else {
                if (kb.isOntologyProperty((ATerm)p)) {
                    throw new UnsupportedQueryException("Ontology properties are not supported in queries.");
                }
                if (!kb.isProperty((ATerm)p) && log.isLoggable(Level.FINE)) {
                    log.fine("Predicate " + p + " used in the query is not defined in the KB.");
                }
            }
            if (ARQParser.isDistinguishedVariable(subj)) {
                query.addDistVar(s, Query.VarType.INDIVIDUAL);
            }
            if (!ARQParser.isDistinguishedVariable(obj)) continue;
            if (ATermUtils.isVar((ATermAppl)p)) {
                possibleLiteralVars.add(o);
                continue;
            }
            if (kb.isObjectProperty((ATerm)p)) {
                query.addDistVar(o, Query.VarType.INDIVIDUAL);
                continue;
            }
            if (!kb.isDatatypeProperty((ATerm)p)) continue;
            query.addDistVar(o, Query.VarType.LITERAL);
        }
        for (ATermAppl v : possibleLiteralVars) {
            if (!query.getDistVars().contains(v)) {
                query.addDistVar(v, Query.VarType.LITERAL);
            }
            query.addDistVar(v, Query.VarType.INDIVIDUAL);
        }
        if (!this.handleVariableSPO) {
            return query;
        }
        if (variablePredicates.isEmpty()) {
            return query;
        }
        throw new UnsupportedQueryException("Queries with variable predicates are not supported (add the pattern {?p rdf:type owl:ObjectProperty} or {?p rdf:type owl:DatatypeProperty} to the query)");
    }

    public void setInitialBinding(QuerySolution initialBinding) {
        this.initialBinding = initialBinding;
    }

    private void ensureDistinguished(Node pred) {
        this.ensureDistinguished(pred, "Non-distinguished variables in class and predicate positions are not supported : ");
    }

    private void ensureDistinguished(Node pred, String errorNonDist) {
        if (!ARQParser.isDistinguishedVariable(pred)) {
            throw new UnsupportedQueryException(errorNonDist + pred);
        }
    }

    public static boolean isDistinguishedVariable(Node node) {
        return Var.isVar((Node)node) && (Var.isNamedVar((Node)node) || PelletOptions.TREAT_ALL_VARS_DISTINGUISHED);
    }

    private Node getObject(Node subj, Node pred) {
        Iterator<Triple> i = this.triples.iterator();
        while (i.hasNext()) {
            Triple t = i.next();
            if (!subj.equals((Object)t.getSubject()) || !pred.equals((Object)t.getPredicate())) continue;
            i.remove();
            return t.getObject();
        }
        return null;
    }

    private boolean hasObject(Node subj, Node pred) {
        for (Triple t : this.triples) {
            if (!subj.equals((Object)t.getSubject()) || !pred.equals((Object)t.getPredicate())) continue;
            return true;
        }
        return false;
    }

    private boolean hasObject(Node subj, Node pred, Node obj) {
        Iterator<Triple> i = this.triples.iterator();
        while (i.hasNext()) {
            Triple t = i.next();
            if (!subj.equals((Object)t.getSubject()) || !pred.equals((Object)t.getPredicate())) continue;
            i.remove();
            if (obj.equals((Object)t.getObject())) {
                return true;
            }
            throw new UnsupportedQueryException("Expecting rdf:type " + obj + " but found rdf:type " + t.getObject());
        }
        return false;
    }

    private ATermList createList(Node node) {
        if (node.equals((Object)RDF.nil.asNode())) {
            return ATermUtils.EMPTY_LIST;
        }
        if (this.terms.containsKey(node)) {
            return (ATermList)this.terms.get(node);
        }
        this.hasObject(node, RDF.type.asNode(), RDF.List.asNode());
        Node first = this.getObject(node, RDF.first.asNode());
        Node rest = this.getObject(node, RDF.rest.asNode());
        if (first == null || rest == null) {
            throw new UnsupportedQueryException("Invalid list structure: List " + node + " does not have a " + (first == null ? "rdf:first" : "rdf:rest") + " property.");
        }
        ATermList list = ATermUtils.makeList((ATerm)this.node2term(first), (ATermList)this.createList(rest));
        this.terms.put(node, (ATerm)list);
        return list;
    }

    private ATermAppl createRestriction(Node node) throws UnsupportedFeatureException {
        ATermAppl aTerm = ATermUtils.TOP;
        this.hasObject(node, RDF.type.asNode(), OWL.Restriction.asNode());
        Node p = this.getObject(node, OWL.onProperty.asNode());
        if (p == null) {
            return aTerm;
        }
        ATermAppl pt = this.node2term(p);
        if (!this.kb.isProperty((ATerm)pt)) {
            throw new UnsupportedQueryException("Property " + pt + " is not present in KB.");
        }
        Node o = null;
        o = this.getObject(node, OWL.hasValue.asNode());
        if (o != null) {
            if (PelletOptions.USE_PSEUDO_NOMINALS) {
                if (o.isLiteral()) {
                    aTerm = ATermUtils.makeMin((ATerm)pt, (int)1, (ATerm)ATermUtils.TOP_LIT);
                } else {
                    ATermAppl ind = ATermUtils.makeTermAppl((String)o.getURI());
                    if (!this.kb.isIndividual((ATerm)ind)) {
                        throw new UnsupportedQueryException("Individual " + ind + " is not present in KB.");
                    }
                    ATermAppl nom = ATermUtils.makeTermAppl((String)(o.getURI() + "_nom"));
                    aTerm = ATermUtils.makeSomeValues((ATerm)pt, (ATerm)nom);
                }
            } else {
                ATermAppl ot = this.node2term(o);
                aTerm = ATermUtils.makeHasValue((ATerm)pt, (ATerm)ot);
            }
        } else {
            o = this.getObject(node, OWL.allValuesFrom.asNode());
            if (o != null) {
                if (o.isVariable()) {
                    throw new UnsupportedQueryException("Variables not supported in allValuesFrom restriction");
                }
                ATermAppl ot = this.node2term(o);
                aTerm = ATermUtils.makeAllValues((ATerm)pt, (ATerm)ot);
            } else {
                o = this.getObject(node, OWL.someValuesFrom.asNode());
                if (o != null) {
                    if (o.isVariable()) {
                        throw new UnsupportedQueryException("Variables not supported in allValuesFrom restriction");
                    }
                    ATermAppl ot = this.node2term(o);
                    aTerm = ATermUtils.makeSomeValues((ATerm)pt, (ATerm)ot);
                } else {
                    o = this.getObject(node, OWL.minCardinality.asNode());
                    if (o != null) {
                        aTerm = this.createCardinalityRestriction(node, OWL.minCardinality.asNode(), pt, o);
                    } else {
                        o = this.getObject(node, OWL2.minQualifiedCardinality.asNode());
                        if (o != null) {
                            aTerm = this.createCardinalityRestriction(node, OWL2.minQualifiedCardinality.asNode(), pt, o);
                        } else {
                            o = this.getObject(node, OWL.maxCardinality.asNode());
                            if (o != null) {
                                aTerm = this.createCardinalityRestriction(node, OWL.maxCardinality.asNode(), pt, o);
                            } else {
                                o = this.getObject(node, OWL2.maxQualifiedCardinality.asNode());
                                if (o != null) {
                                    aTerm = this.createCardinalityRestriction(node, OWL2.maxQualifiedCardinality.asNode(), pt, o);
                                } else {
                                    o = this.getObject(node, OWL.cardinality.asNode());
                                    if (o != null) {
                                        aTerm = this.createCardinalityRestriction(node, OWL.cardinality.asNode(), pt, o);
                                    } else {
                                        o = this.getObject(node, OWL2.qualifiedCardinality.asNode());
                                        if (o != null) {
                                            aTerm = this.createCardinalityRestriction(node, OWL2.qualifiedCardinality.asNode(), pt, o);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return aTerm;
    }

    private ATermAppl createCardinalityRestriction(Node node, Node restrictionType, ATermAppl pt, Node card) throws UnsupportedQueryException {
        try {
            ATermAppl c = null;
            Node qualification = null;
            qualification = this.getObject(node, OWL2.onClass.asNode());
            if (qualification != null) {
                if (qualification.isVariable()) {
                    throw new UnsupportedQueryException("Variables not allowed in cardinality qualification");
                }
                if (!this.kb.isObjectProperty((ATerm)pt)) {
                    return null;
                }
                c = this.node2term(qualification);
            } else {
                qualification = this.getObject(node, OWL2.onDataRange.asNode());
                if (qualification != null) {
                    if (qualification.isVariable()) {
                        throw new UnsupportedQueryException("Variables not allowed in cardinality qualification");
                    }
                    if (!this.kb.isDatatypeProperty((ATerm)pt)) {
                        return null;
                    }
                    c = this.node2term(qualification);
                } else {
                    int propType = this.kb.getPropertyType((ATerm)pt);
                    c = propType == 1 ? ATermUtils.TOP : (propType == 2 ? ATermUtils.TOP_LIT : ATermUtils.TOP);
                }
            }
            int cardinality = Integer.parseInt(card.getLiteralLexicalForm());
            if (restrictionType.equals((Object)OWL.minCardinality.asNode()) || restrictionType.equals((Object)OWL2.minQualifiedCardinality.asNode())) {
                return ATermUtils.makeMin((ATerm)pt, (int)cardinality, (ATerm)c);
            }
            if (restrictionType.equals((Object)OWL.maxCardinality.asNode()) || restrictionType.equals((Object)OWL2.maxQualifiedCardinality.asNode())) {
                return ATermUtils.makeMax((ATerm)pt, (int)cardinality, (ATerm)c);
            }
            return ATermUtils.makeCard((ATerm)pt, (int)cardinality, (ATerm)c);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Invalid cardinality", ex);
            return null;
        }
    }

    private ATermAppl node2term(Node node) {
        ATermAppl aTerm = (ATermAppl)this.terms.get(node);
        if (aTerm == null) {
            if (node.equals((Object)OWL.Thing.asNode())) {
                return ATermUtils.TOP;
            }
            if (node.equals((Object)OWL.Nothing.asNode())) {
                return ATermUtils.BOTTOM;
            }
            if (node.equals((Object)RDF.type.asNode())) {
                return null;
            }
            if (node.isLiteral()) {
                return JenaUtils.makeLiteral((LiteralLabel)node.getLiteral());
            }
            if (this.hasObject(node, OWL.onProperty.asNode())) {
                aTerm = this.createRestriction(node);
                this.terms.put(node, (ATerm)aTerm);
            } else if (node.isBlank() || node.isVariable()) {
                Node o = null;
                o = this.getObject(node, OWL.intersectionOf.asNode());
                if (o != null) {
                    ATermList list = this.createList(o);
                    this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                    aTerm = ATermUtils.makeAnd((ATermList)list);
                } else {
                    o = this.getObject(node, OWL.unionOf.asNode());
                    if (o != null) {
                        ATermList list = this.createList(o);
                        this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                        aTerm = ATermUtils.makeOr((ATermList)list);
                    } else {
                        o = this.getObject(node, OWL.oneOf.asNode());
                        if (o != null) {
                            ATermList list = this.createList(o);
                            this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                            ATermList result = ATermUtils.EMPTY_LIST;
                            ATermList l = list;
                            while (!l.isEmpty()) {
                                ATermAppl nominal;
                                ATermAppl c = (ATermAppl)l.getFirst();
                                if (PelletOptions.USE_PSEUDO_NOMINALS) {
                                    nominal = ATermUtils.makeTermAppl((String)(c.getName() + "_nominal"));
                                    result = result.insert((ATerm)nominal);
                                } else {
                                    nominal = ATermUtils.makeValue((ATerm)c);
                                    result = result.insert((ATerm)nominal);
                                }
                                l = l.getNext();
                            }
                            aTerm = ATermUtils.makeOr((ATermList)result);
                        } else if (Var.isBlankNodeVar((Node)node) && (o = this.getObject(node, OWL.complementOf.asNode())) != null) {
                            ATermAppl complement = this.node2term(o);
                            this.hasObject(node, RDF.type.asNode(), OWL.Class.asNode());
                            aTerm = ATermUtils.makeNot((ATerm)complement);
                        } else {
                            if (node.isVariable()) {
                                return ATermUtils.makeVar((String)node.getName());
                            }
                            o = this.getObject(node, OWL.complementOf.asNode());
                            if (o != null) {
                                log.info("Blank nodes in class variable positions are not supported");
                            }
                            aTerm = ATermUtils.makeBnode((String)node.getBlankNodeId().toString());
                        }
                    }
                }
            } else {
                String uri = node.getURI();
                aTerm = ATermUtils.makeTermAppl((String)uri);
            }
            this.terms.put(node, (ATerm)aTerm);
        }
        return aTerm;
    }

    private List<Triple> resolveParameterization(List<?> triples) {
        if (triples == null) {
            throw new NullPointerException("The set of triples cannot be null");
        }
        if (this.initialBinding == null) {
            this.initialBinding = new QuerySolutionMap();
        }
        ArrayList<Triple> ret = new ArrayList<Triple>();
        for (Triple t : triples.toArray(new Triple[triples.size()])) {
            if (!triples.contains(t)) continue;
            Node s = this.resolveParameterization(t.getSubject());
            Node p = this.resolveParameterization(t.getPredicate());
            Node o = this.resolveParameterization(t.getObject());
            ret.add(Triple.create((Node)s, (Node)p, (Node)o));
        }
        return ret;
    }

    private Node resolveParameterization(Node node) {
        if (node == null) {
            throw new NullPointerException("Node is null");
        }
        if (this.initialBinding == null) {
            throw new NullPointerException("Initial binding is null");
        }
        if (node.isConcrete()) {
            return node;
        }
        RDFNode binding = this.initialBinding.get(node.getName());
        if (binding == null) {
            return node;
        }
        return binding.asNode();
    }
}

