/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.metaset;

import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import org.act.xservices.rt.metaset.MetasetBuilder;
import org.act.xservices.rt.metaset.MetasetParser;
import org.act.xservices.rt.metaset.exception.MetasetParsingException;
import org.act.xservices.rt.metaset.utils.MetasetUtil;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentException;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.io.SAXReader;
import org.xml.sax.InputSource;

public class MetasetSAXParser
implements MetasetParser {
    private SAXReader sax = new SAXReader(MetasetBuilder.getInstance());

    public Metaset parse(InputStream in) throws MetasetParsingException {
        try {
            Document doc = this.sax.read(in);
            return doc.getRootElement();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Metaset parse(String filePath) throws MetasetParsingException {
        try {
            Document doc = this.sax.read(new File(filePath));
            return doc.getRootElement();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Metaset parseXMLString(String xmlString) throws MetasetParsingException {
        String encoding = MetasetUtil.getEncoding(xmlString);
        InputSource source = new InputSource(new StringReader(xmlString));
        source.setEncoding(encoding);
        try {
            Document doc = this.sax.read(source);
            if (doc.getXMLEncoding() == null) {
                doc.setXMLEncoding(encoding);
            }
            return doc.getRootElement();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }
}

