/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.metaset;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.act.xservices.rt.metaset.MetasetBuilder;
import org.act.xservices.rt.metaset.MetasetParser;
import org.act.xservices.rt.metaset.exception.MetasetParsingException;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.io.STAXEventReader;

public class MetasetStAXParser
implements MetasetParser {
    private STAXEventReader stax = new STAXEventReader(MetasetBuilder.getInstance());

    public Metaset parse(InputStream in) throws MetasetParsingException {
        try {
            Document doc = this.stax.readDocument(in);
            return doc.getRootElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Metaset parse(String filePath) throws MetasetParsingException {
        try {
            Metaset results = this.parse(new FileInputStream(filePath));
            return results;
        }
        catch (FileNotFoundException e) {
            throw new MetasetParsingException("Malformat error with Metaset parser\uff0c for " + e.getMessage());
        }
    }

    public Metaset parseXMLString(String xmlString) throws MetasetParsingException {
        ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
        Metaset results = this.parse(in);
        return results;
    }
}

