/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.metaset.query;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.act.xservices.rt.metaset.exception.ElementExpressionException;
import org.act.xservices.rt.metaset.utils.ExpressionUtil;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementExpression {
    private QName elementQName = null;
    private List<Attribute> attrList = new ArrayList<Attribute>(0);

    public ElementExpression(String eleExp) throws ElementExpressionException {
        this.parseElementExp(eleExp);
    }

    private void parseElementExp(String eleExp) throws ElementExpressionException {
        StringTokenizer st = new StringTokenizer(eleExp = eleExp.trim(), "@");
        if (st.hasMoreTokens()) {
            String elementStr = st.nextToken();
            QName qname = ExpressionUtil.parseQNameString(elementStr);
            this.setElementQName(qname);
        }
        while (st.hasMoreTokens()) {
            this.attrList.add(ExpressionUtil.parseAttributeString(st.nextToken()));
        }
    }

    public List<Attribute> getAttrList() {
        return this.attrList;
    }

    public void setAttrList(List<Attribute> attrList) {
        this.attrList = attrList;
    }

    public QName getElementQName() {
        return this.elementQName;
    }

    public void setElementQName(QName elementQName) {
        this.elementQName = elementQName;
    }
}

