/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.metaset.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.act.xservices.rt.metaset.MetasetBuilder;
import org.act.xservices.rt.metaset.exception.ElementExpressionException;
import org.act.xservices.rt.metaset.exception.PathExpressionException;
import org.act.xservices.rt.metaset.query.ElementExpression;
import org.act.xservices.rt.metaset.query.IPathExpression;
import org.act.xservices.rt.metaset.query.PathExpression;
import org.act.xservices.rt.metaset.utils.MetasetUtil;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.xpath.DefaultXPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterProcessor {
    private static FilterProcessor instance = new FilterProcessor();

    public static FilterProcessor getInstance() {
        return instance;
    }

    public Metaset filter(String pathExp, Metaset metasetIn) {
        try {
            PathExpression expression = new PathExpression(pathExp);
            return this.filter(expression, metasetIn);
        }
        catch (ElementExpressionException e) {
            System.err.println("Error in pathExpression for " + e.getMessage());
            return null;
        }
        catch (PathExpressionException e) {
            System.err.println("Error in pathExpression for " + e.getMessage());
            return null;
        }
    }

    public Metaset filterByXPath(String pathExp, Metaset metasetIn, Map<String, String> namespaceMap) {
        ArrayList<Metaset> result = new ArrayList<Metaset>();
        DefaultXPath xpathExpression = new DefaultXPath(pathExp);
        if (namespaceMap != null) {
            xpathExpression.setNamespaceURIs((Map)namespaceMap);
        }
        List nodes = xpathExpression.selectNodes(metasetIn);
        int i = 0;
        while (i < nodes.size()) {
            result.add((Metaset)nodes.get(i));
            ++i;
        }
        return MetasetUtil.encapsulateByMetaset(result);
    }

    public Metaset filter(IPathExpression pathExp, Metaset metasetIn) {
        ArrayList<Metaset> resultList = new ArrayList<Metaset>();
        Stack<Metaset> matchStack = new Stack<Metaset>();
        matchStack.push(metasetIn);
        Iterator<ElementExpression> iter_pathEle = pathExp.getElementList().iterator();
        while (iter_pathEle.hasNext()) {
            Stack<Metaset> nextMatchStack = new Stack<Metaset>();
            ElementExpression pathElemExp = iter_pathEle.next();
            while (!matchStack.empty()) {
                Metaset metTemp = (Metaset)matchStack.pop();
                boolean eleMatchFlag = false;
                if (!this.matchPathElementName(pathElemExp, metTemp)) continue;
                eleMatchFlag = true;
                eleMatchFlag = this.matchPathAttributeValue(pathElemExp.getAttrList(), metTemp);
                if (!eleMatchFlag) continue;
                if (!iter_pathEle.hasNext()) {
                    resultList.add(metTemp);
                    continue;
                }
                Iterator<Metaset> children = metTemp.elementIterator();
                while (children.hasNext()) {
                    nextMatchStack.push(children.next());
                }
            }
            matchStack = nextMatchStack;
        }
        if ((pathExp.getElementList().size() & 1) != 0) {
            return this.encapsulateByMetaset(resultList, false);
        }
        return this.encapsulateByMetaset(resultList, true);
    }

    private boolean matchPathAttributeValue(List<Attribute> pathAttrList, Metaset met) {
        for (Attribute pathAttribute : pathAttrList) {
            boolean attrMatchFlag = false;
            Iterator<Attribute> attris = met.attributeIterator();
            while (attris.hasNext()) {
                Attribute attrTemp = attris.next();
                if (!this.matchPathAttributeName(pathAttribute, attrTemp.getQName())) continue;
                boolean noAttrValue = pathAttribute.getValue().equals("");
                boolean allAttrValue = pathAttribute.getValue().equals("*");
                boolean match_Value = pathAttribute.getValue().equals(attrTemp.getValue());
                if (!noAttrValue && !allAttrValue && !match_Value) continue;
                attrMatchFlag = true;
                break;
            }
            for (Namespace ns : met.declaredNamespaces()) {
                QName nsQName = null;
                nsQName = ns.getPrefix() == null || ns.getPrefix().equals("") ? new QName(ns.getURI(), "", "xmlns") : new QName(ns.getURI(), ns.getPrefix(), "xmlns");
                if (!this.matchPathAttributeName(pathAttribute, nsQName)) continue;
                boolean noAttrValue = pathAttribute.getValue().equals("");
                boolean allAttrValue = pathAttribute.getValue().equals("*");
                boolean match_Value = pathAttribute.getValue().equals(ns.getURI());
                if (!noAttrValue && !allAttrValue && !match_Value) continue;
                attrMatchFlag = true;
                break;
            }
            if (attrMatchFlag) continue;
            return false;
        }
        return true;
    }

    private Metaset encapsulateByMetaset(List<Metaset> resultList, boolean anti_order) {
        if (resultList.isEmpty()) {
            return null;
        }
        Metaset resultMet = MetasetBuilder.getInstance().newMetaset();
        if (anti_order) {
            int i = resultList.size() - 1;
            while (i >= 0) {
                resultMet.encapsulatedChild(resultList.get(i));
                --i;
            }
        } else {
            int i = 0;
            while (i < resultList.size()) {
                resultMet.encapsulatedChild(resultList.get(i));
                ++i;
            }
        }
        return resultMet;
    }

    private boolean matchPathElementName(ElementExpression pathElement, Metaset met) {
        String elementLocalName = pathElement.getElementQName().getName().trim();
        String elementNamespace = "";
        elementNamespace = !pathElement.getElementQName().getNamespacePrefix().equals("") ? pathElement.getElementQName().getNamespacePrefix().trim() : pathElement.getElementQName().getNamespaceURI().trim();
        if (elementLocalName.equals(".") || elementLocalName.equals("*")) {
            return true;
        }
        if (elementLocalName.equals(met.getQName().getName())) {
            if (elementNamespace.equals("")) {
                return true;
            }
            if (!pathElement.getElementQName().getNamespacePrefix().equals("") && elementNamespace.equals(met.getQName().getNamespacePrefix())) {
                return true;
            }
            return !pathElement.getElementQName().getNamespaceURI().equals("") && elementNamespace.equals(met.getQName().getNamespaceURI());
        }
        return false;
    }

    private boolean matchPathAttributeName(Attribute pathAttr, QName qName) {
        String pathAttrLocalName = pathAttr.getQName().getName();
        String pathAttrNameSpace = "";
        pathAttrNameSpace = !pathAttr.getQName().getNamespacePrefix().equals("") ? pathAttr.getQName().getNamespacePrefix() : pathAttr.getQName().getNamespaceURI();
        if (pathAttrLocalName.equals("*")) {
            return true;
        }
        if (pathAttrLocalName.equals(qName.getName())) {
            if (pathAttrNameSpace.equals("")) {
                return true;
            }
            if (!pathAttr.getQName().getNamespacePrefix().equals("") && pathAttrNameSpace.equals(qName.getNamespacePrefix())) {
                return true;
            }
            return !pathAttr.getQName().getNamespaceURI().equals("") && pathAttrNameSpace.equals(qName.getNamespaceURI());
        }
        return false;
    }
}

