/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.metaset.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.act.xservices.rt.metaset.exception.QNameExpressionException;
import org.act.xservices.rt.metaset.query.FilterProcessor;
import org.act.xservices.rt.metaset.utils.ExpressionUtil;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.xpath.DefaultXPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorProcessor {
    private static SelectorProcessor instance = new SelectorProcessor();

    public static SelectorProcessor getInstance() {
        return instance;
    }

    public QName selectorElementName(String pathExp, Metaset metasetIn) {
        List<QName> resultList = this.selectorsElementName(pathExp, metasetIn);
        if (resultList != null && resultList.size() > 0) {
            return resultList.get(0);
        }
        return null;
    }

    public List<QName> selectorsElementName(String pathExp, Metaset metasetIn) {
        Metaset tmp = FilterProcessor.getInstance().filter(pathExp, metasetIn);
        if (tmp != null) {
            Iterator<Metaset> children = tmp.elementIterator();
            ArrayList<QName> resultList = new ArrayList<QName>();
            while (children.hasNext()) {
                QName qname = children.next().getQName();
                resultList.add(qname);
            }
            return resultList;
        }
        return null;
    }

    public String selectorAttributeValue(String pathExp, String attrName, Metaset metasetIn) {
        Iterator<Metaset> children;
        Metaset tmp = FilterProcessor.getInstance().filter(pathExp, metasetIn);
        if (tmp != null && (children = tmp.elementIterator()).hasNext()) {
            List<String> resultList;
            block4: {
                Metaset metT = children.next();
                try {
                    resultList = this.getAttributeValueByName(metT, attrName);
                    if (resultList.size() != 0) break block4;
                    return null;
                }
                catch (QNameExpressionException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return resultList.get(0);
        }
        return null;
    }

    public List<String> selectorsAttributeValue(String pathExp, String attrName, Metaset metasetIn) {
        ArrayList<String> resultList = new ArrayList<String>();
        Metaset tmp = FilterProcessor.getInstance().filter(pathExp, metasetIn);
        if (tmp != null) {
            Iterator<Metaset> children = tmp.elementIterator();
            while (children.hasNext()) {
                Metaset metT = children.next();
                try {
                    resultList.addAll(this.getAttributeValueByName(metT, attrName));
                }
                catch (QNameExpressionException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        if (resultList.size() == 0) {
            return null;
        }
        return resultList;
    }

    public List<String> selectorAttributeValueByXPath(String pathExp, String attrName, Metaset metasetIn, Map<String, String> namespaceMap) {
        String newPath = String.valueOf(pathExp) + "/@" + attrName;
        ArrayList<String> attrValues = new ArrayList<String>();
        DefaultXPath xpathExpression = new DefaultXPath(newPath);
        if (namespaceMap != null) {
            xpathExpression.setNamespaceURIs((Map)namespaceMap);
        }
        List attrs = xpathExpression.selectNodes(metasetIn);
        int i = 0;
        while (i < attrs.size()) {
            attrValues.add(((Attribute)attrs.get(i)).getValue());
            ++i;
        }
        return attrValues;
    }

    private List<String> getAttributeValueByName(Metaset metaset, String attrName) throws QNameExpressionException {
        Iterator<Attribute> attrList = metaset.attributeIterator();
        QName attrQName = ExpressionUtil.parseQNameString(attrName);
        ArrayList<String> resultList = new ArrayList<String>();
        while (attrList.hasNext()) {
            Attribute attrT = attrList.next();
            if (!ExpressionUtil.matchAttributeQName(attrQName, attrT.getQName())) continue;
            resultList.add(attrT.getValue());
        }
        for (Namespace ns : metaset.declaredNamespaces()) {
            QName nsQName = null;
            nsQName = ns.getPrefix() == null || ns.getPrefix().equals("") ? new QName(ns.getURI(), "", "xmlns") : new QName(ns.getURI(), ns.getPrefix(), "xmlns");
            if (!ExpressionUtil.matchAttributeQName(attrQName, nsQName)) continue;
            resultList.add(ns.getURI());
        }
        return resultList;
    }
}

