/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.metaset.utils;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.act.xservices.rt.metaset.MetasetBuilder;
import org.act.xservices.rt.metaset.exception.ElementExpressionException;
import org.act.xservices.rt.metaset.exception.QNameExpressionException;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.QName;

public class ExpressionUtil {
    private static final MetasetBuilder metBuilder = MetasetBuilder.getInstance();
    private static final Pattern QNamePattern = Pattern.compile("((([^\\s\\{\\}]+:)|(\\{[^\\s\\{\\}\\\\]+\\}))?[^\\s:][^\\s:\\{\\}=]+)|\\*|\\.");
    private static final Pattern attrPattern = Pattern.compile("(((([^\\s\\{\\}]+:)|(\\{[^\\s\\{\\}\\\\]+\\}))?[^\\s:][^\\s:\\{\\}=]+)|\\*)(=\\'(([^\\'\\\"]+)|\\*)\\')?");

    public static QName parseQNameString(String qnStr) throws QNameExpressionException {
        boolean hasPrefixSeperator;
        String qnStrT = qnStr.trim();
        Matcher qNameMatcher = QNamePattern.matcher(qnStrT);
        if (!qNameMatcher.matches()) {
            throw new QNameExpressionException("Error when match the QName Pattern. For " + qnStrT);
        }
        int ns_Start = qnStrT.indexOf("{");
        int ns_end = qnStrT.indexOf("}");
        boolean hasNamespaceStart = ns_Start != -1;
        boolean hasNamespaceEnd = ns_end != -1;
        boolean bl = hasPrefixSeperator = qnStrT.indexOf(":") != -1;
        if (hasNamespaceStart && hasNamespaceEnd) {
            if (ns_Start == ns_end - 1 || qnStrT.length() == ns_end + 1) {
                throw new QNameExpressionException("Error QName for " + qnStrT);
            }
            String nsURI = qnStrT.substring(ns_Start + 1, ns_end);
            String localpart = qnStrT.substring(ns_end + 1);
            return new QName(localpart, new Namespace("", nsURI));
        }
        if (hasPrefixSeperator && !hasNamespaceStart && !hasNamespaceEnd) {
            StringTokenizer st = new StringTokenizer(qnStrT, ":");
            if (st.countTokens() != 2) {
                throw new QNameExpressionException("Error QName for " + qnStrT);
            }
            String prefix = st.nextToken();
            String localpart = st.nextToken();
            return new QName(localpart, new Namespace(prefix, ""));
        }
        return new QName(qnStrT);
    }

    public static Attribute parseAttributeString(String attrString) throws ElementExpressionException {
        String attrStringT = attrString.trim();
        Matcher attrMatcher = attrPattern.matcher(attrStringT);
        if (!attrMatcher.matches()) {
            throw new ElementExpressionException("Error when match the Attribute Pattern. For " + attrStringT);
        }
        int pos = attrStringT.indexOf("=");
        if (pos != -1) {
            if (pos == attrStringT.length() - 1) {
                throw new ElementExpressionException("Error Attribute for " + attrStringT);
            }
            String temp_Name = attrStringT.substring(0, pos);
            String temp_attrValue = attrStringT.substring(pos + 1);
            QName qn = ExpressionUtil.parseQNameString(temp_Name);
            int pos_Value_Seperator_Start = temp_attrValue.indexOf("'");
            int pos_Value_Seperator_End = temp_attrValue.lastIndexOf("'");
            if (pos_Value_Seperator_Start != 0 || pos_Value_Seperator_End != temp_attrValue.length() - 1) {
                throw new ElementExpressionException("Error Attribute Value String for " + temp_attrValue);
            }
            String attrValue = temp_attrValue.substring(pos_Value_Seperator_Start + 1, pos_Value_Seperator_End);
            return metBuilder.newAttribute(qn, attrValue);
        }
        if (attrStringT.indexOf("'") != -1) {
            throw new ElementExpressionException("Error Attribute name for " + attrStringT);
        }
        QName qn = ExpressionUtil.parseQNameString(attrStringT);
        return metBuilder.newAttribute(qn, "");
    }

    public static boolean matchAttributeQName(QName attrStrQName, QName attrMatchedQName) {
        boolean hasNamespaceURI;
        boolean hasPrefix = !attrStrQName.getNamespacePrefix().equals("");
        boolean bl = hasNamespaceURI = !attrStrQName.getNamespaceURI().equals("");
        if (attrStrQName.getName().equals("*")) {
            return true;
        }
        if (attrStrQName.getName().equals(attrMatchedQName.getName())) {
            if (!hasPrefix && !hasNamespaceURI) {
                return true;
            }
            if (hasPrefix && !hasNamespaceURI && attrStrQName.getNamespacePrefix().equals(attrMatchedQName.getNamespacePrefix())) {
                return true;
            }
            if (hasNamespaceURI && !hasPrefix && attrStrQName.getNamespaceURI().equals(attrMatchedQName.getNamespaceURI())) {
                return true;
            }
            if (hasPrefix && hasNamespaceURI && attrStrQName.getNamespacePrefix().equals(attrMatchedQName.getNamespacePrefix()) && attrStrQName.getNamespaceURI().equals(attrMatchedQName.getNamespaceURI())) {
                return true;
            }
        }
        return false;
    }
}

