/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.io.File;
import java.io.InputStream;
import junit.framework.TestCase;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Branch;
import org.act.xservices.rt.xom.CDATA;
import org.act.xservices.rt.xom.CharacterData;
import org.act.xservices.rt.xom.Comment;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.DocumentType;
import org.act.xservices.rt.xom.Entity;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.NodeType;
import org.act.xservices.rt.xom.ProcessingInstruction;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.Text;
import org.act.xservices.rt.xom.io.SAXReader;
import org.act.xservices.rt.xom.util.NodeComparator;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;

public class AbstractTestCase
extends TestCase {
    protected Document document;

    protected AbstractTestCase() {
    }

    protected AbstractTestCase(String name) {
        super(name);
    }

    protected void log(String text) {
        System.out.println(text);
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Document getDocument(String path) throws Exception {
        return this.getDocument(path, new SAXReader());
    }

    protected Document getDocument(String path, SAXReader reader) throws Exception {
        return reader.read(this.getFile(path));
    }

    protected File getFile(String path) {
        return new File(System.getProperty("user.dir"), "/target/test-classes/" + path);
    }

    protected InputStream getInputStream(String path) {
        return AbstractTestCase.class.getClassLoader().getResourceAsStream(path);
    }

    public void assertDocumentsEqual(Document doc1, Document doc2) throws Exception {
        try {
            AbstractTestCase.assertTrue((String)"Doc1 not null", (doc1 != null ? 1 : 0) != 0);
            AbstractTestCase.assertTrue((String)"Doc2 not null", (doc2 != null ? 1 : 0) != 0);
            doc1.normalize();
            doc2.normalize();
            this.assertNodesEqual(doc1, doc2);
            NodeComparator comparator = new NodeComparator();
            AbstractTestCase.assertTrue((String)"Documents are equal", (comparator.compare(doc1, doc2) == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            this.log("Failed during comparison of: " + doc1 + " and: " + doc2);
            throw e;
        }
    }

    public void assertNodesEqual(Document n1, Document n2) {
        this.assertNodesEqual(n1.getDocType(), n2.getDocType());
        this.assertNodesEqualContent(n1, n2);
    }

    public void assertNodesEqual(Metaset n1, Metaset n2) {
        this.assertNodesEqual(n1.getQName(), n2.getQName());
        int c1 = n1.attributeCount();
        int c2 = n2.attributeCount();
        AbstractTestCase.assertEquals((String)("Elements have same number of attributes (" + c1 + ", " + c2 + " for: " + n1 + " and " + n2), (int)c1, (int)c2);
        int i = 0;
        while (i < c1) {
            Attribute a1 = n1.attribute(i);
            Attribute a2 = n2.attribute(a1.getQName());
            this.assertNodesEqual(a1, a2);
            ++i;
        }
        this.assertNodesEqualContent(n1, n2);
    }

    public void assertNodesEqual(Attribute n1, Attribute n2) {
        this.assertNodesEqual(n1.getQName(), n2.getQName());
        AbstractTestCase.assertEquals((String)("Attribute values for: " + n1 + " and " + n2), (String)n1.getValue(), (String)n2.getValue());
    }

    public void assertNodesEqual(QName n1, QName n2) {
        AbstractTestCase.assertEquals((String)("URIs equal for: " + n1.getQualifiedName() + " and " + n2.getQualifiedName()), (String)n1.getNamespaceURI(), (String)n2.getNamespaceURI());
        AbstractTestCase.assertEquals((String)"qualified names equal", (String)n1.getQualifiedName(), (String)n2.getQualifiedName());
    }

    public void assertNodesEqual(CharacterData t1, CharacterData t2) {
        AbstractTestCase.assertEquals((String)("Text equal for: " + t1 + " and " + t2), (String)t1.getText(), (String)t2.getText());
    }

    public void assertNodesEqual(DocumentType o1, DocumentType o2) {
        if (o1 != o2) {
            if (o1 == null) {
                AbstractTestCase.assertTrue((String)("Missing DocType: " + o2), (boolean)false);
            } else if (o2 == null) {
                AbstractTestCase.assertTrue((String)("Missing DocType: " + o1), (boolean)false);
            } else {
                AbstractTestCase.assertEquals((String)"DocType name equal", (String)o1.getName(), (String)o2.getName());
                AbstractTestCase.assertEquals((String)"DocType publicID equal", (String)o1.getPublicID(), (String)o2.getPublicID());
                AbstractTestCase.assertEquals((String)"DocType systemID equal", (String)o1.getSystemID(), (String)o2.getSystemID());
            }
        }
    }

    public void assertNodesEqual(Entity o1, Entity o2) {
        AbstractTestCase.assertEquals((String)"Entity names equal", (String)o1.getName(), (String)o2.getName());
        AbstractTestCase.assertEquals((String)"Entity values equal", (String)o1.getText(), (String)o2.getText());
    }

    public void assertNodesEqual(ProcessingInstruction n1, ProcessingInstruction n2) {
        AbstractTestCase.assertEquals((String)"PI targets equal", (String)n1.getTarget(), (String)n2.getTarget());
        AbstractTestCase.assertEquals((String)"PI text equal", (String)n1.getText(), (String)n2.getText());
    }

    public void assertNodesEqual(Namespace n1, Namespace n2) {
        AbstractTestCase.assertEquals((String)"Namespace prefixes not equal", (String)n1.getPrefix(), (String)n2.getPrefix());
        AbstractTestCase.assertEquals((String)"Namespace URIs not equal", (String)n1.getURI(), (String)n2.getURI());
    }

    public void assertNodesEqualContent(Branch b1, Branch b2) {
        int c2;
        int c1 = b1.nodeCount();
        if (c1 != (c2 = b2.nodeCount())) {
            this.log("Content of: " + b1);
            this.log("is: " + b1.content());
            this.log("Content of: " + b2);
            this.log("is: " + b2.content());
        }
        AbstractTestCase.assertEquals((String)("Branches have same number of children (" + c1 + ", " + c2 + " for: " + b1 + " and " + b2), (int)c1, (int)c2);
        int i = 0;
        while (i < c1) {
            Node n1 = b1.node(i);
            Node n2 = b2.node(i);
            this.assertNodesEqual(n1, n2);
            ++i;
        }
    }

    public void assertNodesEqual(Node n1, Node n2) {
        short nodeType2;
        short nodeType1 = n1.getNodeType();
        AbstractTestCase.assertTrue((String)"Nodes are of same type: ", (nodeType1 == (nodeType2 = n2.getNodeType()) ? 1 : 0) != 0);
        if (NodeType.ELEMENT_NODE.getCode() == nodeType1) {
            this.assertNodesEqual((Metaset)n1, (Metaset)n2);
        } else if (NodeType.DOCUMENT_NODE.getCode() == nodeType1) {
            this.assertNodesEqual((Document)n1, (Document)n2);
        } else if (NodeType.ATTRIBUTE_NODE.getCode() == nodeType1) {
            this.assertNodesEqual((Attribute)n1, (Attribute)n2);
        } else if (NodeType.TEXT_NODE.getCode() == nodeType1) {
            this.assertNodesEqual((Text)n1, (Text)n2);
        } else if (NodeType.CDATA_SECTION_NODE.getCode() == nodeType1) {
            this.assertNodesEqual((CDATA)n1, (CDATA)n2);
        } else if (NodeType.ENTITY_REFERENCE_NODE.getCode() == nodeType1) {
            this.assertNodesEqual((Entity)n1, (Entity)n2);
        } else if (NodeType.PROCESSING_INSTRUCTION_NODE.getCode() == nodeType1) {
            this.assertNodesEqual((ProcessingInstruction)n1, (ProcessingInstruction)n2);
        } else if (NodeType.COMMENT_NODE.getCode() == nodeType1) {
            this.assertNodesEqual((Comment)n1, (Comment)n2);
        } else if (NodeType.DOCUMENT_TYPE_NODE.getCode() == nodeType1) {
            this.assertNodesEqual((DocumentType)n1, (DocumentType)n2);
        } else if (NodeType.NAMESPACE_NODE.getCode() == nodeType1) {
            this.assertNodesEqual((Namespace)n1, (Namespace)n2);
        } else {
            AbstractTestCase.assertTrue((String)("Invalid node types. node1: " + n1 + " and node2: " + n2), (boolean)false);
        }
    }

    protected void setUp() throws Exception {
        System.setProperty("javax.xml.parsers.SAXParserFactory", SAXParserFactoryImpl.class.getName());
        System.setProperty("javax.xml.transform.TransformerFactory", TransformerFactoryImpl.class.getName());
        this.document = DocumentHelper.createDocument();
        Metaset root = this.document.addElement("root");
        Metaset author1 = root.addElement("author").addAttribute("name", "James").addAttribute("location", "UK").addText("James Strachan");
        Metaset url1 = author1.addElement("url");
        url1.addText("http://sourceforge.net/users/jstrachan/");
        Metaset author2 = root.addElement("author").addAttribute("name", "Bob").addAttribute("location", "Canada").addText("Bob McWhirter");
        Metaset url2 = author2.addElement("url");
        url2.addText("http://sourceforge.net/users/werken/");
    }

    protected Metaset getRootElement() {
        Metaset root = this.document.getRootElement();
        AbstractTestCase.assertTrue((String)"Document has root element", (root != null ? 1 : 0) != 0);
        return root;
    }
}

