/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.QName;

public class AttributeDetachTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(AttributeDetachTest.class);
    }

    public void testDetachAttribute() throws Exception {
        List<? extends Node> attributes = this.document.selectNodes("//@name");
        AttributeDetachTest.assertTrue((String)"Found more than one attribute: ", (attributes.size() > 0 ? 1 : 0) != 0);
        for (Attribute attribute : attributes) {
            Metaset element = attribute.getParent();
            AttributeDetachTest.assertTrue((String)("Attribute: " + attribute + " has parent: " + element), (attribute.getParent() == element ? 1 : 0) != 0);
            QName qname = attribute.getQName();
            Attribute attribute2 = element.attribute(qname);
            String value = attribute.getValue();
            String value2 = element.attributeValue(qname);
            AttributeDetachTest.assertEquals((String)"Attribute and Element have same attrbute value", (String)value, (String)value2);
            attribute.detach();
            attribute2 = element.attribute(qname);
            value2 = element.attributeValue(qname);
            AttributeDetachTest.assertTrue((String)("Element now has no value: " + value2), (value2 == null ? 1 : 0) != 0);
            AttributeDetachTest.assertTrue((String)("Element now has no attribute: " + attribute2), (attribute2 == null ? 1 : 0) != 0);
        }
    }
}

