/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.IllegalAddException;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.io.XMLWriter;

public class BackedListTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(BackedListTest.class);
    }

    public void testXPaths() throws Exception {
        Metaset element = (Metaset)this.document.selectSingleNode("/root");
        this.mutate(element);
        element = (Metaset)this.document.selectSingleNode("//author");
        this.mutate(element);
    }

    public void testAddRemove() throws Exception {
        Metaset parentElement = (Metaset)this.document.selectSingleNode("/root");
        List<Metaset> children = parentElement.elements();
        int lastPos = children.size() - 1;
        Metaset child = children.get(lastPos);
        try {
            children.add(0, child);
            BackedListTest.fail();
        }
        catch (IllegalAddException illegalAddException) {
            // empty catch block
        }
    }

    public void testAddWithIndex() throws Exception {
        DocumentFactory factory = DocumentFactory.getInstance();
        Metaset root = (Metaset)this.document.selectSingleNode("/root");
        List<Metaset> children = root.elements();
        BackedListTest.assertEquals((int)2, (int)children.size());
        children.add(1, factory.createElement("dummy1"));
        children = root.elements();
        BackedListTest.assertEquals((int)3, (int)children.size());
        children = root.elements("author");
        BackedListTest.assertEquals((int)2, (int)children.size());
        children.add(1, factory.createElement("dummy2"));
        children = root.elements();
        BackedListTest.assertEquals((int)4, (int)children.size());
        BackedListTest.assertEquals((String)"dummy1", (String)((Node)children.get(1)).getName());
        BackedListTest.assertEquals((String)"dummy2", (String)((Node)children.get(2)).getName());
        children.add(children.size(), factory.createElement("dummy3"));
        children = root.elements("author");
        children.add(children.size(), factory.createElement("dummy4"));
    }

    protected void mutate(Metaset element) throws Exception {
        DocumentFactory factory = DocumentFactory.getInstance();
        List<Metaset> list = element.elements();
        list.add(factory.createElement("last"));
        list.add(0, factory.createElement("first"));
        List<Metaset> list2 = element.elements();
        BackedListTest.assertTrue((String)"Both lists should contain same number of elements", (list.size() == list2.size() ? 1 : 0) != 0);
        XMLWriter writer = new XMLWriter(System.out);
        this.log("Element content is now: " + element.content());
        writer.write(element);
    }
}

