/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentFactory;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Node;
import org.act.xservices.rt.xom.ProcessingInstruction;

public class ContentTest
extends AbstractTestCase {
    protected DocumentFactory factory = new DocumentFactory();

    public static void main(String[] args) {
        TestRunner.run(ContentTest.class);
    }

    public void testRoot() throws Exception {
        Metaset root = this.document.getRootElement();
        ContentTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        List<Metaset> authors = root.elements("author");
        ContentTest.assertTrue((String)"Root has children", (authors != null && authors.size() == 2 ? 1 : 0) != 0);
        Metaset author1 = authors.get(0);
        Metaset author2 = authors.get(1);
        ContentTest.assertTrue((String)"Author1 is James", (boolean)author1.attributeValue("name").equals("James"));
        ContentTest.assertTrue((String)"Author2 is Bob", (boolean)author2.attributeValue("name").equals("Bob"));
        this.testGetAttributes(author1);
        this.testGetAttributes(author2);
    }

    public void testContent() throws Exception {
        Metaset root = this.document.getRootElement();
        ContentTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        List<Node> content = root.content();
        ContentTest.assertTrue((String)"Root has content", (content != null && content.size() >= 2 ? 1 : 0) != 0);
        boolean iterated = false;
        for (Node object : content) {
            ContentTest.assertTrue((String)"Content object is a node", (boolean)(object instanceof Node));
            iterated = true;
        }
        ContentTest.assertTrue((String)"Iteration completed", (boolean)iterated);
    }

    public void testGetNode() throws Exception {
        Metaset root = this.document.getRootElement();
        ContentTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        int count = root.nodeCount();
        ContentTest.assertTrue((String)"Root has correct node count", (count == 2 ? 1 : 0) != 0);
        boolean iterated = false;
        int i = 0;
        while (i < count) {
            Node node = root.node(i);
            ContentTest.assertTrue((String)"Valid node returned from node()", (node != null ? 1 : 0) != 0);
            iterated = true;
            ++i;
        }
        ContentTest.assertTrue((String)"Iteration completed", (boolean)iterated);
    }

    public void testGetXPathNode() throws Exception {
        Metaset root = this.document.getRootElement();
        ContentTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        int count = root.nodeCount();
        ContentTest.assertTrue((String)"Root has correct node count", (count == 2 ? 1 : 0) != 0);
        boolean iterated = false;
        int i = 0;
        while (i < count) {
            Node node = root.getXPathResult(i);
            ContentTest.assertTrue((String)"Valid node returned from node()", (node != null ? 1 : 0) != 0);
            ContentTest.assertTrue((String)"Node supports the parent relationship", (boolean)node.supportsParent());
            iterated = true;
            ++i;
        }
        ContentTest.assertTrue((String)"Iteration completed", (boolean)iterated);
    }

    public void testOrderOfPI() throws Exception {
        Document document = this.factory.createDocument();
        document.addProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"...\"");
        document.addElement("root");
        List<Node> list = document.content();
        ContentTest.assertNotNull(list);
        ContentTest.assertEquals((int)2, (int)list.size());
        Node pi = list.get(0);
        Node root = list.get(1);
        ContentTest.assertTrue((String)"First element is not a PI", (boolean)(pi instanceof ProcessingInstruction));
        ContentTest.assertTrue((String)"Second element is an element", (boolean)(root instanceof Metaset));
        String xml = "<?xml version=\"1.0\" ?>\n<?xml-stylesheet type=\"text/xsl\" href=\"foo\" ?>\n<root/>";
        document = DocumentHelper.parseText(xml);
        list = document.content();
        ContentTest.assertNotNull(list);
        ContentTest.assertEquals((int)2, (int)list.size());
        pi = list.get(0);
        root = list.get(1);
        ContentTest.assertTrue((String)"First element is not a PI", (boolean)(pi instanceof ProcessingInstruction));
        ContentTest.assertTrue((String)"Second element is an element", (boolean)(root instanceof Metaset));
    }

    public void testAddingInTheMiddle() throws Exception {
        Document doc = this.factory.createDocument();
        Metaset root = doc.addElement("html");
        Metaset header = root.addElement("header");
        Metaset footer = root.addElement("footer");
        List<Node> list = root.content();
        Metaset foo = this.factory.createElement("foo");
        list.add(1, foo);
        ContentTest.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        ContentTest.assertTrue((list.get(0) == header ? 1 : 0) != 0);
        ContentTest.assertTrue((list.get(1) == foo ? 1 : 0) != 0);
        ContentTest.assertTrue((list.get(2) == footer ? 1 : 0) != 0);
    }

    public void testAddAtIndex() throws Exception {
        Document doc = this.factory.createDocument();
        Metaset root = doc.addElement("html");
        Metaset header = root.addElement("header");
        Metaset body = root.addElement("body");
        Metaset foo = this.factory.createElement("foo");
        Metaset bar = this.factory.createElement("bar");
        List<Node> content = header.content();
        content.add(0, foo);
        content.add(0, bar);
        ContentTest.assertEquals((String)"foo", (String)header.node(1).getName());
        ContentTest.assertEquals((String)"bar", (String)header.node(0).getName());
        foo = this.factory.createElement("foo");
        bar = this.factory.createElement("bar");
        content = body.content();
        content.add(0, foo);
        content.add(1, bar);
        ContentTest.assertEquals((String)"foo", (String)body.node(0).getName());
        ContentTest.assertEquals((String)"bar", (String)body.node(1).getName());
    }

    public void testAddAtIndex2() throws Exception {
        Document doc = this.factory.createDocument();
        Metaset parent = doc.addElement("parent");
        Metaset child = parent.addElement("child");
        Metaset anotherChild = this.factory.createElement("child2");
        List<Metaset> elements = parent.elements();
        int index = elements.indexOf(child);
        ContentTest.assertEquals((int)0, (int)index);
        elements.add(1, anotherChild);
        elements = parent.elements();
        ContentTest.assertEquals((Object)child, (Object)elements.get(0));
        ContentTest.assertEquals((Object)anotherChild, (Object)elements.get(1));
    }

    protected void testGetAttributes(Metaset author) throws Exception {
        String definedName = "name";
        String undefinedName = "undefined-attribute-name";
        String defaultValue = "** Default Value **";
        String value = author.attributeValue(definedName, defaultValue);
        ContentTest.assertTrue((String)"Defined value doesn't return specified default value", (value != defaultValue ? 1 : 0) != 0);
        value = author.attributeValue(undefinedName, defaultValue);
        ContentTest.assertTrue((String)"Undefined value returns specified default value", (value == defaultValue ? 1 : 0) != 0);
    }
}

