/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.List;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentType;
import org.act.xservices.rt.xom.dtd.ElementDecl;
import org.act.xservices.rt.xom.dtd.InternalDeclaration;
import org.act.xservices.rt.xom.io.SAXReader;

public class DocTypeTest
extends AbstractTestCase {
    protected static final String INPUT_XML_FILE = "xml/dtd/internal.xml";

    public static void main(String[] args) {
        TestRunner.run(DocTypeTest.class);
    }

    public void testDocType() throws Exception {
        SAXReader reader = new SAXReader();
        reader.setIncludeInternalDTDDeclarations(true);
        Document document = this.getDocument(INPUT_XML_FILE, reader);
        DocumentType docType = document.getDocType();
        DocTypeTest.assertTrue((String)"Has DOCTYPE", (docType != null ? 1 : 0) != 0);
        List<InternalDeclaration> declarations = docType.getInternalDeclarations();
        DocTypeTest.assertTrue((String)"DOCTYPE has declarations", (declarations != null && !declarations.isEmpty() ? 1 : 0) != 0);
        ElementDecl decl = (ElementDecl)((Object)declarations.get(0));
        DocTypeTest.assertEquals((String)"name is correct", (String)"greeting", (String)decl.getName());
        DocTypeTest.assertEquals((String)"model is correct", (String)"(#PCDATA)", (String)decl.getModel());
        String expected = "<!ELEMENT " + decl.getName() + " " + decl.getModel() + ">";
        DocTypeTest.assertEquals((String)"toString() is correct", (String)expected, (String)decl.toString());
    }
}

