/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.act.xservices.rt.xom.Attribute;
import org.act.xservices.rt.xom.CDATA;
import org.act.xservices.rt.xom.Comment;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentType;
import org.act.xservices.rt.xom.Entity;
import org.act.xservices.rt.xom.InvalidXPathException;
import org.act.xservices.rt.xom.Metaset;
import org.act.xservices.rt.xom.Namespace;
import org.act.xservices.rt.xom.NodeFilter;
import org.act.xservices.rt.xom.ProcessingInstruction;
import org.act.xservices.rt.xom.QName;
import org.act.xservices.rt.xom.Text;
import org.act.xservices.rt.xom.XPath;
import org.act.xservices.rt.xom.rule.Pattern;
import org.act.xservices.rt.xom.tree.AbstractDocument;
import org.act.xservices.rt.xom.tree.DefaultAttribute;
import org.act.xservices.rt.xom.tree.DefaultCDATA;
import org.act.xservices.rt.xom.tree.DefaultComment;
import org.act.xservices.rt.xom.tree.DefaultDocument;
import org.act.xservices.rt.xom.tree.DefaultDocumentType;
import org.act.xservices.rt.xom.tree.DefaultElement;
import org.act.xservices.rt.xom.tree.DefaultEntity;
import org.act.xservices.rt.xom.tree.DefaultProcessingInstruction;
import org.act.xservices.rt.xom.tree.DefaultText;
import org.act.xservices.rt.xom.tree.QNameCache;
import org.act.xservices.rt.xom.util.SimpleSingleton;
import org.act.xservices.rt.xom.util.SingletonStrategy;
import org.act.xservices.rt.xom.xpath.DefaultXPath;
import org.act.xservices.rt.xom.xpath.XPathPattern;
import org.jaxen.VariableContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentFactory
implements Serializable {
    private static SingletonStrategy singleton = null;
    protected transient QNameCache cache;
    private Map xpathNamespaceURIs;

    private static SingletonStrategy createSingleton() {
        String documentFactoryClassName;
        SingletonStrategy result = null;
        try {
            documentFactoryClassName = System.getProperty("org.act.xservices.rt.xom.factory", "org.act.xservices.rt.xom.DocumentFactory");
        }
        catch (Exception e) {
            documentFactoryClassName = "org.act.xservices.rt.xom.DocumentFactory";
        }
        try {
            String singletonClass = System.getProperty("org.act.xservices.rt.xom.DocumentFactory.singleton.strategy", "org.act.xservices.rt.xom.util.SimpleSingleton");
            Class<?> clazz = Class.forName(singletonClass);
            result = (SingletonStrategy)clazz.newInstance();
        }
        catch (Exception e) {
            result = new SimpleSingleton();
        }
        result.setSingletonClassName(documentFactoryClassName);
        return result;
    }

    public DocumentFactory() {
        this.init();
    }

    public static synchronized DocumentFactory getInstance() {
        if (singleton == null) {
            singleton = DocumentFactory.createSingleton();
        }
        return (DocumentFactory)singleton.instance();
    }

    public Document createDocument() {
        DefaultDocument answer = new DefaultDocument();
        answer.setDocumentFactory(this);
        return answer;
    }

    public Document createDocument(String encoding) {
        Document answer = this.createDocument();
        if (answer instanceof AbstractDocument) {
            ((AbstractDocument)answer).setXMLEncoding(encoding);
        }
        return answer;
    }

    public Document createDocument(Metaset rootElement) {
        Document answer = this.createDocument();
        answer.setRootElement(rootElement);
        return answer;
    }

    public DocumentType createDocType(String name, String publicId, String systemId) {
        return new DefaultDocumentType(name, publicId, systemId);
    }

    public Metaset createElement(QName qname) {
        return new DefaultElement(qname);
    }

    public Metaset createElement(String name) {
        return this.createElement(this.createQName(name));
    }

    public Metaset createElement(String qualifiedName, String namespaceURI) {
        return this.createElement(this.createQName(qualifiedName, namespaceURI));
    }

    public Attribute createAttribute(Metaset owner, QName qname, String value) {
        return new DefaultAttribute(qname, value);
    }

    public Attribute createAttribute(Metaset owner, String name, String value) {
        return this.createAttribute(owner, this.createQName(name), value);
    }

    public CDATA createCDATA(String text) {
        return new DefaultCDATA(text);
    }

    public Comment createComment(String text) {
        return new DefaultComment(text);
    }

    public Text createText(String text) {
        if (text == null) {
            String msg = "Adding text to an XML document must not be null";
            throw new IllegalArgumentException(msg);
        }
        return new DefaultText(text);
    }

    public Entity createEntity(String name, String text) {
        return new DefaultEntity(name, text);
    }

    public Namespace createNamespace(String prefix, String uri) {
        return Namespace.get(prefix, uri);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return new DefaultProcessingInstruction(target, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, Map data) {
        return new DefaultProcessingInstruction(target, data);
    }

    public QName createQName(String localName, Namespace namespace) {
        return this.cache.get(localName, namespace);
    }

    public QName createQName(String localName) {
        return this.cache.get(localName);
    }

    public QName createQName(String name, String prefix, String uri) {
        return this.cache.get(name, Namespace.get(prefix, uri));
    }

    public QName createQName(String qualifiedName, String uri) {
        return this.cache.get(qualifiedName, uri);
    }

    public XPath createXPath(String xpathExpression) throws InvalidXPathException {
        DefaultXPath xpath = new DefaultXPath(xpathExpression);
        if (this.xpathNamespaceURIs != null) {
            xpath.setNamespaceURIs(this.xpathNamespaceURIs);
        }
        return xpath;
    }

    public XPath createXPath(String xpathExpression, VariableContext variableContext) {
        XPath xpath = this.createXPath(xpathExpression);
        xpath.setVariableContext(variableContext);
        return xpath;
    }

    public NodeFilter createXPathFilter(String xpathFilterExpression, VariableContext variableContext) {
        XPath answer = this.createXPath(xpathFilterExpression);
        answer.setVariableContext(variableContext);
        return answer;
    }

    public NodeFilter createXPathFilter(String xpathFilterExpression) {
        return this.createXPath(xpathFilterExpression);
    }

    public Pattern createPattern(String xpathPattern) {
        return new XPathPattern(xpathPattern);
    }

    public List<QName> getQNames() {
        return this.cache.getQNames();
    }

    public Map<String, String> getXPathNamespaceURIs() {
        return this.xpathNamespaceURIs;
    }

    public void setXPathNamespaceURIs(Map<String, String> namespaceURIs) {
        this.xpathNamespaceURIs = namespaceURIs;
    }

    protected static DocumentFactory createSingleton(String className) {
        try {
            Class<?> theClass = Class.forName(className, true, DocumentFactory.class.getClassLoader());
            return (DocumentFactory)theClass.newInstance();
        }
        catch (Throwable e) {
            System.out.println("WARNING: Cannot load DocumentFactory: " + className);
            return new DocumentFactory();
        }
    }

    protected QName intern(QName qname) {
        return this.cache.intern(qname);
    }

    protected QNameCache createQNameCache() {
        return new QNameCache(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    protected void init() {
        this.cache = this.createQNameCache();
    }
}

