/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.io.SAXReader;
import org.xml.sax.InputSource;

public class GetXMLEncodingTest
extends AbstractTestCase {
    public static void main(String[] args) {
        TestRunner.run(GetXMLEncodingTest.class);
    }

    public void testXMLEncodingFromString() throws Exception {
        String xmlEnc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root/>";
        SAXReader reader = new SAXReader();
        InputSource source = new InputSource(new ByteArrayInputStream(xmlEnc.getBytes("UTF-8")));
        Document doc = reader.read(source);
        GetXMLEncodingTest.assertEquals((String)"UTF-8", (String)doc.getXMLEncoding());
        doc = reader.read(new StringReader(xmlEnc));
        GetXMLEncodingTest.assertNull((Object)doc.getXMLEncoding());
    }

    public void testXMLEncodingFromURL() throws Exception {
        Document doc = this.getDocument("xml/test/encode.xml");
        GetXMLEncodingTest.assertEquals((String)"UTF-8", (String)doc.getXMLEncoding());
        doc = this.getDocument("xml/russArticle.xml");
        GetXMLEncodingTest.assertEquals((String)"koi8-r", (String)doc.getXMLEncoding());
    }

    public void testXMLEncodingFromStringWithHelper() throws Exception {
        String xmlEnc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root/>";
        String xmlNoEnc = "<root/>";
        Document doc = DocumentHelper.parseText(xmlEnc);
        GetXMLEncodingTest.assertEquals((String)"UTF-8", (String)doc.getXMLEncoding());
        doc = DocumentHelper.parseText(xmlNoEnc);
        GetXMLEncodingTest.assertNull((Object)doc.getXMLEncoding());
    }
}

