/*
 * Decompiled with CFR 0.152.
 */
package org.act.xservices.rt.xom;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.textui.TestRunner;
import org.act.xservices.rt.xom.AbstractTestCase;
import org.act.xservices.rt.xom.Document;
import org.act.xservices.rt.xom.DocumentHelper;
import org.act.xservices.rt.xom.Metaset;

public class IteratorTest
extends AbstractTestCase {
    private static final int NUMELE = 10;
    protected Document iterDocument;

    public static void main(String[] args) {
        TestRunner.run(IteratorTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.iterDocument = DocumentHelper.createDocument();
        Metaset root = this.iterDocument.addElement("root");
        int i = 0;
        while (i < 10) {
            root.addElement("iterator test").addAttribute("instance", Integer.toString(i));
            ++i;
        }
    }

    public void testElementCount() throws Exception {
        Metaset root = this.iterDocument.getRootElement();
        IteratorTest.assertTrue((String)"Has root element", (root != null ? 1 : 0) != 0);
        List<Metaset> elements = root.elements("iterator test");
        int elementSize = elements.size();
        IteratorTest.assertTrue((String)("Root has " + elementSize + " children"), (elements != null && elementSize == 10 ? 1 : 0) != 0);
    }

    public void testPlainIteration() throws Exception {
        Metaset root = this.iterDocument.getRootElement();
        List<Metaset> elements = root.elements("iterator test");
        Iterator<Metaset> iter = root.elementIterator("iterator test");
        int elementSize = elements.size();
        int count = 0;
        while (iter.hasNext()) {
            Metaset e = iter.next();
            IteratorTest.assertEquals((String)("instance " + e.attribute("instance").getValue() + " equals " + count), (String)e.attribute("instance").getValue(), (String)Integer.toString(count));
            ++count;
        }
        IteratorTest.assertTrue((String)(String.valueOf(elementSize) + " elements iterated"), (count == elementSize ? 1 : 0) != 0);
    }

    public void testSkipAlternates() throws Exception {
        Metaset root = this.iterDocument.getRootElement();
        List<Metaset> elements = root.elements("iterator test");
        Iterator<Metaset> iter = root.elementIterator("iterator test");
        int elementSize = elements.size();
        int count = 0;
        while (iter.hasNext()) {
            Metaset e = iter.next();
            IteratorTest.assertEquals((String)("instance " + e.attribute("instance").getValue() + " equals " + count * 2), (String)e.attribute("instance").getValue(), (String)Integer.toString(count * 2));
            iter.next();
            ++count;
        }
        IteratorTest.assertTrue((String)(String.valueOf(elementSize / 2) + " alternate elements iterated"), (count == elementSize / 2 ? 1 : 0) != 0);
    }

    public void testNoHasNext() throws Exception {
        Metaset root = this.iterDocument.getRootElement();
        List<Metaset> elements = root.elements("iterator test");
        Iterator<Metaset> iter = root.elementIterator("iterator test");
        int elementSize = elements.size();
        int count = 0;
        Metaset e = null;
        while (count < elementSize) {
            e = iter.next();
            IteratorTest.assertEquals((String)("instance " + e.attribute("instance").getValue() + " equals " + count), (String)e.attribute("instance").getValue(), (String)Integer.toString(count));
            System.out.println("instance " + e.attribute("instance").getValue() + " equals " + count);
            ++count;
        }
        try {
            e = iter.next();
            if (e != null) {
                IteratorTest.assertTrue((String)("no more elements,value instead is " + e.attribute("instance").getValue()), (e == null ? 1 : 0) != 0);
            }
        }
        catch (Exception exp) {
            IteratorTest.assertTrue((String)"Real iterators throw NoSuchElementException", (boolean)(exp instanceof NoSuchElementException));
        }
    }

    public void testExtraHasNexts() throws Exception {
        Metaset root = this.iterDocument.getRootElement();
        List<Metaset> elements = root.elements("iterator test");
        Iterator<Metaset> iter = root.elementIterator("iterator test");
        int elementSize = elements.size();
        int count = 0;
        while (iter.hasNext()) {
            Metaset e = iter.next();
            IteratorTest.assertEquals((String)("instance " + e.attribute("instance").getValue() + " equals " + count), (String)e.attribute("instance").getValue(), (String)Integer.toString(count));
            iter.hasNext();
            ++count;
        }
        IteratorTest.assertTrue((String)(String.valueOf(elementSize) + " elements iterated with extra hasNexts"), (count == elementSize ? 1 : 0) != 0);
    }
}

